/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.processors;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.lc.UploadUtils;
import com.manageengine.ela.server.importlog.ImportFilters;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.processors.BaseLogProcessor;
import com.manageengine.ela.server.importlog.report.ReportApplyWhenCondition;
import com.manageengine.ela.server.importlog.report.ReportFields;
import com.manageengine.ela.server.importlog.report.SeverityCounter;
import com.manageengine.ela.server.importlog.report.SubReportCounter;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;
import org.json.JSONException;

public class BaseLogProcessorBean {
    private static final Logger LOGGER = Logger.getLogger(BaseLogProcessor.class.getName());
    public ImportFilters importFilters = null;
    public long indexCount = 0L;
    public long importedTime = 0L;
    public boolean isThrowAway = false;
    public SeverityCounter severityCounter = new SeverityCounter();
    public Integer hourOfDay = LocalTime.now().getHour();
    public String timeForReport = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00:00"));
    public ArrayList<ReportApplyWhenCondition> reportApplyWhenConditions;
    public SubReportCounter subReportCounter;
    public Collection<String> colList = new LinkedHashSet<String>();

    public synchronized boolean insertToIndex(HashMap<String, Object> fields, BaseLogProcessorBean baseLogProcessorBean) throws JSONException {
        boolean status = true;
        if (baseLogProcessorBean.importFilters != null) {
            status = baseLogProcessorBean.importFilters.applyAllFilters(fields);
        }
        if (status) {
            if (fields.containsKey("COMMON_SEVERITY")) {
                switch (String.valueOf(fields.get("COMMON_SEVERITY")).toUpperCase()) {
                    case "CRITICAL": {
                        baseLogProcessorBean.severityCounter.incrementCritical();
                        break;
                    }
                    case "ERROR": {
                        baseLogProcessorBean.severityCounter.incrementError();
                        break;
                    }
                    case "WARNING": {
                        baseLogProcessorBean.severityCounter.incrementWarning();
                        break;
                    }
                    default: {
                        baseLogProcessorBean.severityCounter.incrementInformation();
                        fields.remove("COMMON_SEVERITY");
                        fields.put("COMMON_SEVERITY", "INFORMATION");
                        break;
                    }
                }
            } else {
                fields.put("COMMON_SEVERITY", "INFORMATION");
                baseLogProcessorBean.severityCounter.incrementInformation();
            }
            if (fields.containsKey("HOUROFDAY")) {
                baseLogProcessorBean.hourOfDay = NumberUtils.toInt((String)String.valueOf(fields.remove("HOUROFDAY")));
            }
            if (fields.containsKey("HOUR")) {
                baseLogProcessorBean.timeForReport = (String)fields.remove("HOUR");
            }
            StringBuilder matchingReports = new StringBuilder();
            ArrayList<Long> matchedReportIds = new ArrayList<Long>();
            for (ReportApplyWhenCondition reportApplyWhenCondition : baseLogProcessorBean.reportApplyWhenConditions) {
                if (!reportApplyWhenCondition.isConditionSatisfied(fields) || matchedReportIds.contains(reportApplyWhenCondition.getRuleID())) continue;
                ReportFields reportFieldValues = new ReportFields();
                Map<Long, String> reportFieldMap = reportApplyWhenCondition.getReportFields();
                Optional firstFieldKey = reportFieldMap.keySet().stream().findFirst();
                if (!firstFieldKey.isPresent() || !fields.containsKey(reportFieldMap.get(firstFieldKey.get()))) continue;
                for (Long key : reportFieldMap.keySet()) {
                    reportFieldValues.add((String)fields.get(reportFieldMap.get(key)));
                }
                matchedReportIds.add(reportApplyWhenCondition.getRuleID());
                matchingReports.append(reportApplyWhenCondition.getReportName().replaceAll("\\p{Punct}", "")).append(" ");
                baseLogProcessorBean.subReportCounter.add(reportApplyWhenCondition.getRuleID(), baseLogProcessorBean.hourOfDay, baseLogProcessorBean.timeForReport, reportFieldValues, reportApplyWhenCondition.getFieldType());
            }
            String matchingReport = matchingReports.toString();
            if (!Strings.isNullOrEmpty((String)matchingReport)) {
                fields.put("MATCHING_REPORTS", matchingReports.toString());
            }
            if (!fields.containsKey("MESSAGE") && fields.get("RAWLOG") != null) {
                fields.put("MESSAGE", ((String)fields.get("RAWLOG")).replaceAll("\\t|\\n|\\x0B|\\f|\\r", " "));
            }
            ++baseLogProcessorBean.indexCount;
            baseLogProcessorBean.colList.addAll(fields.keySet());
            if (!((Boolean)fields.getOrDefault("ISEVT", false)).booleanValue()) {
                fields.remove("HOSTTYPE");
            }
            fields.remove("ISEVT");
            LogIndexingAPI.getInstance().indexRecord(fields);
            UploadUtils.uploadLogs(fields);
        }
        return status;
    }

    public synchronized void updateDbTrendCount(LogProperties logProperties, BaseLogProcessorBean baseLogProcessorBean, Boolean allowRetry) {
        if (baseLogProcessorBean.severityCounter.getTotal() <= 0L) {
            return;
        }
        try {
            Persistence persistence = PersistenceDBUtil.getPersistence();
            DataObject dataObject = persistence.constructDataObject();
            Row severityRow = new Row("ela_import_app_hr_trend_sa");
            severityRow.set("APPID", (Object)logProperties.getAppId());
            severityRow.set("HOUROFDAY", (Object)baseLogProcessorBean.hourOfDay);
            severityRow.set("HOUR", (Object)baseLogProcessorBean.timeForReport);
            severityRow.set("CRITICAL_CNT", (Object)baseLogProcessorBean.severityCounter.getCritical());
            severityRow.set("ERROR_CNT", (Object)baseLogProcessorBean.severityCounter.getError());
            severityRow.set("WARNING_CNT", (Object)baseLogProcessorBean.severityCounter.getWarning());
            severityRow.set("INFORMATION_CNT", (Object)baseLogProcessorBean.severityCounter.getInformation());
            severityRow.set("TOTAL_CNT", (Object)baseLogProcessorBean.severityCounter.getTotal());
            severityRow.set("IMPORTED_TIME", (Object)this.importedTime);
            severityRow.set("IS_THROWAWAY", (Object)(this.isThrowAway ? "true" : "false"));
            this.subReportCounter.setReportId(logProperties.getReportId());
            ArrayList<Row> reportRows = baseLogProcessorBean.subReportCounter.getReportRows(this.importedTime, this.isThrowAway);
            for (Row reportRow : reportRows) {
                dataObject.addRow(reportRow);
            }
            dataObject.addRow(severityRow);
            persistence.add(dataObject);
        }
        catch (Exception e) {
            LOGGER.info("IMPLOG : SQL Exception while updating trend count into database");
            if (allowRetry.booleanValue()) {
                this.updateDbTrendCount(logProperties, baseLogProcessorBean, false);
            }
            e.printStackTrace();
        }
        baseLogProcessorBean.severityCounter.reset();
    }
}

