/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.processors;

import com.adventnet.la.fieldgen.CustomLogTypePatterns;
import com.manageengine.ela.server.common.io.file.parser.ExtractedResultListener;
import com.manageengine.ela.server.importlog.LogBuilder;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.parser.field.extractor.BaseFieldExtractor;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomLogProcessor {
    private static final Logger LOGGER = Logger.getLogger(CustomLogProcessor.class.getName());
    private String fileName;
    private Set<String> parsedFieldKeys = new HashSet<String>();
    private JSONObject formatObject = new JSONObject();
    private JSONArray extractedLogs = new JSONArray();

    public void process(LogProperties logProperties) throws Exception {
        LogBuilder logBuilder = new LogBuilder(logProperties);
        logBuilder.setIsCustomFieldExtraction(true);
        logBuilder.open();
        logProperties.setLastImport(System.currentTimeMillis());
        Iterator iterator = logBuilder.iterator();
        this.fileName = logProperties.getFileName();
        BaseFieldExtractor fieldExtractor = ExtractedResultListener.getFieldExtractor(logProperties.getLogFormatId(), logBuilder);
        if (logProperties.getLogFormatId() > 0L) {
            this.formatObject.put("LogType", (Object)FormatIdentifier.getFormatDesc(logProperties.getLogFormatId()));
        }
        LOGGER.info("IMPLOG : " + logProperties.getCompleteFilePath() + " Import Started");
        logProperties.setStatus(12195L);
        logProperties.setSize(logBuilder.getTotalFileSize());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
        LinkedHashSet matchingDefPatternIds = new LinkedHashSet();
        while (iterator.hasNext() && this.extractedLogs.length() < 50) {
            HashMap<String, Object> extractedFields;
            List matchingDefIds = Collections.EMPTY_LIST;
            String logLine = iterator.next().toString();
            if (Strings.isNullOrEmpty((String)logLine) || (extractedFields = fieldExtractor.getFieldsAsMap(logLine)) == null) continue;
            if (extractedFields.containsKey("")) {
                extractedFields.remove("");
            }
            if (extractedFields.containsKey("SKIP_THIS_LOG") && extractedFields.get("SKIP_THIS_LOG").equals("1")) continue;
            if (logProperties.getLogFormatId() < 0L) {
                extractedFields.put("FORMATID", "-");
            } else {
                extractedFields.put("FORMATID", logProperties.getLogFormatId());
                extractedFields.put("LOGTYPE", this.formatObject.get("LogType"));
            }
            if (extractedFields.containsKey("HOUR")) {
                extractedFields.remove("HOUR");
            }
            if (extractedFields.containsKey("HOUROFDAY")) {
                extractedFields.remove("HOUROFDAY");
            }
            if (extractedFields.containsKey("TIME")) {
                Long timeInMillis = NumberUtils.toLong((String)extractedFields.get("TIME").toString());
                extractedFields.put("TIME", simpleDateFormat.format(timeInMillis));
            } else {
                extractedFields.put("TIME", simpleDateFormat.format(System.currentTimeMillis()));
            }
            extractedFields.put("RAWLOG", logLine);
            matchingDefIds = CustomLogTypePatterns.applyAllCommonPatterns((String)logLine, extractedFields);
            matchingDefPatternIds.addAll(matchingDefIds);
            this.insertToArray(extractedFields);
        }
        this.formatObject.put("MatchingDefIds", (Object)new JSONArray(matchingDefPatternIds));
        logBuilder.close();
    }

    private void insertToArray(HashMap<String, Object> extractedFields) throws JSONException {
        JSONObject extractedLogJSONObject = new JSONObject();
        extractedLogJSONObject.put("MESSAGE", extractedFields.remove("RAWLOG"));
        Set<String> keys = extractedFields.keySet();
        for (String key : keys) {
            extractedLogJSONObject.put(key, extractedFields.get(key));
        }
        this.parsedFieldKeys.addAll(extractedFields.keySet().stream().map(s -> s.replaceAll("[\"']", "")).collect(Collectors.toList()));
        this.extractedLogs.put((Object)extractedLogJSONObject);
    }

    public String getFileName() {
        return this.fileName;
    }

    public JSONArray getParsedFieldKeys() {
        return new JSONArray(this.parsedFieldKeys);
    }

    public JSONArray getExtractedLogs() {
        return this.extractedLogs;
    }

    public JSONObject getFormatObject() {
        return this.formatObject;
    }
}

