/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols;

import com.manageengine.ela.server.common.io.file.pattern.filter.DynamicFileNameFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import com.manageengine.ela.server.importlog.protocols.ImportFileNameBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseProtocolHandler {
    protected String filePath;
    protected ImportProtocolBean importProtocolBean;
    protected FileSource fileSource = null;
    protected LogProperties logProperties;
    protected boolean isFileExists = false;

    public BaseProtocolHandler(String filePath, ImportProtocolBean importProtocolBean, LogProperties logProperties) {
        this.filePath = filePath;
        this.importProtocolBean = importProtocolBean;
        this.logProperties = logProperties;
    }

    public abstract boolean checkFileExistence() throws BaseStatusCode;

    public abstract FileSource downloadFile(String var1) throws IOException, BaseStatusCode;

    public abstract long getFileSize() throws BaseStatusCode;

    public ArrayList<JSONObject> listFiles(String deviceName, String location, JSONObject returnObject) throws Exception {
        ArrayList<JSONObject> fileNameObjects = new ArrayList<JSONObject>();
        ArrayList<ImportFileNameBean> importFileNames = this.listFiles(deviceName, location, returnObject, null);
        importFileNames.stream().forEachOrdered(importFileNameBean -> {
            try {
                fileNameObjects.add(ImportProtocolUtils.getFileJSONObject(importFileNameBean.isDirectory(), importFileNameBean.getParentDirectoryLocation(), importFileNameBean.getFileName()));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        });
        return fileNameObjects;
    }

    public abstract ArrayList<ImportFileNameBean> listFiles(String var1, String var2, JSONObject var3, DynamicFileNameFilter var4) throws Exception;

    public abstract void close() throws BaseStatusCode;
}

