/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols;

import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.persistence.DataAccessException;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ImportProtocolBean {
    private long protocolId;
    private String protocolHandlerClass = null;
    private String type = null;
    private String protocolName = null;
    private String deviceName = null;
    private String username = null;
    private String password = null;
    private Integer port = null;

    public ImportProtocolBean(long protocolId) {
        this.protocolId = protocolId;
    }

    public ImportProtocolBean(long protocolId, String username, String password) {
        this.protocolId = protocolId;
        this.username = username;
        this.password = password;
    }

    public ImportProtocolBean() throws BaseStatusCode, DataAccessException {
        this.protocolId = ImportProtocolUtils.getProtocolId("SMB-Windows");
    }

    public long getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(long protocolId) {
        this.protocolId = protocolId;
    }

    public String getProtocolHandlerClass() {
        return this.protocolHandlerClass;
    }

    public void setProtocolHandlerClass(String protocolHandlerClass) {
        this.protocolHandlerClass = protocolHandlerClass;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        if (deviceName == null || deviceName.isEmpty() || deviceName.equalsIgnoreCase("localhost")) {
            try {
                deviceName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        this.deviceName = deviceName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return EnDecryptImplSingleton.getInstance().decrypt(this.password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}

