/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportProtocolUtils {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static Cache<Long, String> importProtocolHandlerCache = new Cache();
    private static Cache<Long, String> importProtocolNameCache = new Cache();

    public static String getProtocolName(Long protocolId) throws DataAccessException {
        if (importProtocolNameCache.containsKey(protocolId) && importProtocolNameCache.get(protocolId) != null) {
            return importProtocolNameCache.get(protocolId);
        }
        ImportProtocolUtils.populateProtocolDetails(protocolId);
        return importProtocolNameCache.get(protocolId);
    }

    public static String getProtocolHandlerName(Long protocolId) throws DataAccessException {
        if (importProtocolHandlerCache.containsKey(protocolId) && importProtocolHandlerCache.get(protocolId) != null) {
            return importProtocolHandlerCache.get(protocolId);
        }
        ImportProtocolUtils.populateProtocolDetails(protocolId);
        return importProtocolHandlerCache.get(protocolId);
    }

    private static void populateProtocolDetails(Long protocolId) throws DataAccessException {
        Iterator iterator;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportProtocols"));
        Column pkColumn = Column.getColumn((String)"ELAImportProtocols", (String)"PROTOCOL_ID");
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportProtocols", (String)"*"));
        Criteria criteria = new Criteria(pkColumn, (Object)protocolId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCELITE.get((SelectQuery)selectQuery);
        if (dataObject != null && (iterator = dataObject.getRows("ELAImportProtocols")).hasNext()) {
            Row protocolDetailsRow = (Row)iterator.next();
            String protocolName = (String)protocolDetailsRow.get("PROTOCOL_NAME");
            String protocolHandler = (String)protocolDetailsRow.get("PROTOCOL_HANDLER");
            importProtocolNameCache.put(protocolId, protocolName);
            importProtocolHandlerCache.put(protocolId, protocolHandler);
        }
    }

    public static ImportProtocolBean getImportProtocolBeanFromDb(Long sourceId) throws DataAccessException, JSONException {
        ImportProtocolBean importProtocolBean = null;
        SelectQuery selectQuery = ImportUtils.getDefaultImportSelectQuery();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCELITE.get(selectQuery);
        if (!dataObject.isEmpty()) {
            Iterator importSourceConfigurationIterator = dataObject.getRows("ELAImportSourceConfigurations");
            Iterator protocolIterator = dataObject.getRows("ELAImportProtocols");
            Iterator remoteDeviceIterator = dataObject.getRows("ElaImportRemoteDeviceConfiguration");
            if (importSourceConfigurationIterator.hasNext() && protocolIterator.hasNext() && remoteDeviceIterator.hasNext()) {
                Row importSourceConfigurationRow = (Row)importSourceConfigurationIterator.next();
                Row protocolsRow = (Row)protocolIterator.next();
                Row remoteDeviceRow = (Row)remoteDeviceIterator.next();
                String deviceAddress = (String)remoteDeviceRow.get("COMPUTER_NAME");
                Long protocolId = NumberUtils.toLong((String)importSourceConfigurationRow.get("PROTOCOL_ID").toString());
                Long credentialId = (Long)remoteDeviceRow.get("CREDENTIAL_ID");
                Long customPort = (Long)importSourceConfigurationRow.get("CUSTOM_PORT");
                String protocolName = (String)protocolsRow.get("PROTOCOL_NAME");
                Object default_port = protocolsRow.get("DEFAULT_PORT");
                String protocolHandlerClass = (String)protocolsRow.get("PROTOCOL_HANDLER");
                String type = (String)protocolsRow.get("TYPE");
                importProtocolBean = new ImportProtocolBean(protocolId);
                importProtocolBean.setDeviceName(deviceAddress);
                importProtocolBean.setProtocolName(protocolName);
                importProtocolBean.setProtocolHandlerClass(protocolHandlerClass);
                importProtocolBean.setType(type);
                if (credentialId != null) {
                    Iterator credentialIterator = dataObject.getRows("ELACredentials");
                    Row credentialRow = (Row)credentialIterator.next();
                    importProtocolBean.setUsername((String)credentialRow.get("USERNAME"));
                    importProtocolBean.setPassword(EnDecryptImplSingleton.getInstance().decrypt((String)credentialRow.get("PASSWORD")));
                } else {
                    Credential credential = DeviceUtil.getExistingCredential(deviceAddress);
                    if (credential != null) {
                        importProtocolBean.setUsername(credential.getUserName());
                        importProtocolBean.setPassword(credential.getPassword());
                    }
                }
                if (customPort != null) {
                    importProtocolBean.setPort(NumberUtils.toInt((String)customPort.toString()));
                } else if (default_port != null) {
                    importProtocolBean.setPort(NumberUtils.toInt((String)default_port.toString()));
                }
            }
        }
        return importProtocolBean;
    }

    public static JSONObject getFileJSONObject(boolean isDir, String location, String fileName) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        if (isDir) {
            jsonObject.put("isDir", true);
        } else {
            jsonObject.put("isDir", false);
        }
        jsonObject.put("id", (Object)(location + fileName).replaceAll("[^a-zA-Z0-9]", ""));
        jsonObject.put("display_name", (Object)fileName.replace("\\", "/"));
        return jsonObject;
    }

    public static boolean isIpAddressLocal(String ipAddress) {
        boolean status;
        try {
            InetAddress addr = InetAddress.getByName(ipAddress);
            boolean bl = status = addr.getHostName().equalsIgnoreCase(InetAddress.getLocalHost().getHostName()) || addr.isLoopbackAddress();
            if (!status) {
                status = addr.getHostAddress().equals(InetAddress.getLocalHost().getHostAddress());
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        return status;
    }

    public static Long getProtocolId(String protocolName) throws BaseStatusCode, DataAccessException {
        Iterator protocolIterator;
        if (protocolName == null || protocolName.isEmpty()) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportProtocols", (String)"PROTOCOL_NAME"), (Object)protocolName, 0);
        DataObject protocolDataObject = PERSISTENCELITE.get("ELAImportProtocols", criteria);
        if (!protocolDataObject.isEmpty() && (protocolIterator = protocolDataObject.getRows("ELAImportProtocols")).hasNext()) {
            Row protocolRow = (Row)protocolIterator.next();
            return NumberUtils.toLong((String)String.valueOf(protocolRow.get("PROTOCOL_ID")));
        }
        throw BaseStatusCode.getBaseStatusCode(7428);
    }

    public static BaseProtocolHandler resolveProtocolHandler(LogProperties logProperties) throws DataAccessException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, BaseStatusCode, IOException, JSONException {
        Long sourceId = logProperties.getSourceId();
        ImportProtocolBean importProtocolBean = logProperties.getImportProtocolBean();
        if (sourceId < 0L && importProtocolBean != null) {
            String importProtocolHandler = ImportProtocolUtils.getProtocolHandlerName(importProtocolBean.getProtocolId());
            importProtocolBean.setProtocolHandlerClass(importProtocolHandler);
        } else {
            importProtocolBean = ImportProtocolUtils.getImportProtocolBeanFromDb(sourceId);
        }
        Class<?> dynamicClass = Class.forName(importProtocolBean.getProtocolHandlerClass());
        if (dynamicClass == null) {
            throw BaseStatusCode.getBaseStatusCode(12034);
        }
        BaseProtocolHandler model = (BaseProtocolHandler)dynamicClass.getConstructor(String.class, ImportProtocolBean.class, LogProperties.class).newInstance(logProperties.getCompleteFilePath(), importProtocolBean, logProperties);
        if (model.checkFileExistence()) {
            return model;
        }
        return null;
    }
}

