/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols.list;

import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.io.file.FileUtils;
import com.manageengine.ela.server.common.io.file.pattern.filter.DynamicFileNameFilter;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFileProperties;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportFileNameBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.elasticsearch.common.Strings;
import org.json.JSONObject;

public class EthernetFileImportProtocol
extends BaseProtocolHandler {
    private SmbFile smbFile = null;
    private File localFile = null;
    private boolean isRemote = true;
    private static final Pattern FILE_PATH_MATCHER = Pattern.compile("[\\\\|\\/]*(.*)");
    private static final Pattern LOCAL_DRIVE_MATCHER = Pattern.compile("\\w{1,2}:.*");

    public EthernetFileImportProtocol(String filePath, ImportProtocolBean importProtocolBean, LogProperties logProperties) {
        super(filePath, importProtocolBean, logProperties);
        this.filePath = this.normalizeFilePath(filePath);
    }

    private String normalizeFilePath(String filePath) {
        Matcher matcher;
        if (Strings.isNullOrEmpty((String)filePath)) {
            return filePath;
        }
        if (!(filePath = filePath.replace("\\", "/")).endsWith("/")) {
            filePath = filePath + "/";
        }
        if ((filePath.startsWith("\\") || filePath.startsWith("/")) && ServerDetailsBean.getInstance().isWindows() && (matcher = FILE_PATH_MATCHER.matcher(filePath)).find()) {
            return matcher.group(1);
        }
        return filePath;
    }

    @Override
    public boolean checkFileExistence() throws BaseStatusCode {
        boolean bl = this.isRemote = !ImportProtocolUtils.isIpAddressLocal(this.importProtocolBean.getDeviceName());
        if (this.isRemote && !Strings.isNullOrEmpty((String)this.importProtocolBean.getUsername()) && !this.logProperties.isLocalImport()) {
            String username = this.importProtocolBean.getUsername();
            String domain = "";
            if (!Strings.isNullOrEmpty((String)username) && username.contains("\\") && !username.endsWith("\\")) {
                domain = username.substring(0, username.lastIndexOf("\\"));
                username = username.substring(username.lastIndexOf("\\") + 1);
            }
            NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(domain, username, this.importProtocolBean.getPassword());
            String url = this.importProtocolBean.getDeviceName() + "/" + this.filePath.replace(":", "$");
            try {
                this.smbFile = new SmbFile("smb://" + url, auth);
                this.isFileExists = this.smbFile.exists() && this.smbFile.isFile();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            catch (SmbAuthException e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(7426);
            }
            catch (SmbException e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(7175);
            }
        } else {
            String tempLoc = this.logProperties.getCompleteFilePath();
            if (ServerDetailsBean.getInstance().isWindows()) {
                if (!this.logProperties.isLocalImport()) {
                    tempLoc = "\\\\" + this.logProperties.getLinkedDeviceName() + "\\" + this.logProperties.getCompleteFilePath().replaceAll("/", "\\\\").replace(':', '$');
                }
            } else {
                tempLoc = tempLoc.replaceAll("\\\\", "/");
            }
            this.localFile = new File(tempLoc);
            this.isFileExists = this.localFile.exists() && this.localFile.isFile();
        }
        return this.isFileExists;
    }

    @Override
    public FileSource downloadFile(String location) throws BaseStatusCode {
        if (this.smbFile == null && this.localFile == null) {
            this.checkFileExistence();
        }
        if (!this.isFileExists) {
            return null;
        }
        try {
            InputStream inputStream;
            ImportFileProperties fileProperties;
            String fileName;
            if (this.filePath.endsWith("/")) {
                String tempFilePath = this.filePath.substring(0, this.filePath.length() - 1);
                fileName = tempFilePath.substring(tempFilePath.lastIndexOf(47) + 1, tempFilePath.length());
            } else {
                fileName = this.filePath.substring(this.filePath.lastIndexOf(47) + 1, this.filePath.length());
            }
            if (this.isRemote && !Strings.isNullOrEmpty((String)this.importProtocolBean.getUsername()) && !this.logProperties.isLocalImport()) {
                if (this.smbFile == null) {
                    return null;
                }
                fileProperties = new ImportFileProperties(false, location + File.separator + URLDecoder.decode(fileName, "UTF8"), this.logProperties);
                inputStream = this.smbFile.getInputStream();
            } else {
                fileProperties = new ImportFileProperties(true, this.localFile.getPath(), this.logProperties);
                inputStream = new FileInputStream(this.localFile.getPath());
            }
            this.fileSource = FileUtils.getBufferReaderList(inputStream, fileProperties, this.logProperties);
            FileInputStream finalInputStream = inputStream;
            this.fileSource.addFutureTasks(new FutureTask<Object>(() -> {
                if (finalInputStream != null) {
                    finalInputStream.close();
                }
                return null;
            }));
            return this.fileSource;
        }
        catch (BaseStatusCode e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(6657);
        }
    }

    @Override
    public long getFileSize() throws BaseStatusCode {
        if (this.isRemote && !Strings.isNullOrEmpty((String)this.importProtocolBean.getUsername()) && !this.logProperties.isLocalImport()) {
            try {
                if (this.fileSource.getFileSize() > 0L) {
                    return this.fileSource.getFileSize();
                }
                return this.smbFile.length();
            }
            catch (SmbException e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(6657);
            }
        }
        if (this.fileSource.getFileSize() > 0L) {
            return this.fileSource.getFileSize();
        }
        return this.localFile.length();
    }

    @Override
    public ArrayList<ImportFileNameBean> listFiles(String deviceName, String location, JSONObject returnObject, DynamicFileNameFilter dynamicFileNameFilter) throws Exception {
        try {
            if (!CommonUtil.isPingable(InetAddress.getByName(deviceName))) {
                throw BaseStatusCode.getBaseStatusCode(7945);
            }
        }
        catch (UnknownHostException e) {
            throw BaseStatusCode.getBaseStatusCode(7945);
        }
        location = this.normalizeFilePath(location);
        ArrayList<ImportFileNameBean> importFiles = new ArrayList<ImportFileNameBean>();
        if (!Strings.isNullOrEmpty((String)this.importProtocolBean.getUsername())) {
            String username = this.importProtocolBean.getUsername();
            String domain = "";
            if (!Strings.isNullOrEmpty((String)username) && username.contains("\\") && !username.endsWith("\\")) {
                domain = username.substring(0, username.lastIndexOf("\\"));
                username = username.substring(username.lastIndexOf("\\") + 1);
            }
            NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(domain, username, this.importProtocolBean.getPassword());
            String url = this.importProtocolBean.getDeviceName() + "/" + location.replace(":", "$");
            SmbFile folder = new SmbFile("smb://" + url, auth);
            try {
                if (!folder.exists()) {
                    throw BaseStatusCode.getBaseStatusCode(12161L);
                }
            }
            catch (Exception e) {
                throw BaseStatusCode.getBaseStatusCode(12161L);
            }
            if (folder.listFiles() == null) {
                return importFiles;
            }
            for (SmbFile fileEntry : folder.listFiles()) {
                String fileName = fileEntry.getName();
                if (dynamicFileNameFilter != null && !dynamicFileNameFilter.accept(fileName)) continue;
                ImportFileNameBean importFileNameBean = new ImportFileNameBean(fileName, location, fileEntry.isDirectory());
                importFiles.add(importFileNameBean);
            }
        } else {
            File folder;
            if (ServerDetailsBean.getInstance().isWindows() && Strings.isNullOrEmpty((String)location)) {
                ArrayList paths = ELANativeHandler.listDeviceShares(deviceName);
                for (String path : paths) {
                    File file = new File("\\\\" + deviceName + "\\" + path);
                    boolean isDirectory = file.isDirectory();
                    boolean canRead = file.canRead();
                    path = path + "/";
                    if (!canRead) continue;
                    ImportFileNameBean importFileNameBean = new ImportFileNameBean(path, location, isDirectory);
                    importFiles.add(importFileNameBean);
                }
                if (importFiles.size() == 0) {
                    throw BaseStatusCode.getBaseStatusCode(7426);
                }
                return importFiles;
            }
            String tempLoc = location;
            if (ServerDetailsBean.getInstance().isWindows()) {
                tempLoc = "\\\\" + deviceName + "\\" + location.replaceAll("/", "\\\\").replace(':', '$');
            }
            if (!(folder = new File(tempLoc)).exists()) {
                throw BaseStatusCode.getBaseStatusCode(12161L);
            }
            File[] files = folder.listFiles();
            if (files == null) {
                return importFiles;
            }
            for (File fileEntry : files) {
                String fileName = fileEntry.getName();
                if (dynamicFileNameFilter != null && !dynamicFileNameFilter.accept(fileName)) continue;
                ImportFileNameBean importFileNameBean = new ImportFileNameBean(fileName, location, fileEntry.isDirectory());
                importFiles.add(importFileNameBean);
            }
        }
        returnObject.put("URL", (Object)location);
        Collections.sort(importFiles);
        return importFiles;
    }

    @Override
    public void close() throws BaseStatusCode {
        if (this.fileSource != null) {
            this.fileSource.close();
        }
    }
}

