/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols.list;

import com.google.common.base.Strings;
import com.manageengine.ela.server.common.io.file.FileUtils;
import com.manageengine.ela.server.common.io.file.pattern.filter.DynamicFileNameFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFileProperties;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportFileNameBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.json.JSONObject;

public class FTPImportProtocol
extends BaseProtocolHandler {
    private final FTPClient ftpClient = new FTPClient();
    private InputStream inputStream = null;

    public FTPImportProtocol(String filePath, ImportProtocolBean importProtocolBean, LogProperties logProperties) {
        super(filePath, importProtocolBean, logProperties);
    }

    private void ftpLogin() throws BaseStatusCode {
        try {
            this.ftpClient.setConnectTimeout(10000);
            this.ftpClient.connect(this.importProtocolBean.getDeviceName(), Math.toIntExact(this.importProtocolBean.getPort().intValue()));
            this.ftpClient.enterLocalPassiveMode();
            boolean validCredential = this.importProtocolBean.getUsername() != null ? this.ftpClient.login(this.importProtocolBean.getUsername(), this.importProtocolBean.getPassword()) : this.ftpClient.login("anonymous", null);
            if (!validCredential) {
                throw BaseStatusCode.getBaseStatusCode(7426);
            }
        }
        catch (UnknownHostException e) {
            throw BaseStatusCode.getBaseStatusCode(7945);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
    }

    @Override
    public boolean checkFileExistence() throws BaseStatusCode {
        this.filePath = this.filePath.replaceAll("\\\\", "/");
        if (!this.filePath.startsWith("/")) {
            this.filePath = "/" + this.filePath;
        }
        try {
            this.ftpLogin();
            this.inputStream = this.ftpClient.retrieveFileStream(this.filePath);
            this.isFileExists = this.inputStream != null && this.ftpClient.getReplyCode() != 550;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        return this.isFileExists;
    }

    @Override
    public FileSource downloadFile(String location) throws IOException, BaseStatusCode {
        if (this.inputStream == null) {
            this.checkFileExistence();
        }
        if (this.inputStream != null && this.isFileExists) {
            String fileName = this.filePath.substring(this.filePath.lastIndexOf(47) + 1, this.filePath.length());
            ImportFileProperties fileProperties = new ImportFileProperties(false, location + File.separator + URLDecoder.decode(fileName, "UTF8"), this.logProperties);
            this.fileSource = FileUtils.getBufferReaderList(this.inputStream, fileProperties, this.logProperties);
            return this.fileSource;
        }
        return null;
    }

    @Override
    public long getFileSize() throws BaseStatusCode {
        try {
            if (this.fileSource.getFileSize() > 0L) {
                return this.fileSource.getFileSize();
            }
            this.ftpLogin();
            this.ftpClient.sendCommand("SIZE", this.filePath);
            String sizeAsString = this.ftpClient.getReplyString().split("\\s")[1].replaceAll("[\r\n\\s]", "");
            if (!Strings.isNullOrEmpty((String)sizeAsString) && NumberUtils.isNumber((String)sizeAsString)) {
                return NumberUtils.toLong((String)sizeAsString);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        return 0L;
    }

    @Override
    public ArrayList<ImportFileNameBean> listFiles(String deviceName, String location, JSONObject returnObject, DynamicFileNameFilter dynamicFileNameFilter) throws Exception {
        FTPFile[] ftpFiles;
        this.ftpLogin();
        if (Strings.isNullOrEmpty((String)location)) {
            location = this.ftpClient.printWorkingDirectory();
        }
        if (Strings.isNullOrEmpty((String)location)) {
            location = "/";
            ftpFiles = this.ftpClient.listFiles("/");
        } else {
            if (!(location = location.replaceAll("\\\\", "/")).startsWith("/")) {
                location = "/" + location;
            }
            ftpFiles = this.ftpClient.listFiles(location);
        }
        returnObject.put("URL", (Object)(location.endsWith("/") ? location : location + "/"));
        ArrayList<ImportFileNameBean> fileList = new ArrayList<ImportFileNameBean>();
        for (FTPFile ftpFile : ftpFiles) {
            String fileName = ftpFile.getName();
            if (ftpFile.isDirectory()) {
                fileName = fileName + "/";
            }
            if (dynamicFileNameFilter != null && !dynamicFileNameFilter.accept(fileName)) continue;
            fileList.add(new ImportFileNameBean(fileName, location, ftpFile.isDirectory()));
        }
        Collections.sort(fileList);
        return fileList;
    }

    @Override
    public void close() throws BaseStatusCode {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.fileSource != null) {
            this.fileSource.close();
        }
    }
}

