/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols.list;

import com.manageengine.ela.server.common.io.file.FileUtils;
import com.manageengine.ela.server.common.io.file.pattern.filter.DynamicFileNameFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFileProperties;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportFileNameBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class HTTPImportProtocol
extends BaseProtocolHandler {
    private long fileSize;

    public HTTPImportProtocol(String filePath, ImportProtocolBean importProtocolBean, LogProperties logProperties) {
        super(filePath.replaceAll("\\s", "%20"), importProtocolBean, logProperties);
    }

    @Override
    public boolean checkFileExistence() throws BaseStatusCode {
        try {
            if (this.filePath.startsWith("\\\\")) {
                this.filePath = "file:" + this.filePath;
            }
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(HTTPImportProtocol.this.importProtocolBean.getUsername(), HTTPImportProtocol.this.importProtocolBean.getPassword().toCharArray());
                }
            });
            HttpURLConnection.setFollowRedirects(false);
            URLConnection con = new URL(this.filePath).openConnection();
            this.isFileExists = con instanceof HttpURLConnection ? ((HttpURLConnection)con).getResponseCode() == 200 : con.getContentLengthLong() > 0L;
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(6657);
        }
        return this.isFileExists;
    }

    @Override
    public FileSource downloadFile(String location) throws IOException, BaseStatusCode {
        URL url = new URL(this.filePath);
        String urlPath = url.getPath();
        String fileName = urlPath.substring(urlPath.lastIndexOf(47) + 1, urlPath.length());
        String outputFileName = location + File.separator + URLDecoder.decode(fileName, "UTF8");
        Path targetPath = new File(outputFileName).toPath();
        if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
            Files.createDirectory(targetPath.getParent(), new FileAttribute[0]);
        }
        Files.copy(url.openStream(), targetPath, StandardCopyOption.REPLACE_EXISTING);
        File file = new File(outputFileName);
        this.fileSize = file.length();
        FileInputStream inputStream = new FileInputStream(file);
        ImportFileProperties fileProperties = new ImportFileProperties(true, outputFileName, this.logProperties);
        this.fileSource = FileUtils.getBufferReaderList(inputStream, fileProperties, this.logProperties);
        this.fileSource.addFutureTasks(new FutureTask<Object>(() -> {
            inputStream.close();
            return null;
        }));
        return this.fileSource;
    }

    @Override
    public long getFileSize() throws BaseStatusCode {
        if (this.fileSource.getFileSize() > 0L) {
            return this.fileSource.getFileSize();
        }
        return this.fileSize;
    }

    @Override
    public ArrayList<ImportFileNameBean> listFiles(String deviceName, String location, JSONObject returnObject, DynamicFileNameFilter dynamicFileNameFilter) throws Exception {
        ArrayList<ImportFileNameBean> fileNameList = new ArrayList<ImportFileNameBean>();
        if (dynamicFileNameFilter != null) {
            fileNameList.addAll(dynamicFileNameFilter.getProjectedFileNameList().stream().map(ImportFileNameBean::new).sorted().collect(Collectors.toList()));
        }
        return fileNameList;
    }

    @Override
    public void close() throws BaseStatusCode {
        if (this.fileSource != null) {
            this.fileSource.close();
        }
    }
}

