/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.protocols.list;

import com.adventnet.sa.server.imp.SFTPUtil;
import com.manageengine.ela.server.common.io.file.FileUtils;
import com.manageengine.ela.server.common.io.file.pattern.filter.DynamicFileNameFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFileProperties;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportFileNameBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.maverick.sftp.SftpFile;
import com.maverick.sftp.SftpFileAttributes;
import com.sshtools.sftp.SftpClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.FutureTask;
import org.elasticsearch.common.Strings;
import org.json.JSONObject;

public class SFTPImportProtocol
extends BaseProtocolHandler {
    private InputStream inputStream = null;
    private SftpClient sftpClient = null;
    private long fileSize = 0L;

    public SFTPImportProtocol(String filePath, ImportProtocolBean importProtocolBean, LogProperties logProperties) {
        super(filePath, importProtocolBean, logProperties);
        this.filePath = this.filePath.replaceAll("\\\\", "/");
        if (this.filePath.endsWith("/")) {
            this.filePath = this.filePath.substring(0, this.filePath.lastIndexOf("/"));
        }
    }

    private void sftpLogin() throws BaseStatusCode {
        this.sftpLogin(false);
    }

    private void sftpLogin(boolean isBinaryFile) throws BaseStatusCode {
        try {
            this.sftpClient = SFTPUtil.getSFTPClient(this.importProtocolBean.getDeviceName(), this.importProtocolBean.getUsername(), this.importProtocolBean.getPassword(), isBinaryFile, this.importProtocolBean.getPort());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
    }

    @Override
    public boolean checkFileExistence() throws BaseStatusCode {
        try {
            if (this.filePath.endsWith(".gz") || this.filePath.endsWith(".zip")) {
                this.sftpLogin(true);
            } else {
                this.sftpLogin(false);
            }
            this.inputStream = this.sftpClient.getInputStream(this.filePath);
            this.isFileExists = this.inputStream != null;
            SftpFile sftpFile = this.sftpClient.openFile(this.filePath);
            SftpFileAttributes attributes = sftpFile.getAttributes();
            this.fileSize = attributes.getSize().longValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        return this.isFileExists;
    }

    @Override
    public FileSource downloadFile(String location) throws IOException, BaseStatusCode {
        if (this.inputStream == null) {
            this.checkFileExistence();
        }
        if (this.inputStream != null && this.isFileExists) {
            String fileName = this.filePath.substring(this.filePath.lastIndexOf(47) + 1, this.filePath.length());
            ImportFileProperties importFileProperties = new ImportFileProperties(false, location + File.separator + URLDecoder.decode(fileName, "UTF8"), this.logProperties);
            this.fileSource = FileUtils.getBufferReaderList(this.inputStream, importFileProperties, this.logProperties);
            this.fileSource.addFutureTasks(new FutureTask<Object>(() -> {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                return null;
            }));
            return this.fileSource;
        }
        return null;
    }

    @Override
    public long getFileSize() throws BaseStatusCode {
        if (this.fileSource.getFileSize() > 0L) {
            return this.fileSource.getFileSize();
        }
        return this.fileSize;
    }

    @Override
    public ArrayList<ImportFileNameBean> listFiles(String deviceName, String location, JSONObject returnObject, DynamicFileNameFilter dynamicFileNameFilter) throws Exception {
        this.sftpLogin();
        location = location.replaceAll("\\\\", "/");
        if (Strings.isNullOrEmpty((String)location)) {
            location = null;
        }
        SftpFile[] sftpFileList = SFTPUtil.getList(location, this.sftpClient);
        returnObject.put("URL", (Object)(this.sftpClient.pwd().endsWith("/") ? this.sftpClient.pwd() : this.sftpClient.pwd() + "/"));
        ArrayList<ImportFileNameBean> fileList = new ArrayList<ImportFileNameBean>();
        if (sftpFileList != null) {
            for (SftpFile file : sftpFileList) {
                if (file.getFilename().equalsIgnoreCase(".") || file.getFilename().equalsIgnoreCase("..")) continue;
                SftpFileAttributes attrs = file.getAttributes();
                String fileName = attrs.isDirectory() ? file.getFilename() + "/" : file.getFilename();
                if (dynamicFileNameFilter != null && !dynamicFileNameFilter.accept(fileName)) continue;
                fileList.add(new ImportFileNameBean(fileName, location, attrs.isDirectory()));
            }
        }
        Collections.sort(fileList);
        return fileList;
    }

    @Override
    public void close() throws BaseStatusCode {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.fileSource != null) {
            this.fileSource.close();
        }
        if (this.sftpClient != null) {
            try {
                SFTPUtil.logOut(this.sftpClient);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

