/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.report;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.importlog.parser.ParserApplyWhenCondition;
import com.manageengine.ela.server.importlog.report.ReportApplyWhenCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.math.NumberUtils;

public class ReportUtil {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistence();

    public static ArrayList<ReportApplyWhenCondition> getApplyWhenConditions(Long formatId) throws DataAccessException {
        Criteria formatIdCriteria = new Criteria(Column.getColumn((String)"FormatToReportMapping", (String)"FORMATID"), (Object)formatId, 0);
        DataObject dataObject = PERSISTENCELITE.get(Arrays.asList("FormatToReportMapping", "ELAImportReport_ApplyWhen", "ReportToFieldMapping"), formatIdCriteria);
        ArrayList<ReportApplyWhenCondition> reportApplyWhenConditions = new ArrayList<ReportApplyWhenCondition>();
        if (!dataObject.isEmpty()) {
            Iterator reportApplyWhenIterator = dataObject.getRows("ELAImportReport_ApplyWhen");
            while (reportApplyWhenIterator.hasNext()) {
                Row applyWhenRow = (Row)reportApplyWhenIterator.next();
                if (applyWhenRow == null) continue;
                Long reportId = NumberUtils.toLong((String)String.valueOf(applyWhenRow.get("REPORTID")));
                String keyField = (String)applyWhenRow.get("FIELD");
                String conditionType = (String)applyWhenRow.get("CONDITION");
                String value = (String)applyWhenRow.get("VALUE");
                ReportApplyWhenCondition applyWhenCondition = new ReportApplyWhenCondition(reportId, keyField, ParserApplyWhenCondition.CONDITION.getConditionType(conditionType));
                applyWhenCondition.setValue(value);
                Criteria reportFieldCriteria = new Criteria(Column.getColumn((String)"ReportToFieldMapping", (String)"REPORTID"), (Object)reportId, 0);
                Iterator reportFieldsIterator = dataObject.getRows("ReportToFieldMapping", reportFieldCriteria);
                while (reportFieldsIterator.hasNext()) {
                    Row reportFieldRow = (Row)reportFieldsIterator.next();
                    Long fieldId = NumberUtils.toLong((String)String.valueOf(reportFieldRow.get("FIELDID")));
                    String fieldName = (String)reportFieldRow.get("FIELDNAME");
                    String fieldType = (String)reportFieldRow.get("TYPE");
                    applyWhenCondition.addField(fieldId, fieldName, fieldType);
                }
                Criteria formatToReportNameCriteria = new Criteria(Column.getColumn((String)"FormatToReportMapping", (String)"REPORTID"), (Object)reportId, 0);
                Iterator formatToReportIterator = dataObject.getRows("FormatToReportMapping", formatToReportNameCriteria);
                if (formatToReportIterator.hasNext()) {
                    Row formatToReportRow = (Row)formatToReportIterator.next();
                    String subReportName = (String)formatToReportRow.get("REPORTNAME");
                    applyWhenCondition.setReportName(subReportName);
                }
                reportApplyWhenConditions.add(applyWhenCondition);
            }
        }
        return reportApplyWhenConditions;
    }
}

