/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.report;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.database.DataBaseSpecificActions;
import com.manageengine.ela.server.common.database.DatabaseBulkUploadHandler;
import com.manageengine.ela.server.common.database.handlers.DataBaseHandlerFactory;
import com.manageengine.ela.server.common.discovery.DiscoveryFileProcessorCallBack;
import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.io.file.writer.DefaultFieldProcessor;
import com.manageengine.ela.server.common.io.file.writer.FileIOHandler;
import com.manageengine.ela.server.common.io.file.writer.QueueProcessorParams;
import com.manageengine.ela.server.common.io.file.writer.TempFileWriter;
import com.manageengine.ela.server.common.util.StringUtil;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.report.ReportFields;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedMap;
import org.apache.commons.lang3.math.NumberUtils;

public class SubReportCounter {
    private final long appId;
    protected static final String TEMPFILE_PATH = System.getProperty("server.dir") + File.separator + "server" + File.separator + "RuntimeTempFiles" + File.separator;
    private TempFileWriter writer = null;
    private long reportId;
    private HashMap<Integer, SubReportValues> reportFieldsHashMap = new HashMap();
    private HashMap<Long, SortedMap<Long, String>> reportFieldType = new HashMap();

    public void setReportId(long reportId) {
        this.reportId = reportId;
    }

    public SubReportCounter(long appId) {
        this.appId = appId;
    }

    public void add(Long reportId, int hourOfDay, String time, ReportFields reportFields, SortedMap<Long, String> fieldType) {
        Integer reportHashCode = reportFields.hashCode() ^ reportId.hashCode();
        if (this.reportFieldsHashMap.containsKey(reportHashCode)) {
            SubReportValues subReportValues = this.reportFieldsHashMap.get(reportHashCode);
            subReportValues.countIncrement();
        } else {
            SubReportValues subReportValues = new SubReportValues(reportId, hourOfDay, time, reportFields);
            this.reportFieldsHashMap.put(reportHashCode, subReportValues);
        }
        this.reportFieldType.put(reportId, fieldType);
    }

    public ArrayList<Row> getReportRows(Long importedTime, boolean isThrowAway) {
        ArrayList<Row> reportTrendRows = new ArrayList<Row>();
        ArrayList<String> columnOrder = new ArrayList<String>();
        columnOrder.add("APPID");
        columnOrder.add("REPORTID");
        columnOrder.add("HOUROFDAY");
        columnOrder.add("HOUR");
        columnOrder.add("FIELD0");
        columnOrder.add("FIELD1");
        columnOrder.add("FIELD2");
        columnOrder.add("FIELD3");
        columnOrder.add("FIELD4");
        columnOrder.add("FIELD5");
        columnOrder.add("EVTCOUNT");
        columnOrder.add("IMPORTED_TIME");
        columnOrder.add("IS_THROWAWAY");
        try {
            String reportTableName = FormatIdentifier.getReportTableName(this.reportId);
            if (reportTableName == null) {
                reportTableName = "ela_import_app_reports_hr_trend_sa";
                FormatIdentifier.updateReportTableName(this.reportId, reportTableName);
            }
            if (MetaDataUtil.getTableDefinitionByName((String)reportTableName) == null) {
                String tempFile = SubReportCounter.createTempFile(reportTableName);
                DataBaseSpecificActions defaultValue = DataBaseHandlerFactory.getInstance().getDataBaseHandler();
                this.writer = this.createQueuedWriter(tempFile, 1, defaultValue, reportTableName, StringUtil.listToString(columnOrder));
                for (Integer key : this.reportFieldsHashMap.keySet()) {
                    ArrayList<String> resultFields = new ArrayList<String>();
                    SubReportValues subReportValues = this.reportFieldsHashMap.get(key);
                    resultFields.add(Long.toString(this.appId));
                    resultFields.add(Long.toString(subReportValues.getReportId()));
                    resultFields.add(Integer.toString(subReportValues.getHourOfDay()));
                    resultFields.add(subReportValues.getTime());
                    ArrayList<String> fieldValues = subReportValues.getReportFields().getFields();
                    ArrayList<String> fieldTypeList = new ArrayList<String>(this.reportFieldType.get(subReportValues.getReportId()).values());
                    for (int index = 0; index < 6; ++index) {
                        if (index < fieldValues.size()) {
                            String fieldType = fieldTypeList.get(index);
                            String value = fieldValues.get(index);
                            if (value != null && (fieldType.equals("AGGREGATE") || fieldType.equals("PERCENT"))) {
                                value = String.valueOf(NumberUtils.toLong((String)value.toString(), (long)0L) * subReportValues.getCount());
                            }
                            if (value != null) {
                                resultFields.add(value.toString());
                                continue;
                            }
                            resultFields.add(null);
                            continue;
                        }
                        resultFields.add(null);
                    }
                    resultFields.add(Long.toString(subReportValues.getCount()));
                    resultFields.add(Long.toString(importedTime));
                    resultFields.add(isThrowAway ? "true" : "false");
                    DefaultFieldProcessor processor = new DefaultFieldProcessor(resultFields, defaultValue);
                    this.writer.put(processor);
                }
                this.writer.finalizeWriter();
            } else {
                for (Integer key : this.reportFieldsHashMap.keySet()) {
                    SubReportValues subReportValues = this.reportFieldsHashMap.get(key);
                    Row reportTrendRow = new Row(reportTableName);
                    reportTrendRow.set("APPID", (Object)this.appId);
                    reportTrendRow.set("REPORTID", (Object)subReportValues.getReportId());
                    reportTrendRow.set("HOUROFDAY", (Object)subReportValues.getHourOfDay());
                    reportTrendRow.set("HOUR", (Object)subReportValues.getTime());
                    reportTrendRow.set("IMPORTED_TIME", (Object)importedTime);
                    reportTrendRow.set("IS_THROWAWAY", (Object)(isThrowAway ? "true" : "false"));
                    ArrayList<String> fieldValues = subReportValues.getReportFields().getFields();
                    ArrayList<String> fieldTypeList = new ArrayList<String>(this.reportFieldType.get(subReportValues.getReportId()).values());
                    for (int index = 0; index < fieldValues.size() && index < 6; ++index) {
                        String fieldType = fieldTypeList.get(index);
                        String value = fieldValues.get(index);
                        if (value != null && (fieldType.equals("AGGREGATE") || fieldType.equals("PERCENT"))) {
                            value = String.valueOf(NumberUtils.toLong((String)value.toString(), (long)0L) * subReportValues.getCount());
                        }
                        reportTrendRow.set("FIELD" + index, (Object)value);
                    }
                    reportTrendRow.set("EVTCOUNT", (Object)subReportValues.getCount());
                    reportTrendRows.add(reportTrendRow);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.clear();
        return reportTrendRows;
    }

    public TempFileWriter createQueuedWriter(String fileName, int maxProcessor, DataBaseSpecificActions defaulltValue, String tableName, String columnOrder) throws IllegalArgumentException, IllegalAccessException, IOException, InterruptedException {
        QueueProcessorParams params = new QueueProcessorParams();
        params.setFileEncoding(defaulltValue.getFileEncoding());
        params.setMaxProcessor(maxProcessor);
        CommonQueueImpl<String> queue = new CommonQueueImpl<String>();
        CommonQueueProcessor<String> uploader = DatabaseBulkUploadHandler.createNewBulkUploader(queue, tableName, columnOrder);
        params.setFileProcessorCallBack(new DiscoveryFileProcessorCallBack(queue));
        params.setFilerotationNeeded(true);
        return FileIOHandler.createFileWriter(fileName, params);
    }

    private static String createTempFile(String reportTableName) throws IOException {
        File dir = new File(TEMPFILE_PATH);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = new StringBuffer(TEMPFILE_PATH).append(reportTableName).append(".txt").toString();
        return fileName;
    }

    public void clear() {
        this.reportFieldsHashMap.clear();
    }

    class SubReportValues {
        long reportId;
        int hourOfDay;
        String time;
        ReportFields reportFields;
        long count = 0L;

        public SubReportValues(long reportId, int hourOfDay, String time, ReportFields reportFields) {
            this.reportId = reportId;
            this.hourOfDay = hourOfDay;
            this.time = time;
            this.reportFields = reportFields;
            this.countIncrement();
        }

        public void countIncrement() {
            ++this.count;
        }

        public long getReportId() {
            return this.reportId;
        }

        public void setReportId(long reportId) {
            this.reportId = reportId;
        }

        public int getHourOfDay() {
            return this.hourOfDay;
        }

        public void setHourOfDay(int hourOfDay) {
            this.hourOfDay = hourOfDay;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public ReportFields getReportFields() {
            return this.reportFields;
        }

        public void setReportFields(ReportFields reportFields) {
            this.reportFields = reportFields;
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }
    }
}

