/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.schedules;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.zoho.za.dae.deletion.DeleteFromES;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;

public class DeleteAfterRetention
implements Task {
    private static final Logger LOGGER = Logger.getLogger(DeleteAfterRetention.class.getName());
    private static final Persistence PERSISTENCE = PersistenceDBUtil.getPersistence();
    private static final String SHORT_TERM_IMPORT_PERIOD = "ShortTermImportPeriod";
    private static final long DEFAULT_SHORT_TERM_IMPORT_PERIOD = 2L;
    private static final long SCROLL_TIME_VALUE = 60000L;
    private static final int MAX_SEARCH_HITS = 10000;
    private static ArrayList<String> importTablesToBeDeleted = new ArrayList();

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        LOGGER.info("IMPLOG : Daily Import log db delete called at " + System.currentTimeMillis());
        try {
            this.deleteLogsFromDb(this.getDbRetentionPeriod(), "HOUR", false);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        LOGGER.info("IMPLOG : Daily Import log db delete completed at " + System.currentTimeMillis());
        LOGGER.info("IMPLOG : Daily Import log short term import delete called at " + System.currentTimeMillis());
        this.deleteShortTermImports();
        LOGGER.info("IMPLOG : Daily Import log short term import delete completed at " + System.currentTimeMillis());
    }

    private void deleteLogsFromDb(Integer dbRetentionPeriod, String columnKey, boolean isShortTerm) throws DataAccessException {
        Calendar calendar = this.getCalendarDay(dbRetentionPeriod);
        for (String tableName : importTablesToBeDeleted) {
            Criteria deleteCriteria;
            DeleteQueryImpl deleteQuery = new DeleteQueryImpl(tableName);
            if (isShortTerm) {
                deleteCriteria = new Criteria(Column.getColumn((String)tableName, (String)columnKey), (Object)calendar.getTimeInMillis(), 6);
                deleteCriteria.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_THROWAWAY"), (Object)"true", 0));
            } else {
                deleteCriteria = new Criteria(Column.getColumn((String)tableName, (String)columnKey), (Object)calendar.getTime(), 6);
            }
            deleteQuery.setCriteria(deleteCriteria);
            PERSISTENCE.delete((DeleteQuery)deleteQuery);
        }
    }

    private Integer getDbRetentionPeriod() throws DataAccessException {
        Iterator dataManagementTimingIterator;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"DataManagementTiming"));
        selectQuery.addSelectColumn(Column.getColumn((String)"DataManagementTiming", (String)"*"));
        Column col = new Column("DataManagementTiming", "TIMER_NAME");
        Criteria criteria = new Criteria(col, (Object)"SYS_DATA_WINDOW", 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty() && (dataManagementTimingIterator = dataObject.getRows("DataManagementTiming")).hasNext()) {
            Row dataManagementTimingRow = (Row)dataManagementTimingIterator.next();
            return NumberUtils.toInt((String)String.valueOf(dataManagementTimingRow.get("TIMESTAMP")));
        }
        return 32;
    }

    private void deleteShortTermImports() {
        try {
            Long shortTermImportPeriod = this.getShortTermImportPeriod();
            Long shortTermImportPeriodInMillis = this.getCalendarDay(shortTermImportPeriod.intValue()).getTimeInMillis();
            RangeQueryBuilder timeRangeQueryBuilder = QueryBuilders.rangeQuery((String)"IMPORTED_TIME").lte((Object)shortTermImportPeriodInMillis);
            TermQueryBuilder throwAwayQuery = QueryBuilders.termQuery((String)"IS_THROWAWAY", (boolean)true);
            BoolQueryBuilder resultQuery = QueryBuilders.boolQuery().must((QueryBuilder)throwAwayQuery).must((QueryBuilder)timeRangeQueryBuilder);
            if (!new DeleteFromES().deleteByQuery((QueryBuilder)resultQuery)) {
                LOGGER.info("IMPLOG : Daily short term import ES delete failed - ");
            } else {
                this.deleteLogsFromDb(shortTermImportPeriod.intValue(), "IMPORTED_TIME", true);
            }
        }
        catch (Exception e) {
            LOGGER.info("IMPLOG : Daily short term import  delete failed - " + e.getMessage());
        }
    }

    private long getShortTermImportPeriod() {
        Object obj = CommonUtil.getSysConfiguration(SHORT_TERM_IMPORT_PERIOD);
        if (obj == null) {
            return 2L;
        }
        return Long.parseLong((String)obj);
    }

    private Calendar getCalendarDay(int daysToBeSubtracted) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, daysToBeSubtracted * -1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public void stopTask() throws TaskExecutionException {
    }

    static {
        importTablesToBeDeleted.add("dhcp_windows_reports_hr_trend_sa");
        importTablesToBeDeleted.add("mssql_reports_hr_trend_sa");
        importTablesToBeDeleted.add("syslog_reports_hr_trend_sa");
        importTablesToBeDeleted.add("ibm_maximo_reports_hr_trend_sa");
        importTablesToBeDeleted.add("iis_w3cweb_reports_hr_trend_sa");
        importTablesToBeDeleted.add("iis_w3cftp_reports_hr_trend_sa");
        importTablesToBeDeleted.add("sys_archive_reports_hr_trend_sa");
        importTablesToBeDeleted.add("ibm_as400_reports_hr_trend_sa");
        importTablesToBeDeleted.add("cisco_archive_reports_hr_trend_sa");
        importTablesToBeDeleted.add("csv_reports_hr_trend_sa");
        importTablesToBeDeleted.add("win_archive_reports_hr_trend_sa");
        importTablesToBeDeleted.add("dhcp_linux_reports_hr_trend_sa");
        importTablesToBeDeleted.add("apache_logs_reports_hr_trend_sa");
        importTablesToBeDeleted.add("ela_import_app_hr_trend_sa");
        importTablesToBeDeleted.add("ela_import_app_reports_hr_trend_sa");
    }
}

