/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.logflowrate;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.logflowrate.LogFlowRateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.DateUtils;

public class LogCountHolder {
    private final AtomicLong logcount = new AtomicLong(0L);
    private long starttime;
    private final int identity;
    private static final int COUNT_FLUSH_TIMEDELAY = 5;
    private static final int DO_FLUSH_TIMEDELAY = 10;
    private static final long TIME_DIFF = 3600000L;
    private static final long CACHE_LIMIT = 86400000L;
    private static final ScheduledExecutorService FLUSHSCHEDULER;
    private static final DataObject DATACONTAINER;
    private static final Lock DO_SYNC;
    private static final Lock REQUEST_SYNC;
    private final Lock data_sync = new ReentrantLock();
    private static final boolean IS_INITIALIZED;
    private static final AtomicBoolean UPDATE_REQUEST;
    private static final Logger LOGGER;
    private static final Map<Integer, LogCountHolder> CACHE;

    private static void flush() {
        DO_SYNC.lock();
        try {
            if (UPDATE_REQUEST.get()) {
                PersistenceDBUtil.getPersistence().update(DATACONTAINER);
                UPDATE_REQUEST.set(false);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Problem in data flusher");
        }
        finally {
            LogFlowRateUtil.deleteOldData(DATACONTAINER, 86400000L);
            DO_SYNC.unlock();
        }
    }

    public static LogCountHolder getJvmHolder() {
        return LogCountHolder.getFromCache(1);
    }

    public static LogCountHolder getAgentHolder() {
        return LogCountHolder.getFromCache(2);
    }

    private static LogCountHolder getFromCache(Integer identity) {
        REQUEST_SYNC.lock();
        try {
            LogCountHolder counter = CACHE.get(identity);
            if (counter == null) {
                counter = new LogCountHolder(identity);
                CACHE.put(identity, counter);
            }
            LogCountHolder logCountHolder = counter;
            return logCountHolder;
        }
        finally {
            REQUEST_SYNC.unlock();
        }
    }

    private LogCountHolder(int identity) {
        this.setStarttime();
        this.identity = identity;
        this.logcount.set(LogFlowRateUtil.getPreviousState(DATACONTAINER, identity));
        FLUSHSCHEDULER.scheduleWithFixedDelay(() -> this.commit(), 5L, 5L, TimeUnit.MINUTES);
    }

    public long increment() {
        return this.increment(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long increment(long count) {
        if (IS_INITIALIZED) {
            this.data_sync.lock();
            try {
                long time = System.currentTimeMillis();
                if ((time - this.starttime) / 3600000L > 0L) {
                    this.commit();
                    this.reset();
                }
                long l = this.logcount.addAndGet(count);
                return l;
            }
            finally {
                this.data_sync.unlock();
            }
        }
        return 0L;
    }

    private void setStarttime() {
        long time = System.currentTimeMillis();
        this.starttime = DateUtils.truncate((Date)new Date(time), (int)10).getTime();
    }

    private void commit() {
        DO_SYNC.lock();
        try {
            LogFlowRateUtil.updateOrCreateRow(DATACONTAINER, this.starttime, this.starttime + 3600000L, this.identity, this.logcount.get());
            UPDATE_REQUEST.set(true);
        }
        finally {
            DO_SYNC.unlock();
        }
    }

    private long reset() {
        this.setStarttime();
        return this.logcount.getAndSet(0L);
    }

    public static void updateNativeLogCount(Long start_time, Long log_count) {
        if (LogCountHolder.checkIsRowAlreadyExist(start_time = Long.valueOf(DateUtils.truncate((Date)new Date(start_time), (int)10).getTime()))) {
            log_count = log_count + LogFlowRateUtil.getPreviousState(DATACONTAINER, 3);
        }
        LogFlowRateUtil.updateOrCreateRow(DATACONTAINER, start_time, start_time + 3600000L, 3, log_count);
    }

    private static boolean checkIsRowAlreadyExist(long time) {
        return DBUtil.getCountInt("ELALogFlowRateDetails", new Criteria(Column.getColumn((String)"ELALogFlowRateDetails", (String)"START_TIME"), (Object)time, 0)) != 0;
    }

    static {
        DO_SYNC = new ReentrantLock();
        REQUEST_SYNC = new ReentrantLock();
        UPDATE_REQUEST = new AtomicBoolean(true);
        LOGGER = Logger.getLogger(LogCountHolder.class.getName());
        DATACONTAINER = LogFlowRateUtil.getPreviousStateDO();
        IS_INITIALIZED = DATACONTAINER != null;
        FLUSHSCHEDULER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("logflow[calculator]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.log(Level.INFO, "Shutdown hook recived from JVM");
                LogCountHolder.flush();
            }
        });
        CACHE = new HashMap<Integer, LogCountHolder>();
        FLUSHSCHEDULER.scheduleWithFixedDelay(() -> LogCountHolder.flush(), 10L, 10L, TimeUnit.MINUTES);
    }
}

