/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.logflowrate;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.time.DateUtils;

public class LogFlowRateUtil {
    static final int JVM_IDENTITY = 1;
    static final int AGENT_IDENTITY = 2;
    static final int NATIVE_IDENTITY = 3;
    private static final Logger LOGGER = Logger.getLogger(LogFlowRateUtil.class.getName());

    public static DataObject getPreviousStateDO() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ELALogFlowRateDetails"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ELALogFlowRateDetails", (String)"UNIQUE_ID"), false));
            query.setRange(new Range(0, 1));
            return PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        }
        catch (Exception exp) {
            try {
                return PersistenceDBUtil.getPersistence().constructDataObject();
            }
            catch (DataAccessException e) {
                return null;
            }
        }
    }

    public static long getPreviousHourLogCount() throws DataAccessException {
        long time = System.currentTimeMillis();
        time = DateUtils.truncate((Date)new Date(time), (int)10).getTime();
        DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("ELALogFlowRateDetails", new Criteria(Column.getColumn((String)"ELALogFlowRateDetails", (String)"START_TIME"), (Object)(time -= 3600000L), 0));
        return dobj.isEmpty() ? 0L : (Long)dobj.getFirstValue("ELALogFlowRateDetails", "JVM_LOG_COUNT");
    }

    static void updateOrCreateRow(DataObject dobj, long starttime, long endTime, int identity, long count) {
        try {
            Row row = dobj.getRow("ELALogFlowRateDetails", new Criteria(Column.getColumn((String)"ELALogFlowRateDetails", (String)"START_TIME"), (Object)starttime, 0));
            if (row == null) {
                row = new Row("ELALogFlowRateDetails");
                row.set("START_TIME", (Object)starttime);
                row.set("END_TIME", (Object)endTime);
                dobj.addRow(row);
            }
            switch (identity) {
                case 1: {
                    row.set("JVM_LOG_COUNT", (Object)count);
                    break;
                }
                case 2: {
                    row.set("AGENT_LOG_COUNT", (Object)count);
                    break;
                }
                default: {
                    row.set("SYSEVT_LOG_COUNT", (Object)count);
                }
            }
            dobj.updateRow(row);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to update dataObject");
        }
    }

    static void deleteOldData(DataObject dobj, long cacheLimit) {
        try {
            long time = System.currentTimeMillis();
            Criteria criteria = new Criteria(Column.getColumn((String)"ELALogFlowRateDetails", (String)"START_TIME"), (Object)(time - cacheLimit), 6);
            dobj.deleteRows("ELALogFlowRateDetails", criteria);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to delete olddata");
        }
    }

    static long getPreviousState(DataObject dobj, int identity) {
        if (dobj == null) {
            return 0L;
        }
        Row row = null;
        try {
            Iterator itr = dobj.getRows("ELALogFlowRateDetails");
            while (itr.hasNext()) {
                row = (Row)itr.next();
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to find previous state count");
        }
        if (row == null) {
            return 0L;
        }
        switch (identity) {
            case 1: {
                return (Long)row.get("JVM_LOG_COUNT");
            }
            case 2: {
                return (Long)row.get("AGENT_LOG_COUNT");
            }
        }
        return (Long)row.get("SYSEVT_LOG_COUNT");
    }
}

