/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.reports.converter;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.logsearch.index.util.LuceneConstants;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.cache.Cache;
import java.util.LinkedHashMap;
import java.util.List;
import org.json.JSONException;

public class ReportConverter {
    private static final Cache<Long, String> CACHE_DISPLAYNAME = new Cache();

    public static String getDisplayName(long hostid) throws DataAccessException, JSONException {
        String dname = CACHE_DISPLAYNAME.get(hostid);
        if (dname == null) {
            DataObject dobj = PersistenceDBUtil.getPersistenceLite().get("Hosts", new Criteria(Column.getColumn((String)"Hosts", (String)"HOST_ID"), (Object)hostid, 0));
            dname = !dobj.isEmpty() ? (String)dobj.getFirstValue("Hosts", "DISPLAY_NAME") : "-";
            CACHE_DISPLAYNAME.put(hostid, dname);
        }
        return dname;
    }

    public static void removeDisplayNameCache(Long hostid) {
        CACHE_DISPLAYNAME.remove(hostid);
    }

    public static List convertSearchResult(List searchResultList, LuceneConstants.ResultFormat searchResultFormat, List viewFields) {
        block9: {
            block8: {
                if (searchResultFormat != LuceneConstants.ResultFormat.LIST_OF_LIST) break block8;
                int indexOfID = viewFields.indexOf("HOSTID");
                if (indexOfID == -1) break block9;
                for (int i = 0; i < searchResultList.size(); ++i) {
                    List result = (List)searchResultList.get(i);
                    try {
                        result.set(indexOfID, ReportConverter.getDisplayName(Long.parseLong((String)result.get(indexOfID))));
                    }
                    catch (DataAccessException | NumberFormatException | JSONException e) {
                        e.printStackTrace();
                    }
                    searchResultList.set(i, result);
                }
                break block9;
            }
            if (searchResultFormat == LuceneConstants.ResultFormat.LIST_OF_MAP) {
                for (int i = 0; i < searchResultList.size(); ++i) {
                    List listOfList = (List)searchResultList.get(i);
                    LinkedHashMap mapData = (LinkedHashMap)listOfList.get(0);
                    String hostID = (String)mapData.get("HOSTID");
                    if (hostID != null) {
                        hostID = hostID.replace("<em class='searchNewHighLight'>", "").replace("</em>", "");
                        try {
                            mapData.put("HOSTID", ReportConverter.getDisplayName(Long.parseLong(hostID)));
                        }
                        catch (DataAccessException | NumberFormatException | JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    listOfList.set(0, mapData);
                    searchResultList.set(i, listOfList);
                }
            }
        }
        return searchResultList;
    }
}

