/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.settings;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.me.tools.zcutil.METrack;
import com.zoho.za.ela.utils.Utils;
import org.json.JSONObject;

public class PrivacySettingsManager {
    public static void getPrivacySettings(long userId, ResponseBuilder responseBuilder) throws Exception {
        JSONObject resultJson = new JSONObject();
        String value = System.getProperty("GDPRCompliant", "false");
        JSONObject obj = new JSONObject();
        obj.put("IS_GDPR_COMPLIANT", (Object)Boolean.valueOf(value));
        DataObject exportPasswordDO = Utils.getExportPasswordDO((Long)userId);
        if (exportPasswordDO != null && exportPasswordDO.containsTable("EventlogUsersPersonal")) {
            String exportPasssword = (String)exportPasswordDO.getFirstValue("EventlogUsersPersonal", "EXPORT_PASSWORD");
            if (exportPasssword != null && !"".equals(exportPasssword.trim()) && !"null".equalsIgnoreCase(exportPasssword)) {
                obj.put("ENABLE_PASSWORD_PROTECT", true);
            } else {
                obj.put("ENABLE_PASSWORD_PROTECT", false);
            }
        } else {
            obj.put("ENABLE_PASSWORD_PROTECT", false);
        }
        String isMeTrackEnabled = (String)CommonUtil.getSysConfiguration("isMETrackerEnabled");
        if ("true".equalsIgnoreCase(isMeTrackEnabled)) {
            obj.put("IS_METRACK_ENABLED", true);
        } else {
            obj.put("IS_METRACK_ENABLED", false);
        }
        resultJson.put("PRIVACY_SETTINGS", (Object)obj);
        responseBuilder.setResponse(resultJson);
    }

    public static void savePrivacySettings(JSONObject requestObj, long userId, ResponseBuilder responseBuilder) {
        String status = "success";
        try {
            if (!requestObj.isNull("IS_GDPR_COMPLIANT")) {
                SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"SystemConfigurations"));
                sql.addSelectColumn(Column.getColumn((String)"SystemConfigurations", (String)"*"));
                sql.setCriteria(new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"GDPRCompliant", 0));
                DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
                if (doo != null && doo.containsTable("SystemConfigurations")) {
                    Row systemConfigRow = doo.getFirstRow("SystemConfigurations");
                    systemConfigRow.set("CONF_VALUE", requestObj.get("IS_GDPR_COMPLIANT"));
                    doo.updateRow(systemConfigRow);
                    PersistenceDBUtil.getPersistence().update(doo);
                } else if (doo != null) {
                    Row systemConfigRow = new Row("SystemConfigurations");
                    systemConfigRow.set("CONF_NAME", (Object)"GDPRCompliant");
                    systemConfigRow.set("CONF_VALUE", requestObj.get("IS_GDPR_COMPLIANT"));
                    doo.addRow(systemConfigRow);
                    PersistenceDBUtil.getPersistence().add(doo);
                }
                System.setProperty("GDPRCompliant", String.valueOf(requestObj.get("IS_GDPR_COMPLIANT")));
            }
            if (!requestObj.isNull("IS_METRACK_ENABLED")) {
                String isMetrackEnabled = String.valueOf(requestObj.get("IS_METRACK_ENABLED"));
                if ("true".equalsIgnoreCase(isMetrackEnabled)) {
                    METrack.enable();
                } else {
                    METrack.disable();
                }
                CommonUtil.updateSysConfiguration("isMETrackerEnabled", isMetrackEnabled, true);
            }
            if (!requestObj.isNull("ENABLE_PASSWORD_PROTECT")) {
                String passwordProtect = requestObj.getString("ENABLE_PASSWORD_PROTECT");
                if ("true".equalsIgnoreCase(passwordProtect)) {
                    if (!requestObj.isNull("EXPORT_PASSWORD")) {
                        PrivacySettingsManager.setExportPassword(userId, (String)requestObj.get("EXPORT_PASSWORD"));
                    }
                } else {
                    PrivacySettingsManager.setExportPassword(userId, null);
                }
            }
        }
        catch (Exception e) {
            status = "failure";
            e.printStackTrace();
        }
        try {
            if ("success".equals(status)) {
                responseBuilder.setResponse(new JSONObject().put("status", true));
            } else {
                responseBuilder.setResponse(new JSONObject().put("status", false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setExportPassword(Long userId, String password) throws Exception {
        DataObject exportPasswordDO = Utils.getExportPasswordDO((Long)userId);
        if (exportPasswordDO != null && exportPasswordDO.containsTable("EventlogUsersPersonal")) {
            Row exportPasswordRow = exportPasswordDO.getFirstRow("EventlogUsersPersonal");
            exportPasswordRow.set("EXPORT_PASSWORD", (Object)password);
            exportPasswordDO.updateRow(exportPasswordRow);
            PersistenceDBUtil.getPersistence().update(exportPasswordDO);
        } else {
            DataObject loginTableDO;
            Long loginId;
            if (exportPasswordDO == null) {
                exportPasswordDO = PersistenceDBUtil.getPersistence().constructDataObject();
            }
            if ((loginId = (Long)(loginTableDO = PersistenceDBUtil.getPersistence().get("AaaLogin", new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)userId, 0))).getFirstValue("AaaLogin", "LOGIN_ID")) != null) {
                Row exportPasswordRow = new Row("EventlogUsersPersonal");
                exportPasswordRow.set("LOGIN_ID", (Object)loginId);
                exportPasswordRow.set("EXPORT_PASSWORD", (Object)password);
                exportPasswordDO.addRow(exportPasswordRow);
                PersistenceDBUtil.getPersistence().add(exportPasswordDO);
            }
        }
    }
}

