/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.settings.notification.mail;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotifierSettings;
import com.manageengine.ads.fw.mail.MailHandler;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.settings.notification.util.NotificationSettingsUtil;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.json.JSONObject;

public class MailSettingsManager {
    public static void fetchMailServerSettings(ResponseBuilder responseBuilder) throws Exception {
        JSONObject resultJson = new JSONObject();
        DataObject doo = NotificationSettingsUtil.getMailServerSettingsDO();
        Row mailRow = doo.getRow("ADSMailSettings");
        if (mailRow != null) {
            JSONObject obj = new JSONObject();
            String mail = (String)mailRow.get("FROM_MAIL_ID");
            if (mail == null) {
                obj.put("isMail", false);
                resultJson.put("mail", (Object)obj);
            } else {
                obj.put("isMail", true);
                obj.put("serverName", (Object)((String)mailRow.get("SERVER_NAME")));
                obj.put("port", (Object)((String)mailRow.get("PORT")));
                obj.put("frommail", (Object)mail);
                String userName = (String)mailRow.get("USER_NAME");
                String password = (String)mailRow.get("PASSWORD");
                if (userName != null && password != null && !userName.isEmpty() && !password.isEmpty()) {
                    obj.put("auth", true);
                    obj.put("username", (Object)userName);
                } else {
                    obj.put("auth", false);
                }
                Long connectionID = (Long)mailRow.get("CONNECTION_SECURITY_ID");
                Row r = doo.getRow("ADSConnectionSecurity", new Criteria(Column.getColumn((String)"ADSConnectionSecurity", (String)"CONNECTION_SECURITY_ID"), (Object)connectionID, 0));
                String connection = (String)r.get("NAME");
                if ("TLS".equals(connection)) {
                    obj.put("tls", true);
                } else {
                    obj.put("tls", false);
                }
                resultJson.put("mail", (Object)obj);
            }
        }
        responseBuilder.setResponse(resultJson);
    }

    public static void sendTestMail(JSONObject reqJsonObject, ResponseBuilder responseBuilder) {
        try {
            JSONObject obj = reqJsonObject.getJSONObject("MAILSETTINGS");
            String serverName = obj.getString("serverName");
            String port = obj.getString("port");
            String fromAddress = obj.getString("fromAddress");
            String toAddress = obj.getString("toAddress");
            String userName = obj.getString("userName");
            String password = obj.getString("password");
            String tls = obj.getString("tls");
            ResourceBundle rb = ProductBundle.getInstance().getBundle((Locale)reqJsonObject.get("locale"));
            File file = new File(System.getProperty("server.home") + File.separator + "server" + File.separator + "TestMail" + File.separator + "Test.zip");
            String attach = String.valueOf(file);
            SmtpMailer mailer = new SmtpMailer(serverName, fromAddress, toAddress, rb.getString("TestMail.TestMail"), null, userName, password, port, tls);
            SmtpMailer mailer1 = new SmtpMailer(serverName, fromAddress, toAddress, rb.getString("TestMail.TestMail"), attach, userName, password, port, tls);
            String message = rb.getString("TestMail.TestingMail") + serverName + rb.getString("TestMail.Port") + port + "</b>";
            String message1 = rb.getString("TestMail.TestingMailZip") + serverName + rb.getString("TestMail.Port") + port + "</b>";
            String result = "success";
            try {
                String temp = mailer.sendMessage(message);
                String temp1 = mailer1.sendMessage(message1);
                if (temp != null) {
                    result = "fail";
                }
                if (temp1 != null) {
                    result = "fail";
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                result = "fail";
            }
            JSONObject finalResponse = new JSONObject();
            if ("success".equals(result)) {
                finalResponse.put("status", true);
            } else {
                finalResponse.put("status", false);
            }
            responseBuilder.setResponse(finalResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveSettings(JSONObject requestObj, ResponseBuilder responseBuilder) {
        String status = "success";
        try {
            JSONObject reqJsonObject = requestObj.getJSONObject("MAILSETTINGS");
            String smtpServer = reqJsonObject.getString("serverName");
            String smtpServerPort = reqJsonObject.getString("port");
            String uName = reqJsonObject.getString("userName");
            String pWord = reqJsonObject.getString("password");
            String tlsAuthenticate = reqJsonObject.getString("tls");
            String fromId = reqJsonObject.getString("fromAddress");
            if (fromId == null) {
                fromId = "eventloganalyzer@localdomain.com";
            }
            DataObject obj = DataAccess.get((String)"ADSConnectionSecurity", (Criteria)new Criteria(Column.getColumn((String)"ADSConnectionSecurity", (String)"NAME"), (Object)tlsAuthenticate, 0));
            Long tlsstatus = (Long)obj.getFirstValue("ADSConnectionSecurity", "CONNECTION_SECURITY_ID");
            boolean htmlproperty = "true".equals(System.getProperty("ENABLE_HTML_FORMAT", "true"));
            JSONObject mailJson = new JSONObject();
            mailJson.put("SERVER_NAME", (Object)smtpServer);
            mailJson.put("PORT", (Object)smtpServerPort);
            mailJson.put("USER_NAME", (Object)uName);
            mailJson.put("PASSWORD", (Object)pWord);
            mailJson.put("CONNECTION_SECURITY_ID", (Object)tlsstatus);
            mailJson.put("FROM_MAIL_ID", (Object)fromId);
            mailJson.put("ADMIN_MAIL_ID", (Object)fromId);
            mailJson.put("ENABLE_HTML_FORMAT", htmlproperty);
            MailHandler.setMailSettings((JSONObject)mailJson, (boolean[])new boolean[0]);
            NotifierSettings.getInstance().updateMailServerSettings();
        }
        catch (Exception e) {
            status = "failure";
            e.printStackTrace();
        }
        try {
            if ("success".equals(status)) {
                responseBuilder.setResponse(new JSONObject().put("status", true));
            } else {
                responseBuilder.setResponse(new JSONObject().put("status", false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

