/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.settings.notification.sms;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotifierSettings;
import com.manageengine.ela.server.common.response.ember.ResponseBuilder;
import com.manageengine.ela.server.common.settings.notification.util.NotificationSettingsUtil;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import org.json.JSONException;
import org.json.JSONObject;
import org.smslib.COutgoingMessage;
import org.smslib.CService;

public class SMSSettingsManager {
    public static void fetchSmsServerSettings(ResponseBuilder responseBuilder) throws Exception {
        JSONObject resultJson = new JSONObject();
        String port = null;
        DataObject dobj = NotificationSettingsUtil.getSMSServerSettingsDO();
        Iterator itr = dobj.getRows("SmsServerSettings");
        JSONObject obj = new JSONObject();
        if (itr.hasNext()) {
            Row smsRow = (Row)itr.next();
            port = (String)smsRow.get("PORT");
            if (port == null) {
                obj.put("isSms", false);
                resultJson.put("sms", (Object)obj);
            } else {
                obj.put("isSms", true);
                obj.put("port", (Object)port);
                resultJson.put("sms", (Object)obj);
            }
        }
        responseBuilder.setResponse(resultJson);
    }

    public static void sendTestSMS(JSONObject reqJsonObject, ResponseBuilder responseBuilder) {
        String result = "success";
        try {
            ResourceBundle bundle = ProductBundle.getInstance().getBundle((Locale)reqJsonObject.get("locale"));
            JSONObject obj = reqJsonObject.getJSONObject("SMSSETTINGS");
            String port = obj.getString("comPort");
            String number = obj.getString("number");
            int baudRate = Integer.parseInt(System.getProperty("baudRate", "9600"));
            CService srv = new CService(port, baudRate, "Nokia", "6100");
            srv.setSimPin("0000");
            srv.connect();
            srv.setSmscNumber("");
            COutgoingMessage msg = new COutgoingMessage(number, bundle.getString("Test.Msg"));
            msg.setMessageEncoding(3);
            msg.setSourcePort(0);
            srv.sendMessage(msg);
            srv.disconnect();
        }
        catch (JSONException e) {
            result = "failure";
            e.printStackTrace();
        }
        catch (Exception e) {
            result = "failure";
            e.printStackTrace();
        }
        try {
            JSONObject resultJsonobject = new JSONObject();
            if ("success".equals(result)) {
                resultJsonobject.put("status", true);
            } else {
                resultJsonobject.put("status", false);
            }
            responseBuilder.setResponse(resultJsonobject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveSettings(JSONObject reqJsonObject, ResponseBuilder responseBuilder) {
        String status = "success";
        try {
            JSONObject request = reqJsonObject.getJSONObject("SMSSETTINGS");
            boolean add = true;
            DataObject doo = null;
            Table table = Table.getTable((String)"SmsServerSettings");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Criteria cri = new Criteria(Column.getColumn((String)"SmsServerSettings", (String)"TYPE"), (Object)"SYSLOG", 0);
            Column col = Column.getColumn((String)"SmsServerSettings", (String)"*");
            sql.addSelectColumn(col);
            sql.setCriteria(cri);
            doo = DataAccess.get((SelectQuery)sql);
            Row r1 = null;
            if (doo.getTableNames().size() == 0) {
                doo = DataAccess.constructDataObject();
                r1 = new Row("SmsServerSettings");
            } else {
                add = false;
                r1 = doo.getFirstRow("SmsServerSettings");
            }
            String Port = request.getString("comPort");
            r1.set("PORT", (Object)Port);
            r1.set("TYPE", (Object)"SYSLOG");
            r1.set("MESSAGE", (Object)"Not Availabele");
            if (add) {
                doo.addRow(r1);
                DataAccess.add((DataObject)doo);
            } else {
                doo.updateRow(r1);
                DataAccess.update((DataObject)doo);
            }
            NotifierSettings.getInstance().updateSmsServerSettings();
        }
        catch (Exception e) {
            status = "failure";
            e.printStackTrace();
        }
        try {
            if ("success".equals(status)) {
                responseBuilder.setResponse(new JSONObject().put("status", true));
            } else {
                responseBuilder.setResponse(new JSONObject().put("status", false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

