/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.windows.evtfile.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.executors.processor.extended.CommonTimerTask;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.JSONUtil;
import com.manageengine.ela.server.windows.evtfile.constants.EvtFileConfigConstants;
import com.manageengine.ela.server.windows.evtfile.discovery.EvtFileDiscoveryListener;
import com.manageengine.ela.server.windows.evtfile.util.EvtFileDiscoveryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class EvtFileConfigHandler {
    private static final Logger LOGGER = Logger.getLogger(EvtFileConfigHandler.class.getName());

    public static BaseStatusCode configureRegistryKey(JSONObject reqJsonObject) throws BaseStatusCode, JSONException, DataAccessException {
        long deviceId = reqJsonObject.getLong("DEVICE_ID");
        List<String> configuredFileList = EvtFileDiscoveryUtil.getConfiguredFileList(deviceId);
        List<String> keyList = JSONUtil.toList(reqJsonObject.getJSONArray("KEY_LIST"));
        ArrayList<String> addKeyList = new ArrayList<String>(keyList);
        addKeyList.removeAll(configuredFileList);
        ArrayList<String> deleteKeyList = new ArrayList<String>(configuredFileList);
        deleteKeyList.removeAll(keyList);
        deleteKeyList.removeAll(EvtFileConfigConstants.PREDEFINED_EVENTSOURCEFILES);
        if (addKeyList.size() <= 0 && deleteKeyList.size() <= 0) {
            return BaseStatusCode.getBaseStatusCode(0);
        }
        BaseStatusCode status = EvtFileConfigHandler.callExecutorFutureActions(deviceId, addKeyList, deleteKeyList);
        if (status.getOrgStatusCode() == 0L || status.getOrgStatusCode() == 9732L) {
            EvtFileConfigHandler.updateDBPostAction(deviceId);
        }
        return status;
    }

    public static BaseStatusCode callExecutorFutureActions(long deviceId, final List<String> addKeyList, final List<String> deleteKeyList) throws DataAccessException {
        final Map<String, String> cred = DeviceUtil.getDeviceBasicDetails(deviceId);
        final String devicename = cred.get("DEVICE_NAME");
        try {
            return CommonTimerTask.execute(new Callable<BaseStatusCode>(){

                @Override
                public BaseStatusCode call() throws Exception {
                    return BaseStatusCode.getBaseStatusCode(ELANativeHandler.configureRegistryKey(InetAddressHandler.isLocalMachine(devicename), cred, addKeyList, deleteKeyList));
                }
            }, EvtFileDiscoveryUtil.getDiscoveryTimeOut());
        }
        catch (TimeoutException e) {
            LOGGER.info("Exception occurred while configuring :" + e);
            return BaseStatusCode.getBaseStatusCode(9733);
        }
        catch (Exception e) {
            LOGGER.info("Exception occurred while configuring :" + e);
            return BaseStatusCode.getBaseStatusCode(9731);
        }
    }

    private static BaseStatusCode updateConfiguredEvtFiles(long deviceId, final EvtFileDiscoveryListener listener) throws DataAccessException {
        final Map<String, String> cred = DeviceUtil.getDeviceBasicDetails(deviceId);
        final String devicename = cred.get("DEVICE_NAME");
        try {
            return CommonTimerTask.execute(new Callable<BaseStatusCode>(){

                @Override
                public BaseStatusCode call() throws Exception {
                    return BaseStatusCode.getBaseStatusCode(ELANativeHandler.discoverEvtFiles(InetAddressHandler.isLocalMachine(devicename), cred, listener));
                }
            }, EvtFileDiscoveryUtil.getDiscoveryTimeOut());
        }
        catch (Exception e) {
            LOGGER.info("Exception while updating DB after configuration:" + e);
            return BaseStatusCode.getBaseStatusCode(7938);
        }
    }

    private static void updateDBPostAction(long deviceId) {
        try {
            PersistenceDBUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"ELAWindowsEvtFilesInfo", (String)"DEVICE_ID"), (Object)deviceId, 0));
            EvtFileConfigHandler.updateConfiguredEvtFiles(deviceId, EvtFileDiscoveryListener.init(100, deviceId));
        }
        catch (DataAccessException e) {
            LOGGER.info("Exception occurred while DB update after configuration:" + (Object)((Object)e));
        }
    }
}

