/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.windows.evtfile.discovery;

import com.adventnet.persistence.DataAccessException;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.discovery.Discovery;
import com.manageengine.ela.server.common.discovery.DiscoveryParameters;
import com.manageengine.ela.server.common.discovery.DiscoveryStatusHolder;
import com.manageengine.ela.server.common.executors.processor.extended.CommonTimerTask;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.windows.evtfile.discovery.EvtFileDiscoveryListener;
import com.manageengine.ela.server.windows.evtfile.util.EvtFileDiscoveryUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

public class EvtFileDiscoveryHandler {
    private static final Logger LOGGER = Logger.getLogger(EvtFileDiscoveryHandler.class.getName());
    private static final Cache<Long, Boolean> IN_DISCOVERYPROCESS = new Cache();
    private static final Lock SYNC = new ReentrantLock();
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startEvtFileDiscovery(Long deviceID, boolean isThread) throws Exception {
        DiscoveryParameters parameters = new DiscoveryParameters();
        parameters.setDeviceID(deviceID);
        parameters.setDiscoveryType(3);
        parameters.setDiscoveryUniqueOption(10);
        parameters.initDiscoveryStatusHolder();
        DiscoveryStatusHolder holder = parameters.getStatusHolder();
        BaseStatusCode status = BaseStatusCode.getBaseStatusCode(7682);
        holder.setStatusCode(Long.parseLong(status.getStatusCode(), 16));
        holder.setStatusMessage(status.getDisplayTextKey());
        parameters.getStatusHolder().commitStatus();
        if (EvtFileDiscoveryHandler.preDiscovery(deviceID)) {
            try {
                if (isThread) {
                    SERVICE.execute(new EvtFileDiscovery(deviceID, parameters));
                } else {
                    new EvtFileDiscovery(deviceID, parameters).startDiscovery();
                }
            }
            finally {
                EvtFileDiscoveryHandler.postDiscovery(deviceID);
            }
        }
    }

    private static boolean preDiscovery(Long deviceID) {
        SYNC.lock();
        try {
            if (IN_DISCOVERYPROCESS.containsKey(deviceID)) {
                boolean bl = false;
                return bl;
            }
            IN_DISCOVERYPROCESS.put(deviceID, Boolean.TRUE);
            boolean bl = true;
            return bl;
        }
        finally {
            SYNC.unlock();
        }
    }

    private static void postDiscovery(Long deviceID) {
        SYNC.lock();
        try {
            IN_DISCOVERYPROCESS.remove(deviceID);
        }
        finally {
            SYNC.unlock();
        }
    }

    private static class EvtFileDiscovery
    implements Discovery,
    Runnable {
        private final Long deviceID;
        private static final int DOMAXSIZE = 100;
        private BaseStatusCode status;
        private DiscoveryParameters parameters = null;

        private EvtFileDiscovery(Long deviceID, DiscoveryParameters parameters) {
            this.deviceID = deviceID;
            this.parameters = parameters;
        }

        @Override
        public void startDiscovery() throws Exception {
            DiscoveryStatusHolder holder = this.parameters.getStatusHolder();
            EvtFileDiscoveryListener listner = EvtFileDiscoveryListener.init(100, this.deviceID);
            this.status = this.callExecutorFutureDetails(this.deviceID, listner);
            listner.flush();
            holder.setStatusCode(Long.parseLong(this.status.getStatusCode(), 16));
            holder.setStatusMessage(this.status.getDisplayTextKey());
            this.parameters.getStatusHolder().finalizeStatus();
        }

        @Override
        public boolean isCompleted() {
            return false;
        }

        @Override
        public void run() {
            try {
                this.startDiscovery();
            }
            catch (Exception e) {
                LOGGER.info("Exception in Event Files Discovery " + e);
            }
        }

        private BaseStatusCode callExecutorFutureDetails(long deviceId, final EvtFileDiscoveryListener listener) throws DataAccessException {
            final Map<String, String> cred = DeviceUtil.getDeviceBasicDetails(deviceId);
            final String devicename = cred.get("DEVICE_NAME");
            try {
                return CommonTimerTask.execute(new Callable<BaseStatusCode>(){

                    @Override
                    public BaseStatusCode call() throws Exception {
                        return BaseStatusCode.getBaseStatusCode(ELANativeHandler.discoverEvtFiles(InetAddressHandler.isLocalMachine(devicename), cred, listener));
                    }
                }, EvtFileDiscoveryUtil.getDiscoveryTimeOut());
            }
            catch (TimeoutException e) {
                LOGGER.info("Exception occurred while discovering :" + e);
                return BaseStatusCode.getBaseStatusCode(9733);
            }
            catch (Exception e) {
                LOGGER.info("Exception occurred while discovering :" + e);
                return BaseStatusCode.getBaseStatusCode(9731);
            }
        }
    }
}

