/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.windows.evtfile.discovery;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.jni.listner.ELANativeFlushableListener;
import com.manageengine.ela.server.windows.evtfile.util.EvtFileDiscoveryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class EvtFileDiscoveryListener
implements ELANativeFlushableListener {
    private static final Logger LOGGER = Logger.getLogger(EvtFileDiscoveryListener.class.getName());
    private DataObject dobj;
    private final int limit;
    private final long deviceId;
    private long flagID = 0L;

    private EvtFileDiscoveryListener(int limit, long deviceId) throws DataAccessException {
        this.limit = limit;
        this.deviceId = deviceId;
        this.dobj = PersistenceDBUtil.getPersistence().constructDataObject();
    }

    public static EvtFileDiscoveryListener init(int limit, long deviceId) throws DataAccessException {
        return new EvtFileDiscoveryListener(limit, deviceId);
    }

    public void addRow(Properties filesInfo) {
        ArrayList addedFiles = (ArrayList)filesInfo.get("ADDED_EVENT_FILES");
        try {
            List<String> evtFileList = EvtFileDiscoveryUtil.getKeyListFromEvtVwr(this.deviceId);
            int i = 0;
            if (this.flagID != this.deviceId) {
                this.flagID = this.deviceId;
                PersistenceDBUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"ELAWindowsEvtFilesInfo", (String)"DEVICE_ID"), (Object)this.deviceId, 0));
                for (String evtFile : evtFileList) {
                    Row row = new Row("ELAWindowsEvtFilesInfo");
                    row.set("DEVICE_ID", (Object)this.deviceId);
                    row.set("EVTFILE_NAME", (Object)evtFile);
                    if (addedFiles.contains(evtFile)) {
                        row.set("ISCONFIGURED", (Object)Boolean.TRUE);
                    }
                    this.dobj.addRow(row);
                    if (++i != this.limit) continue;
                    this.commit();
                    i = 0;
                }
                if (i > 0) {
                    this.commit();
                }
                this.flagID = 0L;
            }
        }
        catch (Exception e) {
            this.flagID = 0L;
            LOGGER.info("Failed in add Row " + e);
        }
    }

    public boolean isCompleted() {
        return false;
    }

    @Override
    public void flush() throws IOException {
        if (this.dobj.size("ELAWindowsEvtFilesInfo") > 0) {
            this.commit();
        }
    }

    private void commit() {
        try {
            PersistenceDBUtil.getPersistence().update(this.dobj);
        }
        catch (DataAccessException e) {
            LOGGER.info("Failed to commit " + (Object)((Object)e));
        }
    }
}

