/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.windows.evtfile.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.windows.evtfile.constants.EvtFileConfigConstants;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFilenameFilter;

public class EvtFileDiscoveryUtil {
    public static List<String> getConfiguredFileList(long deviceId) throws DataAccessException {
        ArrayList<String> configuredFileList = new ArrayList<String>();
        Criteria crit = new Criteria(Column.getColumn((String)"ELAWindowsEvtFilesInfo", (String)"DEVICE_ID"), (Object)deviceId, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"ELAWindowsEvtFilesInfo", (String)"ISCONFIGURED"), (Object)Boolean.TRUE, 0));
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELAWindowsEvtFilesInfo", crit);
        Iterator itr = dobj.getRows("ELAWindowsEvtFilesInfo");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            configuredFileList.add((String)row.get("EVTFILE_NAME"));
        }
        return configuredFileList;
    }

    public static Long getDiscoveryTimeOut() throws DataAccessException {
        DataObject dobj = PersistenceDBUtil.getPersistence().get("SystemConfigurations", new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EvtFile_DiscoveryTimeOut", 0));
        return Long.valueOf((String)dobj.getFirstValue("SystemConfigurations", "CONF_VALUE"));
    }

    public static List<String> getKeyListFromEvtVwr(long deviceId) throws Exception {
        boolean isRemote;
        ArrayList<String> keyList = new ArrayList<String>();
        Map<String, String> cred = DeviceUtil.getDeviceBasicDetails(deviceId);
        String deviceName = cred.get("DEVICE_NAME");
        boolean bl = isRemote = !InetAddressHandler.isLocalMachine(deviceName);
        if (isRemote) {
            String username = cred.get("USERNAME");
            String password = cred.get("PASSWORD");
            String domain = cred.get("DOMAIN_NAME");
            NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(domain, username, password);
            String url = deviceName + "/" + EvtFileConfigConstants.EVTVWR_LOCATION.replace(":", "$");
            SmbFile folder = new SmbFile("smb://" + url, auth);
            for (SmbFile fileEntry : folder.listFiles(new SmbFilenameFilter(){

                public boolean accept(SmbFile dir, String name) {
                    return name.endsWith(".evtx") || name.endsWith(".evt");
                }
            })) {
                String str = EvtFileDiscoveryUtil.formatString(fileEntry.getName());
                keyList.add(str);
            }
        } else {
            File file = new File(EvtFileConfigConstants.EVTVWR_LOCATION);
            File[] files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File name) {
                    return name.getName().endsWith(".evtx") || name.getName().endsWith(".evt");
                }
            });
            if (file.listFiles() != null && file.exists()) {
                for (int i = 0; i < files.length; ++i) {
                    String str = EvtFileDiscoveryUtil.formatString(files[i].toString());
                    keyList.add(str);
                }
            } else if (file.listFiles() == null) {
                String username = cred.get("USERNAME");
                String password = cred.get("PASSWORD");
                String domain = cred.get("DOMAIN_NAME");
                NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(domain, username, password);
                String url = deviceName + "/" + EvtFileConfigConstants.EVTVWR_LOCATION.replace(":", "$");
                SmbFile folder = new SmbFile("smb://" + url, auth);
                for (SmbFile fileEntry : folder.listFiles(new SmbFilenameFilter(){

                    public boolean accept(SmbFile dir, String name) {
                        return name.endsWith(".evtx") || name.endsWith(".evt");
                    }
                })) {
                    String str = EvtFileDiscoveryUtil.formatString(fileEntry.getName());
                    keyList.add(str);
                }
            } else {
                throw BaseStatusCode.getBaseStatusCode(7426);
            }
        }
        return keyList;
    }

    private static String formatString(String str) {
        str = str.substring(str.lastIndexOf("\\") + 1);
        str = str.substring(0, str.lastIndexOf("."));
        str = str.replaceAll("%4", "/");
        return str;
    }
}

