/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.application.others.ApplicationMgmtUtils;
import com.manageengine.ela.server.application.others.OtherServerOperations;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.credential.CredentialHandler;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.operations.SQLServerInstanceOperations;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.query.SQLServerQueryHandler;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.reports.SQLServerReportsHandler;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerProperties;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQLServerInstanceConfig {
    private static final Logger LOGGER = Logger.getLogger(SQLServerInstanceConfig.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public static Long[] getInstaceIDsFromRequest(JSONObject req) {
        Long[] ret = null;
        try {
            JSONArray instanceIDs = req.getJSONArray("INSTANCE_ID");
            ret = new Long[instanceIDs.length()];
            for (int i = 0; i < instanceIDs.length(); ++i) {
                ret[i] = instanceIDs.getLong(i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static JSONObject addInstance(JSONObject reqJson, UserAccessResource accessControl) {
        JSONObject b = new JSONObject();
        JSONArray addedInstances = new JSONArray();
        SQLServerProperties prop = new SQLServerProperties();
        try {
            JSONArray js = null;
            js = reqJson.isNull("INSTANCE_ID") ? reqJson.getJSONArray("INSTANCES") : SQLServerUtils.getInstanceDetailsForIDS(SQLServerInstanceConfig.getInstaceIDsFromRequest(reqJson));
            prop.setAuth(reqJson.getInt("AUTHENTICATION"));
            prop.setUsername(reqJson.getString("USERNAME"));
            prop.setPassword(reqJson.getString("PASSWORD"));
            prop.setIsAuditingEnabled(reqJson.getBoolean("IS_AUDITING_ENABLED"));
            prop.setDomain(reqJson.getString("DOMAIN"));
            for (int i = 0; i < js.length(); ++i) {
                JSONObject obj = js.getJSONObject(i);
                prop.setHostname(obj.getString("HOST_NAME"));
                prop.setPort(obj.getInt("PORT"));
                String incomingInstance = obj.getString("INSTANCE_NAME");
                prop.setInstance(incomingInstance.length() == 0 ? prop.getHostname() : incomingInstance);
                b = SQLServerInstanceConfig.checkAndAddInstance(prop, accessControl);
                if (b.getInt("STATUS_CODE") != 0) {
                    return b;
                }
                addedInstances.put(b.getLong("SERVER_ID"));
            }
            b.put("SERVER_ID", (Object)addedInstances);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                b.put("STATUS_CODE", 7937);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return b;
    }

    public static JSONObject checkAndAddInstance(SQLServerProperties prop, UserAccessResource accessControl) {
        JSONObject bs = new JSONObject();
        String host = prop.getHostname();
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add(host.toLowerCase());
        hostList.add(host.toUpperCase());
        if (SQLServerUtils.isDevicePresentAsSQLServer(hostList, null)) {
            return SQLServerInstanceConfig.addInstanceToDB(prop);
        }
        try {
            Long hostID = ApplicationMgmtUtils.getHostID(host);
            if (hostID == null) {
                JSONObject discoveryRequest = new JSONObject();
                discoveryRequest.put("DEVICE_NAME", (Object)host);
                discoveryRequest = DeviceUtil.isDeviceDiscovered(discoveryRequest);
                if (discoveryRequest.isNull("DOMAIN_ID") && discoveryRequest.isNull("WORKGROUP_ID")) {
                    AddOrUpdateEventlogDevice.addUnverifiedDevice(host, LogSourceCategoryContainer.DeviceCategory.WINDOWS);
                } else {
                    SQLServerUtils.setDevicePropertiesAndAddDevice(discoveryRequest, accessControl);
                }
                hostID = ApplicationMgmtUtils.getHostID(host);
            }
            JSONObject json = new JSONObject();
            json.put("HOST_ID", (Object)hostID);
            json.put("FGROUP", (Object)"MSSQL");
            Long appid = ApplicationMgmtUtils.getAppid(json);
            if (appid == null) {
                json.put("HOSTS", (Object)new JSONArray().put((Object)host));
                json.put("APPTYPE", (Object)"mssqlauditlogs");
                JSONObject tempRes = OtherServerOperations.addAppServer(json);
                if (tempRes.getInt("STATUS_CODE") != 0) {
                    bs.put("STATUS_CODE", 7937);
                    return bs;
                }
            }
            bs = SQLServerInstanceConfig.addInstanceToDB(prop);
        }
        catch (Exception e) {
            try {
                bs.put("STATUS_CODE", 7937);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return bs;
    }

    public static JSONObject addInstanceToDB(SQLServerProperties prop) {
        JSONObject bs = new JSONObject();
        try {
            String hostName = prop.getHostname();
            int port = prop.getPort();
            int auth = prop.getAuth();
            String userName = prop.getUsername();
            String password = prop.getPassword();
            String domain = prop.getDomain();
            String instance = prop.getInstance();
            boolean isAuditingEnabled = prop.getIsAuditingEnabled();
            boolean isenabled = true;
            int serverStatus = 0;
            if (auth == -1) {
                isenabled = false;
                serverStatus = 2;
            } else {
                SQLServerQueryHandler handler = new SQLServerQueryHandler(prop);
                boolean isLoginVerified = handler.verifyConnection();
                if (isLoginVerified) {
                    instance = SQLServerUtils.getInstanceName(prop);
                    serverStatus = 0;
                } else {
                    serverStatus = 1;
                    isenabled = false;
                }
            }
            Long hostId = ApplicationMgmtUtils.getHostID(hostName);
            JSONObject json = new JSONObject();
            json.put("HOST_ID", (Object)hostId);
            json.put("FGROUP", (Object)"MSSQL");
            Long appid = ApplicationMgmtUtils.getAppid(json);
            if (SQLServerUtils.checkDuplicate(appid, prop.getPort())) {
                bs.put("STATUS_CODE", 7432);
                return bs;
            }
            Credential cred = CredentialHandler.getCustomCredential(userName == null || userName.isEmpty() ? "LOG360_SQL_USERNAME" : userName, password == null || password.isEmpty() ? "LOG360_SQL_PASSWORD" : password, domain, hostName);
            CredentialHandler.createNewCredentialEntry(cred);
            Long credentialid = cred.getCredentialID();
            if (credentialid == null) {
                bs.put("STATUS_CODE", 460);
                return bs;
            }
            Row row = new Row("SQLServerDetails");
            row.set("HOST_NAME", (Object)hostName);
            row.set("APPID", (Object)appid);
            row.set("PORT", (Object)port);
            row.set("AUTHENTICATION", (Object)auth);
            row.set("CREDENTIAL_ID", (Object)cred.getCredentialID());
            row.set("IS_AUDITING_ENABLED", (Object)isAuditingEnabled);
            row.set("IS_ENABLED", (Object)true);
            row.set("SERVER_STATUS", (Object)serverStatus);
            row.set("INSTANCE_NAME", (Object)instance);
            DataObject dObj = PERSISTENCELITE.constructDataObject();
            dObj.addRow(row);
            PERSISTENCELITE.add(dObj);
            long SERVERID = (Long)row.get("SERVER_ID");
            if (isenabled && isAuditingEnabled) {
                SQLServerInstanceOperations.enableAudit(SERVERID, prop);
                SQLServerReportsHandler.getInstance().add(new Long(SERVERID));
            }
            LOGGER.log(Level.INFO, "HOSTID is = {0}", hostId);
            bs.put("STATUS_CODE", 0);
            bs.put("SERVER_ID", SERVERID);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                bs.put("STATUS_CODE", 7430);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return bs;
    }

    public static BaseStatusCode changeStatus(JSONObject reqJson, boolean flag) {
        BaseStatusCode bs = null;
        try {
            String table = reqJson.getString("TABLE_NAME");
            String pkColumn = reqJson.getString("PK_COLUMN");
            JSONArray pkValue = reqJson.getJSONArray("PK_VALUE");
            String updateCol = reqJson.getString("UPDATE_COLUMN");
            ArrayList<Long> pk = new ArrayList<Long>();
            for (int i = 0; i < pkValue.length(); ++i) {
                long value = pkValue.getLong(i);
                pk.add(value);
            }
            bs = SQLServerUtils.changeMonitoringStatus(table, pkColumn, updateCol, pk, flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            bs = BaseStatusCode.getBaseStatusCode(7430);
        }
        return bs;
    }

    public static boolean updateDetailsInDb(long serverid, SQLServerProperties prop, SQLServerProperties disableProperties) {
        boolean isUpdated = true;
        try {
            boolean verify = new SQLServerQueryHandler(prop).verifyConnection();
            boolean isAuditEnabled = prop.getIsAuditingEnabled();
            if (prop.getInstance().equalsIgnoreCase("")) {
                prop.setInstance(prop.getHostname());
            }
            if (verify) {
                String instanceName = SQLServerUtils.getInstanceName(prop);
                prop.setInstance(instanceName == null ? prop.getHostname() : instanceName);
                SQLServerInstanceOperations.changeStatus(serverid, prop, isAuditEnabled);
                if (isAuditEnabled) {
                    SQLServerInstanceOperations.enableAudit(serverid, prop);
                    SQLServerInstanceOperations.changeStatus(serverid, prop, true);
                } else {
                    SQLServerInstanceOperations.disableAudit(serverid, disableProperties);
                    SQLServerInstanceOperations.changeStatus(serverid, disableProperties, false);
                }
            }
            boolean oldCredentialLogin = new SQLServerQueryHandler(disableProperties).verifyConnection();
            if (!isAuditEnabled && oldCredentialLogin) {
                SQLServerInstanceOperations.disableAudit(serverid, disableProperties);
            }
            int status = verify ? 0 : 1;
            HashMap<String, Object> update = new HashMap<String, Object>();
            update.put("AUTHENTICATION", prop.getAuth());
            update.put("PORT", prop.getPort());
            update.put("SERVER_STATUS", status);
            update.put("IS_ENABLED", verify);
            update.put("INSTANCE_NAME", prop.getInstance());
            update.put("IS_AUDITING_ENABLED", isAuditEnabled);
            DataBaseReqestProcessor.executeUpdateQuery("SQLServerDetails", update, new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"SERVER_ID"), (Object)serverid, 0), true);
        }
        catch (Exception e) {
            isUpdated = false;
            e.printStackTrace();
        }
        return isUpdated;
    }

    public static BaseStatusCode updateInstance(JSONObject json) {
        BaseStatusCode bs = null;
        try {
            long serverid = json.getLong("INSTANCE_ID");
            Long credentialID = json.getLong("CREDENTIAL_ID");
            SQLServerProperties prop = new SQLServerProperties();
            SQLServerProperties disableProperties = SQLServerUtils.getDetailsAsProperties(serverid);
            prop.setHostname(json.getString("HOST_NAME"));
            prop.setAuth(json.getInt("AUTHENTICATION"));
            prop.setPort(json.getInt("PORT"));
            prop.setUsername(json.getString("USERNAME"));
            prop.setPassword(json.getString("PASSWORD"));
            prop.setDomain(json.getString("DOMAIN"));
            prop.setInstance(json.optString("INSTANCE_NAME"));
            prop.setIsAuditingEnabled(json.getBoolean("IS_AUDITING_ENABLED"));
            String username = prop.getUsername();
            String password = prop.getPassword();
            Credential cred = CredentialHandler.getELACredential(credentialID);
            cred.setCredentialID(credentialID);
            CredentialHandler.setCredentialParameters(cred, prop.getDomain(), username == null || username.isEmpty() ? "LOG360_SQL_USERNAME" : username, password == null || password.isEmpty() ? "LOG360_SQL_PASSWORD" : password);
            CredentialHandler.updateCredentialEntry(cred);
            boolean isUpdated = SQLServerInstanceConfig.updateDetailsInDb(serverid, prop, disableProperties);
            if (!isUpdated) {
                return BaseStatusCode.getBaseStatusCode(7430);
            }
            bs = BaseStatusCode.getBaseStatusCode(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            bs = BaseStatusCode.getBaseStatusCode(7430);
        }
        return bs;
    }

    public static BaseStatusCode deleteInstance(JSONObject reqJsonObject) {
        BaseStatusCode bs = null;
        try {
            ArrayList<Long> appids = new ArrayList<Long>();
            ArrayList<Long> credentials = new ArrayList<Long>();
            JSONArray instanceIDArray = reqJsonObject.getJSONArray("INSTANCE_ID");
            ArrayList<Long> instanceIDs = new ArrayList<Long>();
            for (int i = 0; i < instanceIDArray.length(); ++i) {
                long instanceID = instanceIDArray.getLong(i);
                instanceIDs.add(instanceID);
                SQLServerProperties prop = SQLServerUtils.getDetailsAsProperties(instanceID);
                SQLServerInstanceOperations.disableAudit(instanceID, prop);
            }
            SQLServerInstanceOperations.deleteTriggersForThisInstance(instanceIDs);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"SERVER_ID"), (Object)instanceIDs.toArray(new Long[instanceIDs.size()]), 8);
            sq.setCriteria(crit);
            DataObject detob = PERSISTENCELITE.get((SelectQuery)sq);
            Long[] credArray = new Long[detob.size("SQLServerDetails")];
            Iterator it = detob.getRows("SQLServerDetails");
            int i = 0;
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long appid = (Long)r.get("APPID");
                credentials.add((Long)r.get("CREDENTIAL_ID"));
                credArray[i] = (Long)r.get("CREDENTIAL_ID");
                ++i;
                if (appids.contains(appid)) continue;
                appids.add(appid);
            }
            PERSISTENCELITE.delete(crit);
            ApplicationMgmtUtils.updateAppResources(appids);
            CredentialHandler.deleteCredential(credArray);
            bs = BaseStatusCode.getBaseStatusCode(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            bs = BaseStatusCode.getBaseStatusCode(7430);
        }
        return bs;
    }
}

