/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.discovery;

import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.discovery.SQLServerDiscoveryListenerInterface;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.discovery.SQLServerDiscoveryUtil;
import java.net.InetAddress;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerDiscoveryListener
implements SQLServerDiscoveryListenerInterface {
    private static final Logger LOGGER = Logger.getLogger(SQLServerDiscoveryListener.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private DataObject dataObject = PERSISTENCELITE.constructDataObject();
    private static final int COUNT_THRESHOLD = 10;
    private int count = 0;

    @Override
    public boolean addDiscoveredSQLServer(String serverName) {
        return false;
    }

    public void addRow(Properties serverProps) {
        LOGGER.log(Level.INFO, "Discovered Server {0}", serverProps.getProperty("SERVER_NAME"));
        String serverName = serverProps.getProperty("SERVER_NAME");
        List<Properties> instanceList = SQLServerDiscoveryUtil.getServerProperties(serverName);
        if (instanceList == null) {
            return;
        }
        if (this.count == 10) {
            this.addInstanceBeforeCompletion();
            this.count = 0;
        }
        ++this.count;
        this.updateDataObject(instanceList);
    }

    public void addInstanceBeforeCompletion() {
        try {
            PERSISTENCELITE.add(this.dataObject);
            this.dataObject.deleteRows("SQLServerDiscoveredInstances", (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean addToDatabase() {
        try {
            this.addInstanceBeforeCompletion();
            List<Properties> instanceList = SQLServerDiscoveryUtil.getServerProperties(InetAddress.getLocalHost().getHostName());
            if (instanceList != null) {
                this.updateDataObject(instanceList);
                this.addInstanceBeforeCompletion();
            }
            CommonUtil.updateSysConfiguration("SQL_Discovery", "2", true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isCompleted() {
        return false;
    }

    private void updateDataObject(List<Properties> instanceList) {
        String server = null;
        int port = -1;
        String instance = null;
        try {
            for (int i = 0; i < instanceList.size(); ++i) {
                server = instanceList.get(i).getProperty("HOST_NAME");
                instance = instanceList.get(i).getProperty("INSTANCE_NAME");
                port = Integer.parseInt(instanceList.get(i).getProperty("PORT"));
                Row r = new Row("SQLServerDiscoveredInstances");
                r.set("HOST_NAME", (Object)server);
                r.set("INSTANCE_NAME", (Object)instance);
                r.set("PORT", (Object)port);
                this.dataObject.addRow(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

