/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.operations;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.query.SQLServerQueryHandler;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerProperties;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQLServerInstanceOperations {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public static List<Long> getPredefinedEventIDs() {
        ArrayList<Long> ret = new ArrayList<Long>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerPredefinedEventids"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerPredefinedEventids", (String)"*"));
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerPredefinedEventids");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long eventId = (Long)r.get("EVENT_ID");
                ret.add(eventId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean checkIfEventIdAdded(long instanceID) {
        boolean isInserted = false;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerEventidsList"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerEventidsList", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerEventidsList", (String)"SERVER_ID"), (Object)instanceID, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            if (!dob.isEmpty()) {
                isInserted = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInserted;
    }

    public static boolean addEventIDToTable(long instanceID) {
        boolean isAlreadyAdded = SQLServerInstanceOperations.checkIfEventIdAdded(instanceID);
        if (isAlreadyAdded) {
            return true;
        }
        boolean isAdded = true;
        List<Long> eventIDs = SQLServerInstanceOperations.getPredefinedEventIDs();
        try {
            DataObject dob = PERSISTENCELITE.constructDataObject();
            for (int i = 0; i < eventIDs.size(); ++i) {
                Row r = new Row("SQLServerEventidsList");
                r.set("SERVER_ID", (Object)instanceID);
                r.set("EVENT_ID", (Object)eventIDs.get(i));
                r.set("IS_ENABLED", (Object)false);
                dob.addRow(r);
            }
            PERSISTENCELITE.add(dob);
        }
        catch (Exception e) {
            isAdded = false;
            e.printStackTrace();
        }
        return isAdded;
    }

    public static void updateInTable(long instanceID, boolean flag, List<Long> eventID) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerEventidsList", (String)"SERVER_ID"), (Object)instanceID, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerEventidsList", (String)"EVENT_ID"), (Object)eventID.toArray(new Long[eventID.size()]), 8);
            DataBaseReqestProcessor.executeUpdateQuery("SQLServerEventidsList", "IS_ENABLED", flag, crit.and(crit1), true);
            DataBaseReqestProcessor.executeUpdateQuery("SQLServerDetails", "IS_EVENTID_ENABLED", flag, new Criteria(new Column("SQLServerDetails", "SERVER_ID"), (Object)instanceID, 0), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean changeStatus(long instanceID, SQLServerProperties prop, boolean flag) {
        SQLServerInstanceOperations.addEventIDToTable(instanceID);
        SQLServerQueryHandler queryHandler = new SQLServerQueryHandler(prop);
        ArrayList<String> queries = new ArrayList<String>();
        List<Long> predefinedEventIDList = SQLServerInstanceOperations.getPredefinedEventIDs();
        String status = flag ? ",'WITH_LOG',TRUE;" : ",'WITH_LOG',FALSE;";
        for (int i = 0; i < predefinedEventIDList.size(); ++i) {
            String query = "EXEC SP_ALTERMESSAGE " + predefinedEventIDList.get(i) + status;
            queries.add(query);
        }
        queryHandler.executeQueryList(queries);
        SQLServerInstanceOperations.updateInTable(instanceID, flag, predefinedEventIDList);
        return true;
    }

    public static boolean enableAudit(long serverid, SQLServerProperties prop) {
        boolean isEnabled = true;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerAuditingDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerAuditingDetails", (String)"*"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"SQLServerAuditingDetails", (String)"INSTANCE_ID"), (Object)serverid, 0));
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            if (!dob.isEmpty()) {
                return true;
            }
            SQLServerQueryHandler handler = new SQLServerQueryHandler(prop);
            String auditName = SQLServerUtils.getRandomString().replace("-", "_");
            String specName = SQLServerUtils.getRandomString().replace("-", "_");
            String auditQuery = "CREATE SERVER AUDIT [$AUDIT] TO APPLICATION_LOG WITH ( QUEUE_DELAY = 1000);";
            auditQuery = auditQuery.replace("[$AUDIT]", auditName);
            String enableAudit = "ALTER SERVER AUDIT [$AUDIT] WITH (STATE=ON);";
            enableAudit = enableAudit.replace("[$AUDIT]", auditName);
            String specs = "CREATE SERVER AUDIT SPECIFICATION [$AUDITSPEC] FOR SERVER AUDIT [$AUDIT] ADD(FAILED_LOGIN_GROUP),ADD(SUCCESSFUL_LOGIN_GROUP),ADD(DATABASE_OBJECT_CHANGE_GROUP),ADD(DATABASE_PRINCIPAL_CHANGE_GROUP),ADD(SCHEMA_OBJECT_CHANGE_GROUP),ADD(SERVER_PRINCIPAL_CHANGE_GROUP),ADD(LOGIN_CHANGE_PASSWORD_GROUP),ADD(SERVER_STATE_CHANGE_GROUP),ADD(SCHEMA_OBJECT_ACCESS_GROUP) WITH (STATE = ON);";
            specs = specs.replace("[$AUDIT]", auditName);
            specs = specs.replace("[$AUDITSPEC]", specName);
            ArrayList<String> queries = new ArrayList<String>();
            queries.add(auditQuery);
            queries.add(enableAudit);
            queries.add(specs);
            isEnabled = handler.executeQueryList(queries);
            if (isEnabled) {
                Row r = new Row("SQLServerAuditingDetails");
                r.set("INSTANCE_ID", (Object)serverid);
                r.set("SERVER_AUDIT_NAME", (Object)auditName);
                r.set("SERVER_AUDIT_SPECIFICATION_NAME", (Object)specName);
                r.set("IS_CREATED", (Object)true);
                DataObject dObj = PERSISTENCELITE.constructDataObject();
                dObj.addRow(r);
                PERSISTENCELITE.add(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isEnabled = false;
        }
        return isEnabled;
    }

    public static boolean disableAudit(long serverid, SQLServerProperties prop) {
        boolean isDisabled = true;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerAuditingDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerAuditingDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerAuditingDetails", (String)"INSTANCE_ID"), (Object)serverid, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerAuditingDetails");
            if (it.hasNext()) {
                Row r = (Row)it.next();
                String auditName = (String)r.get("SERVER_AUDIT_NAME");
                String specName = (String)r.get("SERVER_AUDIT_SPECIFICATION_NAME");
                ArrayList<String> queries = new ArrayList<String>();
                String disableAuditSpec = "ALTER SERVER AUDIT SPECIFICATION [$AUDITSPEC] WITH (STATE = OFF);";
                disableAuditSpec = disableAuditSpec.replace("[$AUDITSPEC]", specName);
                disableAuditSpec = disableAuditSpec.replace("[$AUDIT]", auditName);
                String disableAudit = "ALTER SERVER AUDIT [$AUDIT] WITH (STATE=OFF);".replace("[$AUDIT]", auditName);
                String delAudit = "DROP SERVER AUDIT [$AUDIT]".replace("[$AUDIT]", auditName);
                String delSpec = "DROP SERVER AUDIT SPECIFICATION [$AUDITSPEC]".replace("[$AUDITSPEC]", specName);
                queries.add(disableAuditSpec);
                queries.add(delSpec);
                queries.add(disableAudit);
                queries.add(delAudit);
                SQLServerQueryHandler handler = new SQLServerQueryHandler(prop);
                isDisabled = handler.executeQueryList(queries);
            }
            PERSISTENCELITE.delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
            isDisabled = false;
        }
        return isDisabled;
    }

    public static List<List<String>> executeQuery(JSONObject details) {
        List<List<String>> resp = new ArrayList<List<String>>();
        try {
            int auth = details.getInt("AUTHENTICATION");
            String username = details.getString("USERNAME");
            String password = details.getString("PASSWORD");
            String url = details.getString("URL");
            String database = details.isNull("USE_DB") ? null : details.getString("USE_DB");
            String query = details.getString("QUERY");
            SQLServerQueryHandler handler = new SQLServerQueryHandler(auth, username, password, url);
            resp = handler.executeQueryWithMultipleResults(database, query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resp;
    }

    public static JSONObject isPrimaryKeyPresent(JSONObject details) {
        JSONObject ret = new JSONObject();
        try {
            String database = details.getString("DATABASE_NAME");
            String table = details.getString("TABLE_NAME");
            String query = "SELECT KU.table_name as TABLENAME,column_name as PRIMARYKEYCOLUMN FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS AS TC INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE AS KU ON TC.CONSTRAINT_TYPE = 'PRIMARY KEY' AND TC.CONSTRAINT_NAME = KU.CONSTRAINT_NAME AND KU.table_name='[$TABLE]' ORDER BY KU.TABLE_NAME, KU.ORDINAL_POSITION;".replace("[$TABLE]", table.replace("'", "''"));
            details.put("USE_DB", (Object)database);
            details.put("QUERY", (Object)query);
            List<List<String>> resp = SQLServerInstanceOperations.executeQuery(details);
            if (resp.size() == 0) {
                ret.put("IS_PRIMARY_KEY_PRESENT", false);
            } else {
                ret.put("IS_PRIMARY_KEY_PRESENT", true);
                ret.put("PRIMARY_KEY", (Object)resp.get(0).get(1));
            }
        }
        catch (Exception e) {
            try {
                ret.put("IS_PRIMARY_KEY_PRESENT", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
        return ret;
    }

    public static JSONObject getPrimaryKeyPosition(JSONObject details) {
        JSONObject ret = new JSONObject();
        try {
            String req;
            String database = details.getString("DATABASE_NAME");
            String table = details.getString("TABLE_NAME");
            String column = details.getString("COLUMN_NAME");
            String query = req = "select ordinal_position from information_schema.columns where TABLE_NAME='[$TABLE]' and COLUMN_NAME=N'[$COLUMN]';".replace("[$TABLE]", table.replace("'", "''")).replace("[$COLUMN]", column.replace("'", "''"));
            details.put("USE_DB", (Object)database);
            details.put("QUERY", (Object)query);
            List<List<String>> resp = SQLServerInstanceOperations.executeQuery(details);
            if (resp.size() == 0) {
                ret.put("IS_POSITION_FOUND", false);
            } else {
                ret.put("IS_POSITION_FOUND", true);
                ret.put("PK_POSITION", (Object)resp.get(0).get(0));
            }
        }
        catch (Exception e) {
            try {
                ret.put("IS_POSITION_FOUND", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean checkIfDuplicateColumn(long instanceID, String database, String table, String column) {
        boolean isDuplicate = false;
        try {
            SelectQueryImpl dup = new SelectQueryImpl(Table.getTable((String)"SQLServerColumns"));
            dup.addSelectColumn(Column.getColumn((String)"SQLServerColumns", (String)"*"));
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"DATABASE_NAME"), (Object)database, 0);
            Criteria crit2 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"TABLE_NAME"), (Object)table, 0);
            Criteria crit3 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"COLUMN_NAME"), (Object)column, 0);
            Criteria crit4 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"SERVER_ID"), (Object)instanceID, 0);
            dup.setCriteria(crit1.and(crit2.and(crit3.and(crit4))));
            DataObject dupo = PERSISTENCELITE.get((SelectQuery)dup);
            if (!dupo.isEmpty()) {
                isDuplicate = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDuplicate;
    }

    public static boolean addColumnToTable(long instanceID, String database, String table, String column, String triggerName) {
        boolean isColumnAdded = true;
        try {
            Row r = new Row("SQLServerColumns");
            r.set("SERVER_ID", (Object)instanceID);
            r.set("DATABASE_NAME", (Object)database);
            r.set("TABLE_NAME", (Object)table);
            r.set("COLUMN_NAME", (Object)column);
            r.set("TRIGGER_NAME", (Object)triggerName);
            DataObject dObj = PERSISTENCELITE.constructDataObject();
            dObj.addRow(r);
            PERSISTENCELITE.add(dObj);
        }
        catch (Exception e) {
            isColumnAdded = false;
            e.printStackTrace();
        }
        return isColumnAdded;
    }

    public static JSONObject addTriggerForColumn(JSONObject details) {
        JSONObject triggerDetails = new JSONObject();
        try {
            int auth = details.getInt("AUTHENTICATION");
            String username = details.getString("USERNAME");
            String password = details.getString("PASSWORD");
            String database = details.getString("DATABASE_NAME");
            String table = details.getString("TABLE_NAME");
            String column = details.getString("COLUMN_NAME");
            String pk = details.getString("PK_NAME");
            String instance = details.getString("INSTANCE_NAME").replace("\\", "#");
            String url = details.getString("URL");
            String tableChanged = "{\"HOSTID\":\"[$SERVERHOST_ID]\",\"APPID\":\"[$APPRESOURCE_ID]\",\"SERVERID\":\"[$SERVER_ID]\",\"INSTANCE\":\"[$INSTANCE]\",\"DATABASE\":\"[$DATABASE]\",\"TABLE\":\"[$TABLE]\",\"COLUMN\":\"[$COLUMN]\",\"OLD\":\"%s\",\"NEW\":\"%s\",\"DOMAIN\":\"%s\",\"USER\":\"%s\"}".replace("[$INSTANCE]", instance);
            tableChanged = tableChanged.replace("[$DATABASE]", database.replace("'", "''"));
            tableChanged = tableChanged.replace("[$TABLE]", table.replace("'", "''"));
            tableChanged = tableChanged.replace("[$COLUMN]", column.replace("'", "''"));
            tableChanged = tableChanged.replace("[$SERVER_ID]", Long.toString(details.getLong("SERVER_ID")));
            tableChanged = tableChanged.replace("[$APPRESOURCE_ID]", Long.toString(details.getLong("APPID")));
            tableChanged = tableChanged.replace("[$SERVERHOST_ID]", Long.toString(details.getLong("HOSTID")));
            String triggerName = SQLServerUtils.getRandomString().replace("-", "_");
            String triggerTable = table;
            String triggerQuery = null;
            triggerQuery = pk.equalsIgnoreCase(column) ? "create trigger [$TRIGGER_NAME] on [[$TRIGGER_TABLE]] after update as if (update([[$TRIGGER_COLUMN]])) declare @domain varchar(100);declare @user_name varchar(100);declare @old varchar(100);declare @new varchar(100);declare @sid varbinary(100);declare @user varchar(100);select top 1 @sid = [transaction sid] from fn_dblog(null,null) where [transaction name]='UPDATE' order by [begin time] desc;select @user = COALESCE(suser_sname(@sid),suser_sname());select @domain = SUBSTRING(@user,0,CHARINDEX('\\',@user));select @user_name = SUBSTRING(@user,charindex('\\',@user)+1,len(@user)+1);select @new = rtrim([[$PRIMARY_KEY]]) from inserted;select @old = rtrim([[$PRIMARY_KEY]]) from deleted;if(@new != @old) raiserror(N'[$TABLE_CHANGED]',10,1,@old,@new,@domain,@user_name) with log;".replace("[$TRIGGER_NAME]", triggerName) : "create trigger [$TRIGGER_NAME] on [[$TRIGGER_TABLE]] after update as if (update([[$TRIGGER_COLUMN]])) declare @setid cursor; declare @domain varchar(100);declare @user_name varchar(100);declare @old varchar(100);declare @new varchar(100);declare @getid cursor;declare @sid varbinary(100);declare @user varchar(100);select top 1 @sid = [transaction sid] from fn_dblog(null,null) where [transaction name]='UPDATE' order by [begin time] desc;select @user = COALESCE(suser_sname(@sid),suser_sname());select @domain = SUBSTRING(@user,0,CHARINDEX('\\',@user));select @user_name = SUBSTRING(@user,charindex('\\',@user)+1,len(@user)+1);set @getid = cursor for select inserted.[[$TRIGGER_COLUMN]],deleted.[[$TRIGGER_COLUMN]] from inserted join deleted on inserted.[[$PRIMARY_KEY]]=deleted.[[$PRIMARY_KEY]] open @getid fetch next from @getid into @new,@old while @@fetch_status = 0 begin if(@new != @old)begin raiserror(N'[$TABLE_CHANGED]',10,1,@old,@new,@domain,@user_name) with log;end fetch next from @getid into @old,@new end".replace("[$TRIGGER_NAME]", triggerName);
            triggerQuery = triggerQuery.replace("[$TRIGGER_TABLE]", triggerTable);
            triggerQuery = triggerQuery.replace("[$TRIGGER_COLUMN]", column);
            triggerQuery = triggerQuery.replace("[$PRIMARY_KEY]", pk);
            triggerQuery = triggerQuery.replace("[$TABLE_CHANGED]", tableChanged);
            SQLServerQueryHandler handler = new SQLServerQueryHandler(auth, username, password, url);
            boolean isTriggerAdded = handler.executeQueryWithNoResult(database, triggerQuery);
            if (!isTriggerAdded) {
                triggerDetails.put("IS_TRIGGER_ADDED", false);
            } else {
                triggerDetails.put("IS_TRIGGER_ADDED", true);
                triggerDetails.put("TRIGGER_NAME", (Object)triggerName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return triggerDetails;
    }

    public static BaseStatusCode addColumn(JSONObject sqlConfig) {
        BaseStatusCode bs = null;
        JSONObject details = SQLServerUtils.getDetailsOfAnInstance(sqlConfig);
        try {
            long databaseID = sqlConfig.getLong("DATABASE_ID");
            String database = (String)SQLServerUtils.getName("SQLServerDatabases", "DATABASE_NAME", "DATABASE_ID", databaseID);
            long tableID = sqlConfig.getLong("TABLE_ID");
            String table = (String)SQLServerUtils.getName("SQLServerTables", "TABLE_NAME", "TABLE_ID", tableID);
            JSONArray columns = sqlConfig.getJSONArray("COLUMNS");
            details.put("DATABASE_NAME", (Object)database);
            details.put("TABLE_NAME", (Object)table);
            JSONObject pkJSON = SQLServerInstanceOperations.isPrimaryKeyPresent(details);
            boolean isPrimaryKeyPresent = pkJSON.getBoolean("IS_PRIMARY_KEY_PRESENT");
            if (!isPrimaryKeyPresent) {
                return BaseStatusCode.getBaseStatusCode(463);
            }
            String pk = pkJSON.getString("PRIMARY_KEY");
            details.put("PK_NAME", (Object)pk);
            for (int i = 0; i < columns.length(); ++i) {
                details.put("COLUMN_NAME", (Object)columns.getString(i));
                JSONObject pkPositionJSON = SQLServerInstanceOperations.getPrimaryKeyPosition(details);
                boolean isPositionFound = pkPositionJSON.getBoolean("IS_POSITION_FOUND");
                if (!isPositionFound) {
                    return BaseStatusCode.getBaseStatusCode(464);
                }
                details.put("PK_POSITION", (Object)pkPositionJSON.getString("PK_POSITION"));
                boolean isDuplicate = SQLServerInstanceOperations.checkIfDuplicateColumn(sqlConfig.getLong("INSTANCE_ID"), database, table, columns.getString(i));
                if (isDuplicate) {
                    return BaseStatusCode.getBaseStatusCode(7432);
                }
                JSONObject triggerDetails = SQLServerInstanceOperations.addTriggerForColumn(details);
                boolean isTriggerCreated = triggerDetails.getBoolean("IS_TRIGGER_ADDED");
                if (!isTriggerCreated) {
                    return BaseStatusCode.getBaseStatusCode(465);
                }
                String triggerName = triggerDetails.getString("TRIGGER_NAME");
                sqlConfig.put("TRIGGER_NAME", (Object)triggerName);
                boolean isColumnAdded = SQLServerInstanceOperations.addColumnToTable(sqlConfig.getLong("INSTANCE_ID"), database, table, columns.getString(i), triggerName);
                if (isColumnAdded) continue;
                return BaseStatusCode.getBaseStatusCode(466);
            }
            bs = BaseStatusCode.getBaseStatusCode(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            bs = BaseStatusCode.getBaseStatusCode(7430);
        }
        return bs;
    }

    public static boolean deleteTriggers(JSONObject deleteDetails) {
        boolean isDeleted = false;
        try {
            int auth = deleteDetails.getInt("AUTHENTICATION");
            String username = deleteDetails.getString("USERNAME");
            String password = deleteDetails.getString("PASSWORD");
            String database = deleteDetails.getString("DATABASE_NAME");
            String triggerName = deleteDetails.getString("TRIGGER_NAME");
            String query = " DROP TRIGGER " + triggerName + ";";
            String url = deleteDetails.getString("URL");
            SQLServerQueryHandler handler = new SQLServerQueryHandler(auth, username, password, url);
            List<List<String>> isTriggerPresent = handler.executeQueryWithMultipleResults(database, "SELECT * FROM SYS.TRIGGERS WHERE NAME='[$TRIGGER_NAME]'".replace("[$TRIGGER_NAME]", triggerName));
            if (isTriggerPresent.size() == 0) {
                return true;
            }
            isDeleted = handler.executeQueryWithNoResult(database, query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean deleteTriggersForColumnList(List<Long> columnID) {
        boolean isDeleted = true;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerColumns"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerColumns", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"COLUMN_ID"), (Object)columnID.toArray(new Long[columnID.size()]), 8);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerColumns");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String database = (String)r.get("DATABASE_NAME");
                String trigger = (String)r.get("TRIGGER_NAME");
                Long instanceID = (Long)r.get("SERVER_ID");
                JSONObject deleteDetails = new JSONObject();
                JSONObject details = new JSONObject();
                details.put("INSTANCE_ID", (Object)instanceID);
                deleteDetails = SQLServerUtils.getDetailsOfAnInstance(details);
                deleteDetails.put("DATABASE_NAME", (Object)database);
                deleteDetails.put("TRIGGER_NAME", (Object)trigger);
                boolean isTriggerDeleted = SQLServerInstanceOperations.deleteTriggers(deleteDetails);
                if (isTriggerDeleted) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isDeleted = false;
        }
        return isDeleted;
    }

    public static boolean deleteColumnsFromTable(List<Long> columnID) {
        boolean isDeleted = true;
        try {
            DeleteQueryImpl dq = new DeleteQueryImpl("SQLServerColumns");
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"COLUMN_ID"), (Object)columnID.toArray(new Long[columnID.size()]), 8);
            dq.setCriteria(crit);
            PERSISTENCELITE.delete((DeleteQuery)dq);
        }
        catch (Exception e) {
            isDeleted = false;
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static BaseStatusCode deleteColumn(JSONObject details) {
        BaseStatusCode bs = null;
        try {
            JSONArray columnIDString = details.getJSONArray("COLUMN_ID");
            ArrayList<Long> columnID = new ArrayList<Long>();
            for (int i = 0; i < columnIDString.length(); ++i) {
                columnID.add(columnIDString.getLong(i));
            }
            boolean areTriggersDeleted = SQLServerInstanceOperations.deleteTriggersForColumnList(columnID);
            if (!areTriggersDeleted) {
                return BaseStatusCode.getBaseStatusCode(468);
            }
            boolean isColumnDeleted = SQLServerInstanceOperations.deleteColumnsFromTable(columnID);
            if (!isColumnDeleted) {
                return BaseStatusCode.getBaseStatusCode(7430);
            }
            bs = BaseStatusCode.getBaseStatusCode(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            bs = BaseStatusCode.getBaseStatusCode(7430);
        }
        return bs;
    }

    public static List<String> returnListFromJSONOArray(JSONArray inp, String key) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            for (int i = 0; i < inp.length(); ++i) {
                ret.add(inp.getJSONObject(i).getString(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static BaseStatusCode getAllDatabases(JSONObject request) {
        BaseStatusCode bs = null;
        long serverid = -1L;
        try {
            JSONObject details = SQLServerUtils.getDetailsOfAnInstance(request);
            int authenticationType = details.getInt("AUTHENTICATION");
            String userName = details.getString("USERNAME");
            String password = details.getString("PASSWORD");
            String url = details.getString("URL");
            String query = "SELECT NAME FROM MASTER.DBO.SYSDATABASES WHERE NAME NOT IN ('MASTER','TEMPDB','MODEL','MSDB');";
            SQLServerQueryHandler handler = new SQLServerQueryHandler(authenticationType, userName, password, url);
            List<List<String>> res = handler.executeQueryWithMultipleResults(null, query);
            serverid = details.getLong("SERVER_ID");
            List<String> databasesList = SQLServerInstanceOperations.returnListFromJSONOArray(SQLServerUtils.getDatabases(serverid), "DATABASE_NAME");
            ArrayList<String> incomingDBsList = new ArrayList<String>();
            for (int i = 0; res != null && i < res.size(); ++i) {
                String dbname = res.get(i).get(0);
                incomingDBsList.add(dbname);
                if (databasesList.contains(dbname)) {
                    SQLServerInstanceOperations.getAllTables(SQLServerInstanceOperations.getDatabaseID(serverid, dbname), dbname, details);
                    continue;
                }
                Row r = new Row("SQLServerDatabases");
                r.set("SERVER_ID", (Object)serverid);
                r.set("DATABASE_NAME", (Object)dbname);
                r.set("IS_ENABLED", (Object)true);
                DataObject dob = PERSISTENCELITE.constructDataObject();
                dob.addRow(r);
                PERSISTENCELITE.add(dob);
                long dbid = (Long)r.get("DATABASE_ID");
                SQLServerInstanceOperations.getAllTables(dbid, dbname, details);
            }
            if (res != null) {
                SQLServerInstanceOperations.deleteNonRequiredEntries("SQLServerDatabases", "SERVER_ID", serverid, "DATABASE_NAME", incomingDBsList);
            }
            bs = BaseStatusCode.getBaseStatusCode(0);
        }
        catch (Exception e) {
            bs = BaseStatusCode.getBaseStatusCode(7430);
            e.printStackTrace();
        }
        return bs;
    }

    public static Long getDatabaseID(long serverid, String dbname) {
        long dbid = -1L;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDatabases"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDatabases", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerDatabases", (String)"SERVER_ID"), (Object)serverid, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerDatabases", (String)"DATABASE_NAME"), (Object)dbname, 0);
            Criteria baseCrit = crit.and(crit1);
            sq.setCriteria(baseCrit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDatabases");
            if (!dob.isEmpty()) {
                Row r = (Row)it.next();
                dbid = (Long)r.get("DATABASE_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbid;
    }

    public static boolean getAllTables(long databaseid, String databaseName, JSONObject details) {
        boolean isTableRetrieved = true;
        try {
            List<String> tablesList = SQLServerInstanceOperations.returnListFromJSONOArray(SQLServerUtils.getTables(databaseid), "TABLE_NAME");
            int authenticationType = details.getInt("AUTHENTICATION");
            String userName = details.getString("USERNAME");
            String password = details.getString("PASSWORD");
            String url = details.getString("URL");
            SQLServerQueryHandler handler = new SQLServerQueryHandler(authenticationType, userName, password, url);
            String query = "SELECT NAME FROM SYS.TABLES;";
            List<List<String>> res = handler.executeQueryWithMultipleResults(databaseName, query);
            ArrayList<String> incomingTablesList = new ArrayList<String>();
            DataObject dob = PERSISTENCELITE.constructDataObject();
            for (int i = 0; res != null && i < res.size(); ++i) {
                String tableName = res.get(i).get(0);
                incomingTablesList.add(tableName);
                if (tablesList.contains(tableName)) continue;
                Row r = new Row("SQLServerTables");
                r.set("DATABASE_ID", (Object)databaseid);
                r.set("TABLE_NAME", (Object)tableName);
                r.set("IS_ENABLED", (Object)true);
                dob.addRow(r);
            }
            PERSISTENCELITE.add(dob);
            if (res != null) {
                SQLServerInstanceOperations.deleteNonRequiredEntries("SQLServerTables", "DATABASE_ID", databaseid, "TABLE_NAME", incomingTablesList);
            }
        }
        catch (Exception e) {
            isTableRetrieved = false;
            e.printStackTrace();
        }
        return isTableRetrieved;
    }

    public static void deleteNonRequiredEntries(String tablename, String primaryKeyName, long primaryKey, String nonRequiredColumnName, List<String> values) {
        try {
            DeleteQueryImpl dq = new DeleteQueryImpl(tablename);
            Criteria crit = new Criteria(Column.getColumn((String)tablename, (String)primaryKeyName), (Object)primaryKey, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)tablename, (String)nonRequiredColumnName), (Object)values.toArray(new String[values.size()]), 9);
            Criteria baseCrit = crit.and(crit1);
            dq.setCriteria(baseCrit);
            PERSISTENCELITE.delete((DeleteQuery)dq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteTriggersForThisInstance(List<Long> values) {
        boolean isDeleted = false;
        try {
            ArrayList<Long> columnID = new ArrayList<Long>();
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerColumns"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerColumns", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"SERVER_ID"), (Object)values.toArray(new Long[values.size()]), 8);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerColumns");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long columnId = (Long)r.get("COLUMN_ID");
                columnID.add(columnId);
            }
            isDeleted = SQLServerInstanceOperations.deleteTriggersForColumnList(columnID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }
}

