/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.query;

import com.adventnet.sa.server.lc.RecordReader;
import com.adventnet.sa.server.util.DBUtil;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.json.JSONObject;

public class SQLServerQueryHandler {
    private static final Logger LOGGER = Logger.getLogger(SQLServerQueryHandler.class.getName());
    private int auth = -1;
    private String username = null;
    private String password = null;
    private String url = null;
    private static RecordReader reader = null;

    public static String getURL(SQLServerProperties prop) {
        return "jdbc:jtds:sqlserver://" + prop.getHostname() + ":" + prop.getPort() + ";";
    }

    public static String getDomainURL(SQLServerProperties prop) {
        return "jdbc:jtds:sqlserver://" + prop.getHostname() + ":" + prop.getPort() + ";useNTLMv2=true;domain=" + prop.getDomain() + ";";
    }

    public static String resolveURL(SQLServerProperties prop) {
        if (prop.getAuth() < 2) {
            return SQLServerQueryHandler.getURL(prop);
        }
        return SQLServerQueryHandler.getDomainURL(prop);
    }

    public SQLServerQueryHandler(SQLServerProperties prop) {
        this.auth = prop.getAuth();
        this.username = prop.getUsername();
        this.password = prop.getPassword();
        this.url = SQLServerQueryHandler.resolveURL(prop);
    }

    public SQLServerQueryHandler(int authType, String user, String pass, String linkto) {
        this.auth = authType;
        this.username = user;
        this.password = pass;
        this.url = linkto;
    }

    public static Long getEpochTime(String str1, String str2) {
        Long epoch = null;
        String str = str1 + " " + str2;
        String DATE_FORMAT = (str = str.replace("/", "-")).charAt(19) == '.' ? "yyyy-MM-dd HH:mm:ss.SSS Z" : "yyyy-MM-dd HH:mm:ss:SSS Z";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = sdf.parse(str);
            epoch = date.getTime();
        }
        catch (ParseException e) {
            LOGGER.info(e.getMessage());
        }
        return epoch;
    }

    public static Long returnEpochTime() {
        return System.currentTimeMillis();
    }

    public static boolean isDateBefore(String startDate, String endDate) {
        try {
            String format = startDate.charAt(19) == ':' ? "yyyy/MM/dd HH:mm:ss:SSS" : "yyyy-MM-dd HH:mm:ss.SSS";
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(startDate).before(sdf.parse(endDate));
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    public Hashtable<String, Object> fillParamMap(Hashtable<String, String> ansTable) {
        Hashtable<String, Object> paramMap = new Hashtable<String, Object>();
        paramMap.put("IndexAll", "true");
        paramMap.put("REPORTNAME", ansTable.get("REPORTNAME"));
        paramMap.put("HOSTTYPE", ansTable.get("HOSTTYPE"));
        paramMap.put("INSTANCEID", ansTable.get("INSTANCEID"));
        paramMap.put("HOSTNAME", ansTable.get("HOSTNAME"));
        paramMap.put("MSGFIELD", ansTable.get("MSGFIELD"));
        paramMap.put("MESSAGE", ansTable.get("MSGFIELD"));
        paramMap.put("SEVERITY", Integer.parseInt(ansTable.get("SEVERITY")));
        paramMap.put("FORMATID", ansTable.get("FORMATID"));
        paramMap.put("HOSTID", Long.parseLong(ansTable.get("HOSTID")));
        paramMap.put("APPID", ansTable.get("APPID"));
        return paramMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyConnection() {
        Connection conn = null;
        boolean isConnected = false;
        try {
            DriverManager.setLoginTimeout(5);
            conn = this.auth == 1 ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
            isConnected = true;
            DBUtil.closeStmtAndConnection(null, conn);
        }
        catch (Exception e) {
            LOGGER.info("1. Login failed for current user.\n2. Network Error.\n3. IO Error occurred.\n4. Requested table or database is not found.\n5. Current user is unable to access the table or database.\n6. Unable to create the current object as it is a duplicate.\n7. Unable to delete as the current object is not present.\n8. Socket Closed.");
        }
        finally {
            DBUtil.closeStmtAndConnection(null, conn);
        }
        return isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeQueryList(List<String> queries) {
        boolean isExecuted = true;
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.auth == 1 ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
            st = conn.createStatement();
            for (int i = 0; i < queries.size(); ++i) {
                st.execute(queries.get(i));
            }
        }
        catch (Exception e) {
            try {
                isExecuted = false;
                LOGGER.info("1. Login failed for current user.\n2. Network Error.\n3. IO Error occurred.\n4. Requested table or database is not found.\n5. Current user is unable to access the table or database.\n6. Unable to create the current object as it is a duplicate.\n7. Unable to delete as the current object is not present.\n8. Socket Closed.");
            }
            catch (Throwable throwable) {
                DBUtil.closeStmtAndConnection(st, conn);
                throw throwable;
            }
            DBUtil.closeStmtAndConnection(st, conn);
        }
        DBUtil.closeStmtAndConnection(st, conn);
        return isExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeQueryWithNoResult(String database, String query) {
        boolean result = true;
        Connection conn = null;
        Statement st1 = null;
        ResultSet rs = null;
        String dbURL = this.url;
        if (database != null) {
            dbURL = dbURL.indexOf(";useNTLMv2") != -1 ? dbURL.replace(";useNTLMv2", "/" + database + ";useNTLMv2") : dbURL.replace(";", "/" + database + ";");
        }
        try {
            conn = this.auth == 1 ? DriverManager.getConnection(dbURL) : DriverManager.getConnection(dbURL, this.username, this.password);
            st1 = conn.createStatement();
            st1.execute(query);
        }
        catch (Exception e) {
            try {
                result = false;
                LOGGER.info("1. Login failed for current user.\n2. Network Error.\n3. IO Error occurred.\n4. Requested table or database is not found.\n5. Current user is unable to access the table or database.\n6. Unable to create the current object as it is a duplicate.\n7. Unable to delete as the current object is not present.\n8. Socket Closed.");
            }
            catch (Throwable throwable) {
                DBUtil.closeStmtAndConnection(st1, conn);
                DBUtil.closeResultSetOrDataSet(rs, null);
                throw throwable;
            }
            DBUtil.closeStmtAndConnection(st1, conn);
            DBUtil.closeResultSetOrDataSet(rs, null);
        }
        DBUtil.closeStmtAndConnection(st1, conn);
        DBUtil.closeResultSetOrDataSet(rs, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> executeQueryWithMultipleResults(String database, String query) {
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        String dbURL = this.url;
        if (database != null) {
            dbURL = dbURL.indexOf(";useNTLMv2") != -1 ? dbURL.replace(";useNTLMv2", "/" + database + ";useNTLMv2") : dbURL.replace(";", "/" + database + ";");
        }
        try {
            conn = this.auth == 1 ? DriverManager.getConnection(dbURL) : DriverManager.getConnection(dbURL, this.username, this.password);
            st = conn.createStatement();
            rs = st.executeQuery(query);
            int lenOfColumns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                ArrayList<String> currentRow = new ArrayList<String>();
                for (int j = 1; j <= lenOfColumns; ++j) {
                    currentRow.add(rs.getObject(j).toString());
                }
                result.add(currentRow);
            }
        }
        catch (Exception e) {
            try {
                result = null;
                LOGGER.info("1. Login failed for current user.\n2. Network Error.\n3. IO Error occurred.\n4. Requested table or database is not found.\n5. Current user is unable to access the table or database.\n6. Unable to create the current object as it is a duplicate.\n7. Unable to delete as the current object is not present.\n8. Socket Closed.");
            }
            catch (Throwable throwable) {
                DBUtil.closeStmtAndConnection(st, conn);
                DBUtil.closeResultSetOrDataSet(rs, null);
                throw throwable;
            }
            DBUtil.closeStmtAndConnection(st, conn);
            DBUtil.closeResultSetOrDataSet(rs, null);
        }
        DBUtil.closeStmtAndConnection(st, conn);
        DBUtil.closeResultSetOrDataSet(rs, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JSONObject runQueryAndIndexResults(Hashtable<String, String> ansTable, String[] columns, List<String> timeZoneColumns, String timeZone, String query, String database, String lastReportTime) {
        JSONObject ret;
        block15: {
            ret = new JSONObject();
            Hashtable<Object, Object> paramMap = new Hashtable();
            int lenOfColumns = columns.length;
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            String dbURL = this.url;
            if (database != null) {
                dbURL = dbURL.indexOf(";useNTLMv2") != -1 ? dbURL.replace(";useNTLMv2", "/" + database + ";useNTLMv2") : dbURL.replace(";", "/" + database + ";");
            }
            conn = this.auth == 1 ? DriverManager.getConnection(dbURL) : DriverManager.getConnection(dbURL, this.username, this.password);
            st = conn.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                paramMap = this.fillParamMap(ansTable);
                for (int j = 1; j <= lenOfColumns; ++j) {
                    String value = rs.getString(j);
                    if (value == null) continue;
                    paramMap.put(columns[j - 1], value.trim().length() == 0 ? "-" : value.trim());
                    if (!timeZoneColumns.contains(columns[j - 1])) continue;
                    if (SQLServerQueryHandler.isDateBefore(lastReportTime, value)) {
                        lastReportTime = value;
                    }
                    Long time = SQLServerQueryHandler.getEpochTime(value, timeZone);
                    paramMap.put("TIME", time);
                }
                if (paramMap.get("TIME") == null) {
                    paramMap.put("TIME", SQLServerQueryHandler.returnEpochTime());
                }
                paramMap.put("INSTANCENAME", ansTable.get("INSTANCENAME"));
                paramMap.put("SOURCE", ansTable.get("INSTANCENAME"));
                reader.processLogs(paramMap);
            }
            try {
                ret.put("LAST_REPORT_TIME", (Object)lastReportTime);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            DBUtil.closeStmtAndConnection(st, conn);
            DBUtil.closeResultSetOrDataSet(rs, null);
            break block15;
            catch (Exception e) {
                try {
                    LOGGER.info("1. Login failed for current user.\n2. Network Error.\n3. IO Error occurred.\n4. Requested table or database is not found.\n5. Current user is unable to access the table or database.\n6. Unable to create the current object as it is a duplicate.\n7. Unable to delete as the current object is not present.\n8. Socket Closed.");
                }
                catch (Throwable throwable) {
                    try {
                        ret.put("LAST_REPORT_TIME", (Object)lastReportTime);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    DBUtil.closeStmtAndConnection(st, conn);
                    DBUtil.closeResultSetOrDataSet(rs, null);
                    throw throwable;
                }
                try {
                    ret.put("LAST_REPORT_TIME", (Object)lastReportTime);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                DBUtil.closeStmtAndConnection(st, conn);
                DBUtil.closeResultSetOrDataSet(rs, null);
            }
        }
        return ret;
    }

    public void getOutputListAndIndexResults(Hashtable<String, String> ansTable, String[] columns, List<String> timeZoneColumns, String timeZone, List<String> results) {
        int lenOfColumns = columns.length;
        Hashtable<Object, Object> paramMap = new Hashtable();
        paramMap = this.fillParamMap(ansTable);
        for (int i = 0; i < lenOfColumns; ++i) {
            paramMap.put(columns[i], results.get(i));
            if (!timeZoneColumns.contains(columns[i])) continue;
            Long time = SQLServerQueryHandler.getEpochTime(results.get(i), timeZone);
            paramMap.put("TIME", time);
        }
        if (paramMap.get("TIME") == null) {
            paramMap.put("TIME", SQLServerQueryHandler.returnEpochTime());
        }
        paramMap.put("INSTANCENAME", ansTable.get("INSTANCENAME"));
        paramMap.put("SOURCE", ansTable.get("INSTANCENAME"));
        reader.processLogs(paramMap);
    }

    static {
        if (reader == null) {
            reader = new RecordReader();
        }
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
    }
}

