/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.application.others.ApplicationMgmtUtils;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.operations.SQLServerInstanceOperations;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.query.SQLServerQueryHandler;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerProperties;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class SQLServerReportsGenerator {
    private List<String> databases = new ArrayList<String>();
    private Hashtable<String, List<String>> tables = new Hashtable();
    private Hashtable<String, List<String>> transactids = new Hashtable();
    private Hashtable<String, String> ansTable = new Hashtable();
    private String[] columns = new String[0];
    private List<String> subQuery = new ArrayList<String>();
    private String timeZone = null;
    private List<String> timeZoneColumns = new ArrayList<String>();
    private String url = null;
    private String username = null;
    private String password = null;
    private String hostname = null;
    private int auth = -1;
    private String instance = null;
    private HashMap<Long, String> lastReportTime = new HashMap();
    private long serverID = 0L;
    private long hostid = 0L;
    private long appid = 0L;
    private Long queryID = new Long(-1L);
    private SQLServerQueryHandler reportHandler = null;
    private StringBuilder databaseFilter = null;
    private static final String QUOTE = "'";
    private int subQuerySize = -1;
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public SQLServerReportsGenerator(long id) {
        this.serverID = id;
    }

    public void addTimeZoneColumns() {
        this.timeZoneColumns.add("BEGINTIME");
        this.timeZoneColumns.add("ENDTIME");
        this.timeZoneColumns.add("UPDATETIME");
        this.timeZoneColumns.add("LASTEXECUTEDTIME");
        this.timeZoneColumns.add("CREATEDATE");
        this.timeZoneColumns.add("CREATEDDATE");
        this.timeZoneColumns.add("CREATEDTIME");
        this.timeZoneColumns.add("UPDATEDATE");
        this.timeZoneColumns.add("MODIFIEDDATE");
        this.timeZoneColumns.add("LASTDBCCTIME");
        this.timeZoneColumns.add("LASTLOGINTIME");
        this.timeZoneColumns.add("STARTTIME");
        this.timeZoneColumns.add("BACKUPSTARTDATE");
    }

    public String getTimeZone(int auth, String url, String username, String password) {
        String query = "SELECT DATENAME(TZ,SYSDATETIMEOFFSET())";
        SQLServerQueryHandler handler = new SQLServerQueryHandler(auth, username, password, url);
        String timeZone = null;
        try {
            timeZone = handler.executeQueryWithMultipleResults(null, query).get(0).get(0);
            timeZone = timeZone.replace(":", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timeZone;
    }

    public void populateDatabasesAndTables() {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDatabases"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerDatabases", (String)"SERVER_ID"), (Object)this.serverID, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerDatabases", (String)"IS_ENABLED"), (Object)true, 0);
            Criteria baseCrit = crit.and(crit1);
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDatabases", (String)"*"));
            sq.setCriteria(baseCrit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDatabases");
            if (it.hasNext()) {
                this.databaseFilter.append("(");
            }
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String dbname = (String)r.get("DATABASE_NAME");
                this.databases.add(dbname);
                this.databaseFilter.append(QUOTE);
                this.databaseFilter.append(dbname.replace(QUOTE, "''"));
                this.databaseFilter.append(QUOTE);
                if (it.hasNext()) {
                    this.databaseFilter.append(",");
                    continue;
                }
                this.databaseFilter.append(")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void populateTransactIDs(String inpQuery) {
        inpQuery = inpQuery.replace("[$LAST_REPORT_TIME]", this.lastReportTime.get(this.queryID));
        for (int i = 0; i < this.databases.size(); ++i) {
            String dbName = this.databases.get(i);
            ArrayList<String> transactIDsForThisDb = new ArrayList<String>();
            List<List<String>> res = this.reportHandler.executeQueryWithMultipleResults(dbName, inpQuery);
            int size = res == null ? 0 : res.size();
            for (int j = 0; j < size; ++j) {
                List<String> current = res.get(j);
                transactIDsForThisDb.add(current.get(0));
            }
            this.transactids.put(dbName, transactIDsForThisDb);
        }
    }

    public void executeQuery() {
        try {
            String initialLastReportTime = this.lastReportTime.get(this.queryID);
            String query = this.ansTable.get("SQLSTRING");
            query = query.replace("[$LAST_REPORT_TIME]", initialLastReportTime);
            String lastReportTimeFromResult = this.reportHandler.runQueryAndIndexResults(this.ansTable, this.columns, this.timeZoneColumns, this.timeZone, query, null, initialLastReportTime).getString("LAST_REPORT_TIME");
            if (lastReportTimeFromResult != null) {
                SQLServerUtils.updateReportsDetails("LAST_REPORT_TIME", lastReportTimeFromResult, this.serverID, this.queryID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void executeSimpleQuery(String database, String query) {
        try {
            String initialLastReportTime = this.lastReportTime.get(this.queryID);
            query = query.replace("[$LAST_REPORT_TIME]", initialLastReportTime);
            String lastReportTimeFromResult = this.reportHandler.runQueryAndIndexResults(this.ansTable, this.columns, this.timeZoneColumns, this.timeZone, query, database, initialLastReportTime).getString("LAST_REPORT_TIME");
            if (lastReportTimeFromResult != null) {
                SQLServerUtils.updateReportsDetails("LAST_REPORT_TIME", lastReportTimeFromResult, this.serverID, this.queryID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void executeSimpleQueryUtil() {
        for (int i = 0; i < this.databases.size(); ++i) {
            this.executeSimpleQuery(this.databases.get(i), this.ansTable.get("SQLSTRING"));
        }
    }

    public String getTransactIdsAndExecuteQuery(String dbName, String transactId) {
        String query = null;
        String returnTime = null;
        ArrayList<String> results = new ArrayList<String>();
        try {
            for (int i = 0; i < this.subQuery.size(); ++i) {
                query = this.subQuery.get(i);
                query = query.replace("$TRANSACTIONID", transactId);
                query = query.replace("[$LAST_REPORT_TIME]", this.lastReportTime.get(this.queryID));
                List<List<String>> outputs = this.reportHandler.executeQueryWithMultipleResults(dbName, query);
                String output = null;
                if (outputs.size() > 0 && outputs.get(0).size() > 0) {
                    output = outputs.get(0).get(0);
                }
                if (output == null || output.length() <= 0) continue;
                results.add(output);
                if (i != 4) continue;
                returnTime = output;
            }
            if (results.size() != this.subQuerySize) {
                return null;
            }
            this.reportHandler.getOutputListAndIndexResults(this.ansTable, this.columns, this.timeZoneColumns, this.timeZone, results);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnTime;
    }

    public void getTransactIdsAndExecuteQueryUtil() {
        String initialLastReportTime = this.lastReportTime.get(this.queryID);
        ArrayList results = new ArrayList();
        for (int i = 0; i < this.databases.size(); ++i) {
            String dbName = this.databases.get(i);
            List<String> transactIdsForThisDB = this.transactids.get(dbName);
            for (int j = 0; j < transactIdsForThisDB.size(); ++j) {
                String trID = transactIdsForThisDB.get(j);
                String incomingReportTime = this.getTransactIdsAndExecuteQuery(dbName, trID);
                if (incomingReportTime == null || incomingReportTime.length() <= 0 || !SQLServerQueryHandler.isDateBefore(initialLastReportTime, incomingReportTime)) continue;
                initialLastReportTime = incomingReportTime;
            }
            if (results.size() <= 0) continue;
            SQLServerUtils.updateReportsDetails("LAST_REPORT_TIME", initialLastReportTime, this.serverID, this.queryID);
        }
    }

    public void getTableNamesAndExecuteQuery(String dbName, String tableName) {
        String query = "";
        String initialLastReportTime = this.lastReportTime.get(this.queryID);
        try {
            String lastReportTimeFromResult;
            if (this.ansTable != null && this.ansTable.get("SQLSTRING") != null) {
                query = this.ansTable.get("SQLSTRING");
                query = query.replace("$TABLE", tableName);
                query = query.replace("[$LAST_REPORT_TIME]", initialLastReportTime);
            }
            if ((lastReportTimeFromResult = this.reportHandler.runQueryAndIndexResults(this.ansTable, this.columns, this.timeZoneColumns, this.timeZone, query, dbName, initialLastReportTime).getString("LAST_REPORT_TIME")) != null) {
                SQLServerUtils.updateReportsDetails("LAST_REPORT_TIME", lastReportTimeFromResult, this.serverID, this.queryID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getTableNamesAndExecuteQueryUtil() {
        for (int i = 0; i < this.databases.size(); ++i) {
            String dbName = this.databases.get(i);
            List<String> tablesForThisDB = this.tables.get(dbName);
            for (int j = 0; j < tablesForThisDB.size(); ++j) {
                this.getTableNamesAndExecuteQuery(dbName, tablesForThisDB.get(j));
            }
            tablesForThisDB.clear();
        }
    }

    public void executeDBFilterQueries() {
        String query = null;
        String initialLastReportTime = this.lastReportTime.get(this.queryID);
        try {
            if (this.ansTable != null && this.ansTable.get("SQLSTRING") != null) {
                query = this.ansTable.get("SQLSTRING");
                query = query.replace("[$DATABASEFILTER]", this.databaseFilter);
                String lastReportTimeFromResult = this.reportHandler.runQueryAndIndexResults(this.ansTable, this.columns, this.timeZoneColumns, this.timeZone, query = query.replace("[$LAST_REPORT_TIME]", initialLastReportTime), null, initialLastReportTime).getString("LAST_REPORT_TIME");
                if (lastReportTimeFromResult != null) {
                    SQLServerUtils.updateReportsDetails("LAST_REPORT_TIME", lastReportTimeFromResult, this.serverID, this.queryID);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void displayResults() {
        if (this.ansTable != null && this.ansTable.get("TRANSACTID") != null) {
            this.getTransactIdsAndExecuteQueryUtil();
            return;
        }
        if (this.ansTable != null && this.ansTable.get("DATABASE_FILTER") != null) {
            this.executeDBFilterQueries();
            return;
        }
        if (this.ansTable != null && this.ansTable.get("DATABASE") == null) {
            this.executeQuery();
            return;
        }
        if (this.ansTable != null && this.ansTable.get("TABLE") != null) {
            this.getTableNamesAndExecuteQueryUtil();
            return;
        }
        this.executeSimpleQueryUtil();
    }

    public void getDetailsForThisServerID(long serverid) {
        JSONObject json = new JSONObject();
        try {
            JSONObject req = new JSONObject();
            req.put("INSTANCE_ID", (Object)Long.toString(serverid));
            json = SQLServerUtils.getDetailsOfAnInstance(req);
            this.hostname = json.getString("HOSTNAME");
            this.auth = json.getInt("AUTHENTICATION");
            this.username = json.getString("USERNAME");
            this.password = json.getString("PASSWORD");
            this.url = json.getString("URL");
            this.instance = json.getString("INSTANCE_NAME");
            this.hostid = json.getLong("HOSTID");
            this.appid = json.getLong("APPID");
            json.put("INSTANCE_ID", serverid);
            SQLServerInstanceOperations.getAllDatabases(json);
            SQLServerInstanceOperations.addEventIDToTable(serverid);
            SQLServerProperties prop = SQLServerUtils.getDetailsAsProperties(serverid);
            SQLServerInstanceOperations.changeStatus(serverid, prop, true);
            SQLServerUtils.insertLastReportTimeForCurrentInstance(serverid);
            SQLServerInstanceOperations.enableAudit(serverid, prop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleSubQuery(Long inpid) {
        Long check = new Long(2L);
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerSubQueries"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerSubQueries", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerSubQueries", (String)"PARENT_QUERY_ID"), (Object)inpid, 0);
            SortColumn sc = new SortColumn(Column.getColumn((String)"SQLServerSubQueries", (String)"QUERY_ORDER"), true);
            sq.setCriteria(crit);
            sq.addSortColumn(sc);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerSubQueries");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String sqlString = (String)r.get("SQLSTRING");
                this.subQuery.add(sqlString);
            }
            if (inpid.longValue() == check.longValue()) {
                this.getTransactIdsAndExecuteQueryUtil();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addToHashTable(String key, Object value) {
        if (value != null) {
            this.ansTable.put(key, value.toString());
        }
    }

    public String[] getColumnsForReport(Long reportID) {
        String[] columns = null;
        try {
            SelectQueryImpl cols = new SelectQueryImpl(Table.getTable((String)"SQLServerQueriesColumns"));
            cols.addJoin(new Join("SQLServerQueriesColumns", "NoSqlIndexFields", new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
            cols.addSelectColumn(Column.getColumn((String)"SQLServerQueriesColumns", (String)"*"));
            cols.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"*"));
            SortColumn soc = new SortColumn("SQLServerQueriesColumns", "FIELD_ID", true);
            cols.addSortColumn(soc);
            cols.setCriteria(new Criteria(Column.getColumn((String)"SQLServerQueriesColumns", (String)"REPORT_ID"), (Object)reportID, 0));
            DataObject coldob = PERSISTENCELITE.get((SelectQuery)cols);
            columns = new String[coldob.size("NoSqlIndexFields")];
            Iterator colit = coldob.getRows("NoSqlIndexFields");
            int j = 0;
            while (colit.hasNext()) {
                Row r = (Row)colit.next();
                columns[j] = (String)r.get("FIELD_INDEX_NAME");
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public void generateReports() {
        try {
            this.getDetailsForThisServerID(this.serverID);
            this.timeZone = this.getTimeZone(this.auth, this.url, this.username, this.password);
            this.addTimeZoneColumns();
            this.databaseFilter = new StringBuilder();
            this.populateDatabasesAndTables();
            this.lastReportTime = SQLServerUtils.getLastReportTimeForInstance(this.serverID);
            this.reportHandler = new SQLServerQueryHandler(this.auth, this.username, this.password, this.url);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerQueries"));
            SortColumn sc = new SortColumn("SQLServerQueries", "ID", true);
            sq.addSelectColumn(Column.getColumn((String)"SQLServerQueries", (String)"*"));
            sq.addSortColumn(sc);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerQueries");
            int count = 0;
            while (it.hasNext()) {
                Long id;
                this.ansTable.clear();
                Row r = (Row)it.next();
                this.queryID = id = (Long)r.get("ID");
                String sqlString = (String)r.get("SQLSTRING");
                if (++count == 1) {
                    this.populateTransactIDs(sqlString);
                    continue;
                }
                this.addToHashTable("SQLSTRING", sqlString);
                this.addToHashTable("REPORTNAME", (String)r.get("REPORTNAME"));
                this.addToHashTable("MSGFIELD", (String)r.get("MSGFIELD"));
                this.addToHashTable("SEVERITY", (Integer)r.get("SEVERITY"));
                this.addToHashTable("DATABASE", (String)r.get("DATABASE"));
                this.addToHashTable("TRANSACTID", (String)r.get("TRANSACTID"));
                this.addToHashTable("SUB_QUERY", (Boolean)r.get("SUB_QUERY"));
                this.addToHashTable("DATABASE_FILTER", (Boolean)r.get("DATABASE_FILTER"));
                this.ansTable.put("HOSTTYPE", "mssqlauditlogs");
                this.ansTable.put("INSTANCEID", Long.toString(this.serverID));
                this.ansTable.put("HOSTNAME", this.hostname);
                this.ansTable.put("FORMATID", ApplicationMgmtUtils.getMssqlFormatId());
                this.ansTable.put("INSTANCENAME", this.instance);
                this.ansTable.put("HOSTID", Long.toString(this.hostid));
                this.ansTable.put("APPID", Long.toString(this.appid));
                this.columns = this.getColumnsForReport(id);
                if (this.ansTable.get("SUB_QUERY") != null) {
                    this.subQuerySize = (Integer)r.get("SUB_QUERY_SIZE");
                    this.handleSubQuery(id);
                    continue;
                }
                Boolean executeOnce = (Boolean)r.get("EXECUTE_ONCE");
                boolean shouldGenerateReport = true;
                if (executeOnce != null && executeOnce == Boolean.TRUE) {
                    shouldGenerateReport = !SQLServerUtils.isReportExecuted(this.serverID, this.queryID);
                }
                if (shouldGenerateReport) {
                    this.displayResults();
                    SQLServerUtils.updateReportsDetails("IS_EXECUTED", true, this.serverID, this.queryID);
                }
                this.ansTable.clear();
                this.columns = null;
            }
            this.databases.clear();
            this.tables.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

