/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.reports;

import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.reports.SQLServerReportsQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLServerReportsHandler {
    private static final Logger LOGGER = Logger.getLogger(SQLServerReportsHandler.class.getName());
    private static ConcurrentQueue<Long> queue = null;
    private static SQLServerReportsHandler instance = null;
    private static final int MAX_QUEUE_SIZE = 1000;

    public SQLServerReportsHandler() {
        queue = new CommonQueueImpl<Long>(new LinkedBlockingDeque());
        SQLServerReportsQueue processor = new SQLServerReportsQueue(queue);
        processor.start();
    }

    public static SQLServerReportsHandler getInstance() {
        if (instance == null) {
            instance = new SQLServerReportsHandler();
        }
        return instance;
    }

    public void add(Long serverid) {
        try {
            if (queue.size() < 1000) {
                if (!queue.contains(serverid)) {
                    queue.add(serverid);
                }
            } else {
                LOGGER.log(Level.SEVERE, "SQLReports -> Reports cannot be generated for serverid {0} as queue is full ", serverid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

