/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.application.others.ApplicationMgmtUtils;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.DelegationUtil;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.device.DeviceProperties;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.management.AddOrUpdateEventlogDevice;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.query.SQLServerQueryHandler;
import com.zoho.za.ela.api.handlers.appmgmt.sqlserver.utils.SQLServerProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class SQLServerUtils {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static SQLServerProperties instanceProps = null;

    public static String getRandomString() {
        return "ME_LOG360" + UUID.randomUUID().toString();
    }

    public static boolean getPropertiesAndVerifyConnection(JSONObject req) {
        try {
            SQLServerProperties prop = new SQLServerProperties(req.getString("HOST_NAME"), req.getInt("PORT"), req.getInt("AUTHENTICATION"), req.getString("USERNAME"), req.getString("PASSWORD"), req.optString("INSTANCE_NAME"), req.optBoolean("IS_AUDITING_ENABLED"), req.getString("DOMAIN"));
            SQLServerQueryHandler handler = new SQLServerQueryHandler(prop);
            return handler.verifyConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDevicePresentAsSQLServer(List<String> device, Long[] deviceIDs) {
        try {
            Criteria crit = null;
            String tableName = null;
            if (device != null) {
                crit = new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"HOST_NAME"), (Object)device.toArray(new String[device.size()]), 8);
                tableName = "SQLServerDetails";
            } else {
                crit = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)deviceIDs, 8);
                crit = crit.and(new Criteria(Column.getColumn((String)"AppResources", (String)"FORMATID"), (Object)Long.valueOf(ApplicationMgmtUtils.getMssqlFormatId()), 0));
                tableName = "AppResources";
            }
            return DBUtil.getCountLong(tableName, crit) != 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getInstanceName(SQLServerProperties prop) {
        String instanceName = null;
        try {
            SQLServerQueryHandler handler = new SQLServerQueryHandler(prop);
            String query = "SELECT @@SERVICENAME;";
            instanceName = handler.executeQueryWithMultipleResults(null, query).get(0).get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instanceName;
    }

    public static JSONArray getInstanceDetailsForIDS(Long[] instanceIDs) {
        JSONArray ret = new JSONArray();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDiscoveredInstances"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDiscoveredInstances", (String)"*"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"SQLServerDiscoveredInstances", (String)"INSTANCE_ID"), (Object)instanceIDs, 8));
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDiscoveredInstances");
            while (it.hasNext()) {
                JSONObject curr = new JSONObject();
                Row r = (Row)it.next();
                curr.put("HOST_NAME", (Object)((String)r.get("HOST_NAME")));
                curr.put("PORT", ((Integer)r.get("PORT")).intValue());
                curr.put("INSTANCE_NAME", (Object)((String)r.get("INSTANCE_NAME")));
                ret.put((Object)curr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean checkDuplicate(Long appID, int port) {
        try {
            String sqlTable = "SQLServerDetails";
            SelectQueryImpl dup = new SelectQueryImpl(Table.getTable((String)sqlTable));
            dup.addSelectColumn(Column.getColumn((String)sqlTable, (String)"*"));
            Criteria dupCrit = new Criteria(Column.getColumn((String)sqlTable, (String)"APPID"), (Object)appID, 0);
            Criteria dupCrit1 = new Criteria(Column.getColumn((String)sqlTable, (String)"PORT"), (Object)port, 0);
            Criteria dupCrit2 = dupCrit.and(dupCrit1);
            dup.setCriteria(dupCrit2);
            DataObject dupObj = PERSISTENCELITE.get((SelectQuery)dup);
            if (!dupObj.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static BaseStatusCode changeMonitoringStatus(String table, String pkColumn, String column, List<Long> pKeys, boolean value) {
        BaseStatusCode bs = null;
        try {
            DataBaseReqestProcessor.executeUpdateQuery(table, column, value, new Criteria(Column.getColumn((String)table, (String)pkColumn), (Object)pKeys.toArray(new Long[pKeys.size()]), 8), true);
            bs = BaseStatusCode.getBaseStatusCode(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            bs = BaseStatusCode.getBaseStatusCode(7430);
        }
        return bs;
    }

    public static JSONObject getDetailsOfAnInstance(JSONObject json) {
        JSONObject res = new JSONObject();
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
        Column c = Column.getColumn((String)"SQLServerDetails", (String)"*");
        Column c1 = Column.getColumn((String)"ELACredentials", (String)"*");
        Column c2 = Column.getColumn((String)"AppResources", (String)"*");
        sq.addSelectColumn(c);
        sq.addSelectColumn(c1);
        sq.addSelectColumn(c2);
        sq.addJoin(new Join("SQLServerDetails", "ELACredentials", new String[]{"CREDENTIAL_ID"}, new String[]{"CREDENTIAL_ID"}, 1));
        sq.addJoin(new Join("SQLServerDetails", "AppResources", new String[]{"APPID"}, new String[]{"APPID"}, 1));
        try {
            boolean isRequestFromClient = json.optBoolean("REQUEST_FROM_CLIENT", false);
            long instanceID = json.getLong("INSTANCE_ID");
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"SERVER_ID"), (Object)instanceID, 0);
            sq.setCriteria(crit);
            DataObject dobj = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dobj.getRows("SQLServerDetails");
            Iterator it1 = dobj.getRows("ELACredentials");
            Iterator it2 = dobj.getRows("AppResources");
            String host = null;
            String username = null;
            String password = null;
            String domain = null;
            int auth = -1;
            int port = -1;
            instanceProps = new SQLServerProperties();
            if (it.hasNext()) {
                Row row = (Row)it.next();
                Row crow = (Row)it1.next();
                Row hrow = (Row)it2.next();
                username = (String)crow.get("USERNAME");
                res.put("USERNAME", (Object)username);
                instanceProps.setUsername(username);
                if (!isRequestFromClient) {
                    password = (String)crow.get("PASSWORD");
                    res.put("PASSWORD", (Object)password);
                    instanceProps.setPassword(password);
                }
                domain = (String)crow.get("DOMAIN_NAME");
                res.put("DOMAIN_NAME", (Object)domain);
                instanceProps.setDomain(domain);
                port = (Integer)row.get("PORT");
                res.put("PORT", port);
                instanceProps.setPort(port);
                auth = (Integer)row.get("AUTHENTICATION");
                res.put("AUTHENTICATION", auth);
                instanceProps.setAuth(auth);
                host = (String)row.get("HOST_NAME");
                res.put("HOSTNAME", (Object)host);
                instanceProps.setHostname(host);
                res.put("HOSTID", (Object)((Long)hrow.get("HOSTID")));
                res.put("APPID", ((Long)row.get("APPID")).longValue());
                res.put("INSTANCE_NAME", (Object)((String)row.get("INSTANCE_NAME")));
                res.put("CREDENTIALID", ((Long)row.get("CREDENTIAL_ID")).longValue());
                res.put("ISAUDITINGENABLED", ((Boolean)row.get("IS_AUDITING_ENABLED")).booleanValue());
                res.put("SERVER_STATUS", ((Integer)row.get("SERVER_STATUS")).intValue());
                res.put("IS_POLICY_CREATED", SQLServerUtils.isPolicyCreated(json));
            }
            res.put("SERVER_ID", instanceID);
            res.put("URL", (Object)SQLServerQueryHandler.resolveURL(instanceProps));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static SQLServerProperties getDetailsAsProperties(long instanceID) {
        JSONObject json = new JSONObject();
        try {
            json.put("INSTANCE_ID", instanceID);
            SQLServerUtils.getDetailsOfAnInstance(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instanceProps;
    }

    public static Object getName(String tableName, String columnName, String primaryKeyColumn, long primaryKey) {
        Object ans = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)primaryKeyColumn), (Object)primaryKey, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows(tableName);
            if (!dob.isEmpty()) {
                Row r = (Row)it.next();
                ans = r.get(columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ans;
    }

    public static JSONObject getAllDatabases(JSONObject sqlConfig) {
        JSONObject res = new JSONObject();
        try {
            long serverid = sqlConfig.getLong("SERVER_ID");
            JSONArray dbDetails = SQLServerUtils.getDatabases(serverid);
            JSONArray options = new JSONArray();
            res.put("value", 0);
            res.put("title", (Object)"Nothing Selected");
            res.put("class", (Object)"hidden");
            options.put((Object)res);
            for (int i = 0; i < dbDetails.length(); ++i) {
                JSONObject r = dbDetails.getJSONObject(i);
                long databaseID = r.getLong("DATABASE_ID");
                String databaseName = r.getString("DATABASE_NAME");
                res = new JSONObject();
                res.put("value", databaseID);
                res.put("title", (Object)databaseName);
                options.put((Object)res);
            }
            JSONArray response = new JSONArray();
            res = new JSONObject();
            res.put("group", (Object)"listOfDatabases");
            response.put((Object)res);
            res = new JSONObject();
            res.put("option", (Object)options);
            response.put((Object)res);
            res = new JSONObject();
            res.put("result", (Object)response);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public static JSONObject getAllTables(JSONObject sqlConfig) {
        JSONObject res = new JSONObject();
        try {
            long databaseid = sqlConfig.getLong("DATABASE_ID");
            JSONArray tableDetails = SQLServerUtils.getTables(databaseid);
            JSONArray options = new JSONArray();
            res.put("value", 0);
            res.put("title", (Object)"Nothing Selected");
            res.put("class", (Object)"hidden");
            options.put((Object)res);
            for (int i = 0; i < tableDetails.length(); ++i) {
                JSONObject r = tableDetails.getJSONObject(i);
                long tableID = r.getLong("TABLE_ID");
                String tableName = r.getString("TABLE_NAME");
                res = new JSONObject();
                res.put("value", tableID);
                res.put("title", (Object)tableName);
                options.put((Object)res);
            }
            JSONArray response = new JSONArray();
            res = new JSONObject();
            res.put("group", (Object)"listOfTables");
            response.put((Object)res);
            res = new JSONObject();
            res.put("option", (Object)options);
            response.put((Object)res);
            res = new JSONObject();
            res.put("result", (Object)response);
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public static JSONObject getAllColumns(JSONObject sqlConfig) {
        JSONObject ret = new JSONObject();
        String selected = null;
        boolean seen = false;
        try {
            String req;
            JSONObject details = SQLServerUtils.getDetailsOfAnInstance(sqlConfig);
            int auth = details.getInt("AUTHENTICATION");
            String username = details.getString("USERNAME");
            String password = details.getString("PASSWORD");
            long databaseID = sqlConfig.getLong("DATABASE_ID");
            String database = (String)SQLServerUtils.getName("SQLServerDatabases", "DATABASE_NAME", "DATABASE_ID", databaseID);
            long tableID = sqlConfig.getLong("TABLE_ID");
            String table = (String)SQLServerUtils.getName("SQLServerTables", "TABLE_NAME", "TABLE_ID", tableID);
            String url = details.getString("URL");
            SQLServerQueryHandler reportHandler = new SQLServerQueryHandler(auth, username, password, url);
            String query = req = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='[$TABLE]';".replace("[$TABLE]", table.replace("'", "''"));
            List<List<String>> cols = reportHandler.executeQueryWithMultipleResults(database, query);
            sqlConfig.put("DATABASE_NAME", (Object)database);
            sqlConfig.put("TABLE_NAME", (Object)table);
            JSONArray options = new JSONArray();
            JSONObject temp = new JSONObject();
            temp.put("value", 0);
            temp.put("title", (Object)"Nothing Selected");
            temp.put("class", (Object)"hidden");
            options.put((Object)temp);
            for (int i = 0; i < cols.size(); ++i) {
                temp = new JSONObject();
                String currColumn = cols.get(i).get(0);
                temp.put("value", (Object)currColumn);
                temp.put("title", (Object)currColumn);
                sqlConfig.put("COLUMN_NAME", (Object)currColumn);
                temp.put("icon", (Object)"ela-icon icn-checkbox");
                if (SQLServerUtils.checkIfColumnAdded(sqlConfig)) {
                    temp.put("disabled", true);
                } else if (!seen) {
                    selected = currColumn;
                    seen = true;
                }
                options.put((Object)temp);
            }
            JSONArray response = new JSONArray();
            temp = new JSONObject();
            temp.put("group", (Object)"columnsInTable");
            response.put((Object)temp);
            temp = new JSONObject();
            temp.put("option", (Object)options);
            response.put((Object)temp);
            temp = new JSONObject();
            temp.put("result", (Object)response);
            if (seen) {
                temp.put("selected", (Object)selected);
            }
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public static JSONObject getServersWithCount(Long[] serverids) {
        JSONObject ret = null;
        JSONArray res = new JSONArray();
        Long req = new Long(0L);
        HashMap<Long, Boolean> processed = new HashMap<Long, Boolean>();
        HashMap<Long, Long> appIdHostId = new HashMap<Long, Long>();
        try {
            int count = 0;
            String prevHost = null;
            JSONArray instances = null;
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDetails", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
            sq.addJoin(new Join("SQLServerDetails", "AppResources", new String[]{"APPID"}, new String[]{"APPID"}, 1));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerDetails", (String)"SERVER_ID"), (Object)serverids, 8);
            sq.setCriteria(crit);
            SortColumn sc = new SortColumn("AppResources", "HOSTID", true);
            sq.addSortColumn(sc);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDetails");
            Iterator it1 = dob.getRows("AppResources");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long appID = (Long)r.get("APPID");
                Long host_id = null;
                String host_name = (String)r.get("HOST_NAME");
                Row r1 = null;
                if (appIdHostId.get(appID) != null) {
                    host_id = (Long)appIdHostId.get(appID);
                } else {
                    r1 = (Row)it1.next();
                    host_id = (Long)r1.get("HOSTID");
                    appIdHostId.put(appID, host_id);
                }
                if (!processed.containsKey(host_id)) {
                    if (instances != null && ret != null) {
                        ret.put("TOOLTIP", instances);
                        ret.put("NAME", prevHost);
                        ret.put("BYLINE", true);
                        ret.put("BYLINE_TEXT", (Object)("INSTANCES - " + count));
                        res.put((Object)ret);
                    }
                    ret = new JSONObject();
                    instances = new JSONArray();
                    ret.put("ID", (Object)host_id);
                    ret.put("ICON_CLASS", (Object)"icn-tick-10");
                    ret.put("ICON_DISPLAY", DeviceUtil.getDeviceStatus(host_id).longValue() == req.longValue());
                    processed.put(host_id, true);
                    count = 0;
                    prevHost = host_name;
                }
                ++count;
                instances.put((Object)((String)r.get("INSTANCE_NAME")));
                if (it.hasNext()) continue;
                ret.put("TOOLTIP", (Object)instances);
                ret.put("NAME", (Object)host_name);
                ret.put("BYLINE", true);
                ret.put("BYLINE_TEXT", (Object)("INSTANCES - " + count));
                res.put((Object)ret);
            }
            ret = new JSONObject();
            ret.put("LIST", (Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static DataObject checkIfLastTimeInserted(Long serverid) {
        DataObject dob = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerReportsDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerReportsDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerReportsDetails", (String)"SERVER_ID"), (Object)serverid, 0);
            sq.setCriteria(crit);
            dob = PERSISTENCELITE.get((SelectQuery)sq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dob;
    }

    public static void insertLastReportTimeForCurrentInstance(Long serverid) {
        boolean isInserted;
        DataObject isIns = SQLServerUtils.checkIfLastTimeInserted(serverid);
        boolean bl = isInserted = isIns != null && !isIns.isEmpty();
        if (isInserted) {
            return;
        }
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerQueries"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerQueries", (String)"*"));
            SortColumn sc = new SortColumn("SQLServerQueries", "ID", true);
            sq.addSortColumn(sc);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            if (!dob.isEmpty()) {
                int count = 0;
                Iterator it = dob.getRows("SQLServerQueries");
                DataObject dob1 = PERSISTENCELITE.constructDataObject();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Row r1 = new Row("SQLServerReportsDetails");
                    r1.set("SERVER_ID", (Object)serverid);
                    r1.set("QUERY_ID", (Object)((Long)r.get("ID")));
                    if (++count == 2) {
                        r1.set("LAST_REPORT_TIME", (Object)"1900/01/01 00:00:00:000");
                    } else {
                        r1.set("LAST_REPORT_TIME", (Object)"1800-01-01 00:00:00.000");
                    }
                    r1.set("IS_EXECUTED", (Object)false);
                    dob1.addRow(r1);
                }
                PERSISTENCELITE.add(dob1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<Long, String> getLastReportTimeForInstance(long serverid) {
        HashMap<Long, String> ret = new HashMap<Long, String>();
        try {
            DataObject dob = SQLServerUtils.checkIfLastTimeInserted(serverid);
            Iterator it = dob.getRows("SQLServerReportsDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long queryid = (Long)r.get("QUERY_ID");
                String time = (String)r.get("LAST_REPORT_TIME");
                ret.put(queryid, time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean isReportExecuted(long serverid, long queryid) {
        boolean isExecuted = false;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerReportsDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerReportsDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerReportsDetails", (String)"SERVER_ID"), (Object)serverid, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerReportsDetails", (String)"QUERY_ID"), (Object)queryid, 0);
            Criteria baseCrit = crit.and(crit1);
            sq.setCriteria(baseCrit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerReportsDetails");
            if (!dob.isEmpty()) {
                Row r = (Row)it.next();
                isExecuted = (Boolean)r.get("IS_EXECUTED");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isExecuted;
    }

    public static void updateReportsDetails(String columnName, Object columnValue, long serverid, long queryid) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerReportsDetails", (String)"SERVER_ID"), (Object)serverid, 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerReportsDetails", (String)"QUERY_ID"), (Object)queryid, 0);
            DataBaseReqestProcessor.executeUpdateQuery("SQLServerReportsDetails", columnName, columnValue, crit.and(crit1), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getDatabases(long serverid) {
        JSONArray dbDetails = new JSONArray();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDatabases"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDatabases", (String)"*"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"SQLServerDatabases", (String)"SERVER_ID"), (Object)serverid, 0));
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDatabases");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject temp = new JSONObject();
                temp.put("DATABASE_ID", ((Long)r.get("DATABASE_ID")).longValue());
                temp.put("DATABASE_NAME", (Object)((String)r.get("DATABASE_NAME")));
                dbDetails.put((Object)temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbDetails;
    }

    public static JSONArray getTables(long databaseID) {
        JSONArray tableDetails = new JSONArray();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerTables"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerTables", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"SQLServerTables", (String)"TABLE_NAME"), true));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerTables", (String)"DATABASE_ID"), (Object)databaseID, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerTables");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject temp = new JSONObject();
                temp.put("TABLE_ID", ((Long)r.get("TABLE_ID")).longValue());
                temp.put("TABLE_NAME", (Object)((String)r.get("TABLE_NAME")));
                tableDetails.put((Object)temp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableDetails;
    }

    public static boolean isPolicyCreated(JSONObject sqlConfig) {
        boolean isCreated = true;
        try {
            long serverid = sqlConfig.getLong("INSTANCE_ID");
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerAuditingDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerAuditingDetails", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerAuditingDetails", (String)"INSTANCE_ID"), (Object)serverid, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            if (dob.isEmpty()) {
                isCreated = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            isCreated = false;
        }
        return isCreated;
    }

    public static Map<Integer, List<String>> getAllInstances() {
        HashMap<Integer, List<String>> instanceList = new HashMap<Integer, List<String>>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDetails", (String)"*"));
            DataObject dob = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Integer port = (Integer)r.get("PORT");
                if (instanceList.get(port) == null) {
                    ArrayList<String> tempList = new ArrayList<String>();
                    tempList.add(((String)r.get("HOST_NAME")).toLowerCase());
                    instanceList.put(port, tempList);
                    continue;
                }
                ((List)instanceList.get(port)).add(((String)r.get("HOST_NAME")).toLowerCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instanceList;
    }

    public static boolean checkIfColumnAdded(JSONObject json) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerColumns"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerColumns", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"SERVER_ID"), (Object)json.getLong("INSTANCE_ID"), 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"DATABASE_NAME"), (Object)json.getString("DATABASE_NAME"), 0);
            Criteria crit2 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"TABLE_NAME"), (Object)json.getString("TABLE_NAME"), 0);
            Criteria crit3 = new Criteria(Column.getColumn((String)"SQLServerColumns", (String)"COLUMN_NAME"), (Object)json.getString("COLUMN_NAME"), 0);
            Criteria baseCrit = crit.and(crit1).and(crit2).and(crit3);
            sq.setCriteria(baseCrit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            return !dob.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static JSONObject getDomainWorkgroupDetails(JSONObject reqJson) {
        JSONObject details = new JSONObject();
        try {
            String hostName = reqJson.getString("DEVICE_NAME");
            details = DeviceUtil.isDeviceDiscovered(reqJson);
            ArrayList<Long> hostids = DeviceUtil.getDeviceIdList(hostName);
            Long hostid = null;
            if (!hostids.isEmpty()) {
                hostid = (Long)hostids.get(0);
            }
            ArrayList<String> deviceColumns = new ArrayList<String>();
            ArrayList<String> deviceDetailsColumns = new ArrayList<String>();
            deviceDetailsColumns.add("USERNAME");
            if (hostid != null) {
                DataObject dob = DeviceUtil.getDeviceDetailsDO(hostid, deviceColumns, deviceDetailsColumns);
                Iterator it = dob.getRows("HostDetails");
                if (!dob.isEmpty()) {
                    Row r = (Row)it.next();
                    String username = (String)r.get("USERNAME");
                    details.put("IS_ADDED", true);
                    if (username != null) {
                        details.put("USERNAME", (Object)username);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return details;
    }

    public static boolean setDevicePropertiesAndAddDevice(JSONObject discoveryRequest, UserAccessResource accessControl) {
        try {
            String deviceName = discoveryRequest.getString("DEVICE_NAME");
            Long domainID = discoveryRequest.isNull("DOMAIN_ID") ? null : Long.valueOf(discoveryRequest.getLong("DOMAIN_ID"));
            Long workgroupID = discoveryRequest.isNull("WORKGROUP_ID") ? null : Long.valueOf(discoveryRequest.getLong("WORKGROUP_ID"));
            DeviceProperties properties = new DeviceProperties(deviceName);
            properties.setDeviceDisplayName(deviceName);
            properties.setDeviceDns_name(deviceName);
            properties.setUserID(accessControl.getUserID());
            properties.setSSLEnabled(false);
            properties.setDeviceCategory(LogSourceCategoryContainer.DeviceCategory.WINDOWS);
            properties.setDeviceStatus(LogCollectionStatus.getStatus(1));
            properties.setDeviceCredential(null);
            long groupID = DelegationUtil.getGroupID(LogSourceCategoryContainer.DeviceCategory.WINDOWS, accessControl);
            properties.setDeviceGroup(groupID);
            properties.setLogCollectorID(ServerDetailsBean.getInstance().getSysEvtColID());
            properties.setSyncedDevice(false);
            if (domainID != null) {
                properties.setDeviceDomainID(domainID);
            }
            if (workgroupID != null) {
                properties.setDeviceWorkgroupID(workgroupID);
            }
            properties.setDeviceSourceId(3);
            properties.setDeviceAddress(deviceName);
            properties.setDeviceFQDN(deviceName);
            return AddOrUpdateEventlogDevice.addNewEventlogDevice(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAdvancedAuditingReport(String criteria) {
        try {
            criteria = criteria.replace("REPORTNAME:", "").replace("(", "").replace(")", "");
            if (criteria.equalsIgnoreCase("COLCHANGED")) {
                return true;
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerQueries"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerQueries", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SQLServerQueries", (String)"REPORTNAME"), (Object)criteria, 0);
            sq.setCriteria(crit);
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            return !dob.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static List<Long> getAllInstanceIDs() {
        ArrayList<Long> instanceIDs = new ArrayList<Long>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SQLServerDetails"));
            sq.addSelectColumn(Column.getColumn((String)"SQLServerDetails", (String)"*"));
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            Iterator it = dob.getRows("SQLServerDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                instanceIDs.add((Long)r.get("SERVER_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instanceIDs;
    }

    public static Map<String, List<Long>> splitSQLServersFromNormalDevices(Long[] deviceIDs) {
        HashMap<String, List<Long>> res = new HashMap<String, List<Long>>();
        ArrayList<Long> deviceIDList = new ArrayList<Long>();
        deviceIDList.addAll(Arrays.asList(deviceIDs));
        ArrayList<Long> appHostList = new ArrayList<Long>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            sq.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"AppResources", (String)"FORMATID"), (Object)ApplicationMgmtUtils.getMssqlFormatId(), 0);
            Criteria crit1 = new Criteria(Column.getColumn((String)"AppResources", (String)"HOSTID"), (Object)deviceIDs, 8);
            sq.setCriteria(crit.and(crit1));
            DataObject dob = PERSISTENCELITE.get((SelectQuery)sq);
            if (dob.isEmpty()) {
                res.put("device", deviceIDList);
                return res;
            }
            Iterator it1 = dob.getRows("AppResources");
            Long appHostID = null;
            while (it1.hasNext()) {
                Row r1 = (Row)it1.next();
                appHostID = (Long)r1.get("HOSTID");
                appHostList.add(appHostID);
                deviceIDList.remove(appHostID);
            }
            res.put("device", deviceIDList);
            res.put("apps", appHostList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }
}

