/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.za.ela.security;

import com.zoho.za.ela.security.SecurityManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecurityFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(SecurityFilter.class.getName());
    private static String[] keyWords = new String[]{";", "/*", "*/", "--", "exec", "select ", "update ", "delete ", "insert ", "alter ", "drop ", "create ", "shutdown "};
    private static String[] urlKeys = new String[]{"graphDetailsReport"};

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest originalRequest = (HttpServletRequest)req;
        HttpServletResponse res = (HttpServletResponse)resp;
        SecurityManager.getInstance();
        SecurityManager.setHeader(res);
        if (originalRequest.getParameter("url") != null) {
            if (Arrays.asList(urlKeys).contains(originalRequest.getParameter("url"))) {
                if (SecurityFilter.isUnsafe(originalRequest.getParameterMap())) {
                    LOGGER.log(Level.INFO, "Security Vulnerability Attack Found in url " + req.getParameter("url"));
                } else {
                    filterChain.doFilter(req, resp);
                }
            } else {
                filterChain.doFilter(req, resp);
            }
        } else if (originalRequest.getParameter("srchHost") != null) {
            if (SecurityFilter.isUnsafe(originalRequest.getParameterMap())) {
                LOGGER.log(Level.INFO, "Security Vulnerability Attack Found in url " + req.getParameter("url"));
            } else {
                filterChain.doFilter(req, resp);
            }
        } else {
            filterChain.doFilter(req, resp);
        }
    }

    public static boolean checkXSS(String value) {
        boolean result = false;
        String cleanValue = "";
        if (value != null) {
            cleanValue = value.replaceAll("\u0000", "");
            Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : <script>(.*?)</script>");
                return true;
            }
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : src[\r\n]*=[\r\n]*\\'(.*?)\\'");
                return true;
            }
            scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : src[\r\n]*=[\r\n]*\\\"(.*?)\\\"");
                return true;
            }
            scriptPattern = Pattern.compile("</script>", 2);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : </script>");
                return true;
            }
            scriptPattern = Pattern.compile("<script(.*?)>", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : <script(.*?)>");
                return true;
            }
            scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : eval\\((.*?)\\)");
                return true;
            }
            scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : expression\\((.*?)\\)");
                return true;
            }
            scriptPattern = Pattern.compile("prompt\\((.*?)\\)", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : prompt\\((.*?)\\)");
                return true;
            }
            scriptPattern = Pattern.compile("alert\\((.*?)\\)", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : alert\\((.*?)\\)");
                return true;
            }
            scriptPattern = Pattern.compile("javascript:", 2);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : javascript:");
                return true;
            }
            scriptPattern = Pattern.compile("vbscript:", 2);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : vbscript:");
                return true;
            }
            scriptPattern = Pattern.compile("onload(.*?)=", 42);
            if (scriptPattern.matcher(cleanValue).find()) {
                LOGGER.log(Level.INFO, "Security Vulnerability Param Matches : onload(.*?)=");
                return true;
            }
        }
        return result;
    }

    public void destroy() {
    }

    static boolean isUnsafe(Map<?, ?> parameterMap) {
        Iterator<?> iter = parameterMap.keySet().iterator();
        String[] param = null;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            param = (String[])parameterMap.get(key);
            for (int i = 0; i < param.length; ++i) {
                if (key.contains("_desc") || key.equalsIgnoreCase("AddSubmit") || key.equalsIgnoreCase("B21")) {
                    param[i] = param[i].replaceAll(";", "");
                }
                if (!SecurityFilter.isUnsafe(param[i])) continue;
                LOGGER.log(Level.INFO, "Security Vulnerability Param : " + key);
                LOGGER.log(Level.INFO, "Security Vulnerability Param value : " + param[i]);
                return true;
            }
        }
        return false;
    }

    static boolean isUnsafe(String value) {
        String lowerCase = value.toLowerCase();
        for (int i = 0; i < keyWords.length; ++i) {
            if (lowerCase.indexOf(keyWords[i]) < 0) continue;
            LOGGER.log(Level.INFO, "Security Vulnerability Param Contains : " + keyWords[i]);
            return true;
        }
        return false;
    }
}

