/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.conf.tree;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;

public class ConfNode
implements Iterable<ConfNode>,
Comparable<ConfNode> {
    private String prefix;
    private String value;
    private boolean isRoot;
    private boolean isSubTree;
    private ConfNode defaultNode;
    private Map<String, ConfNode> children = new TreeMap<String, ConfNode>(String.CASE_INSENSITIVE_ORDER);
    String prettySpace = "";

    ConfNode() {
    }

    ConfNode(boolean isRoot) {
        this.setRoot(isRoot);
    }

    void put(Queue<String> keyPath, String value) {
        if (keyPath == null || keyPath.isEmpty()) {
            throw new IllegalArgumentException("Keypath cannot be null/empty.");
        }
        if (this.isRoot()) {
            if (!keyPath.peek().equals("*")) {
                this.addToChildNode(keyPath, value);
            } else {
                if (this.defaultNode == null) {
                    this.setDefaultNode(new ConfNode());
                }
                this.defaultNode.put(keyPath, value);
            }
        } else if (!this.isRoot() && this.getPrefix() == null) {
            if (keyPath.size() == 1) {
                this.setPrefix(keyPath.poll());
                this.setValue(value);
                return;
            }
            if (keyPath.size() > 1) {
                this.setPrefix(keyPath.poll());
                this.addChild(keyPath, value);
            }
        } else {
            String key = keyPath.peek();
            if (this.getPrefix().equalsIgnoreCase(key)) {
                keyPath.poll();
                if (keyPath.size() > 0) {
                    this.addToChildNode(keyPath, value);
                } else {
                    this.setValue(value);
                }
            } else {
                throw new IllegalArgumentException("Invalid child node with prefix " + keyPath + ". Prefix should be started with " + this.getPrefix());
            }
        }
    }

    void addToChildNode(Queue<String> keyPath, String value) {
        boolean isParentNodeFound = false;
        ConfNode confNode = this.children.get(keyPath.peek());
        if (confNode != null && keyPath.peek().equals(confNode.getPrefix())) {
            confNode.put(keyPath, value);
            isParentNodeFound = true;
        }
        if (!isParentNodeFound) {
            this.addChild(keyPath, value);
            return;
        }
    }

    void addChild(Queue<String> prefix, String value) {
        ConfNode child = new ConfNode();
        this.children.put(prefix.peek(), child);
        child.put(prefix, value);
    }

    String getValue(Queue<String> keyPath) {
        LinkedList<String> keyPathCopy = new LinkedList<String>();
        if (keyPath == null) {
            throw new IllegalArgumentException("Prefix cannot be null.");
        }
        if (this.getDefaultNode() != null) {
            keyPathCopy.addAll(keyPath);
        }
        if (this.isRoot()) {
            for (ConfNode confNode : this.getChildren()) {
                String val = confNode.getValue(keyPath);
                if (val == null) continue;
                return val;
            }
        } else {
            if (keyPath.size() == 1 && this.getPrefix().equalsIgnoreCase(keyPath.peek())) {
                return this.value;
            }
            if (this.getPrefix().equalsIgnoreCase(keyPath.peek()) || this.getPrefix().equals("*") || keyPath.peek().equals("*")) {
                keyPath.poll();
                for (ConfNode confNode : this.getChildren()) {
                    String val = confNode.getValue(keyPath);
                    if (val == null) continue;
                    return val;
                }
            }
        }
        if (this.getDefaultNode() != null) {
            return this.getDefaultNode().getValue(keyPathCopy);
        }
        return null;
    }

    void setValue(String value) {
        this.value = value;
    }

    String getPrefix() {
        return this.prefix;
    }

    void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    Collection<ConfNode> getChildren() {
        return this.children.values();
    }

    @Override
    public Iterator<ConfNode> iterator() {
        return this.children.values().iterator();
    }

    @Override
    public int compareTo(ConfNode node) {
        return this.prefix != null ? this.prefix.compareTo(node.getPrefix()) : 1;
    }

    boolean isRoot() {
        return this.isRoot;
    }

    private void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    String remove(Queue<String> keyPath) {
        LinkedList<String> keyPathCopy = new LinkedList<String>();
        if (keyPath == null) {
            throw new IllegalArgumentException("Prefix cannot be null.");
        }
        if (this.getDefaultNode() != null) {
            keyPathCopy.addAll(keyPath);
        }
        if (this.isRoot()) {
            for (ConfNode confNode : this.getChildren()) {
                String remove = confNode.remove(keyPath);
                if (remove == null) continue;
                if (confNode.getChildren().isEmpty() && confNode.value == null) {
                    this.children.remove(confNode.getPrefix());
                }
                return remove;
            }
        } else {
            if (keyPath.size() == 1 && this.getPrefix().equalsIgnoreCase(keyPath.peek())) {
                String value2 = this.getValue(keyPath);
                this.value = null;
                return value2;
            }
            if (this.getPrefix().equalsIgnoreCase(keyPath.peek()) || this.getPrefix().equals("*")) {
                String remove;
                keyPath.poll();
                ConfNode confNode = this.children.get(keyPath.peek());
                if (confNode != null && (remove = confNode.remove(keyPath)) != null) {
                    if (confNode.getChildren().isEmpty() && confNode.value == null) {
                        this.children.remove(confNode.getPrefix());
                    }
                    return remove;
                }
            }
        }
        if (this.getDefaultNode() != null) {
            return this.getDefaultNode().remove(keyPathCopy);
        }
        return null;
    }

    ConfNode getSubConfTreeNode(Queue<String> keyPath) {
        if (this.isRoot()) {
            for (ConfNode confNode : this.getChildren()) {
                ConfNode subConfTreeNode = confNode.getSubConfTreeNode(keyPath);
                if (subConfTreeNode == null) continue;
                return subConfTreeNode;
            }
        } else {
            if (keyPath.size() == 1 && this.getPrefix().equalsIgnoreCase(keyPath.peek())) {
                return this;
            }
            if (this.getPrefix().equalsIgnoreCase(keyPath.peek()) || this.getPrefix().equals("*")) {
                keyPath.poll();
                ConfNode confNode = this.children.get(keyPath.peek());
                if (confNode != null) {
                    return confNode.getSubConfTreeNode(keyPath);
                }
            }
        }
        return null;
    }

    ConfNode getDefaultNode() {
        return this.defaultNode;
    }

    void setDefaultNode(ConfNode defaultNode) {
        this.defaultNode = defaultNode;
    }

    public boolean isSubTreeRootNode() {
        return this.isSubTree;
    }

    public void setSubTreeRootNode(boolean isSubTree) {
        this.isSubTree = isSubTree;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.isRoot()) {
            buff.append("ROOT");
        } else {
            buff.append("-").append(this.getPrefix().equals("*") ? "DEFAULT" : this.getPrefix());
            if (this.value != null) {
                buff.append(" ---> ").append(this.value);
            }
        }
        int processed = 1;
        if (this.getDefaultNode() != null) {
            String space = this.prettySpace + "  |";
            buff.append("\n").append(space);
            this.defaultNode.prettySpace = space;
            buff.append(this.getDefaultNode().toString());
        }
        for (String key : this.children.keySet()) {
            ConfNode confNode = this.children.get(key);
            String space = this.prettySpace + "  |";
            buff.append("\n").append(space);
            if (processed == this.children.size()) {
                space = space.substring(0, space.length() - 2) + " ";
            }
            confNode.prettySpace = space;
            buff.append(confNode.toString());
            ++processed;
        }
        return buff.toString();
    }
}

