/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.conf.tree;

import com.zoho.conf.tree.ConfNode;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Logger;

public class ConfTree {
    ConfNode root;
    Set<String> keys = new TreeSet<String>();
    private static final Logger LOGGER = Logger.getLogger(ConfTree.class.getName());
    boolean isSubTree = false;
    boolean ignoreSubTreePrefix = false;

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    public String get(String key) {
        return this.get(key, this.ignoreSubTreePrefix);
    }

    private String get(String key, boolean ignoreRootNode) {
        String value;
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null.");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Key should be a instance of String");
        }
        if (this.isSubTree && ignoreRootNode) {
            key = "*." + key;
        }
        if ((value = this.root.getValue(this.splitKeyString(key))) == null && key.lastIndexOf(".") > 1 && !ignoreRootNode && (value = this.get(key.substring(key.lastIndexOf("."), key.length()), false)) != null) {
            LOGGER.fine("Returning .root value for key : " + key);
        }
        return value;
    }

    public String get(String key, String defaultValue) {
        String val = this.get(key);
        return val != null ? val : defaultValue;
    }

    public String put(String key, String value) {
        if (key == null && value == null) {
            throw new IllegalArgumentException("Key/value should not be null.K-" + key + ", V-" + value);
        }
        if (this.root == null) {
            this.root = new ConfNode(true);
        }
        if (key.startsWith(".")) {
            key = "*" + key;
        }
        Queue<String> splitKeyString = this.splitKeyString(key);
        this.root.put(splitKeyString, value);
        this.keys.add(key);
        return null;
    }

    private Queue<String> splitKeyString(String key) {
        StringTokenizer tokenizer = new StringTokenizer(key, ".", false);
        LinkedList<String> splittedKey = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            splittedKey.add(tokenizer.nextToken());
        }
        return splittedKey;
    }

    public String remove(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key value should not be null.");
        }
        return this.root == null ? null : this.root.remove(this.splitKeyString(key));
    }

    public void putAll(Map<? extends String, ? extends String> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    public void clear() {
        this.root = null;
    }

    public Set<String> keySet() {
        return this.keys;
    }

    public ConfTree getSubTree(String commonPrefix) {
        return this.getSubTree(commonPrefix, false);
    }

    public ConfTree getSubTree(String commonPrefix, boolean ignorePrefixValidation) {
        TreeSet<String> newKeys = new TreeSet<String>();
        for (String key : this.keys) {
            if (!key.toLowerCase(Locale.ENGLISH).startsWith(commonPrefix.toLowerCase(Locale.ENGLISH))) continue;
            if (ignorePrefixValidation) {
                newKeys.add(key.substring(commonPrefix.length() + 1));
                continue;
            }
            newKeys.add(key);
        }
        Queue<String> splitKeyString = this.splitKeyString(commonPrefix);
        LinkedList<String> keyPathCopy = new LinkedList<String>();
        if (this.root.getDefaultNode() != null) {
            keyPathCopy.addAll(splitKeyString);
        }
        ConfTree subTree = new ConfTree();
        subTree.isSubTree = Boolean.TRUE;
        subTree.ignoreSubTreePrefix = ignorePrefixValidation;
        subTree.keys.addAll(newKeys);
        subTree.root = this.root.getSubConfTreeNode(splitKeyString);
        if (this.root.getDefaultNode() != null && subTree.root != null) {
            subTree.root.setDefaultNode(this.root.getDefaultNode().getSubConfTreeNode(keyPathCopy));
            return subTree;
        }
        if (subTree.root == null) {
            if (this.root.getDefaultNode() == null) {
                return null;
            }
            subTree.root = this.root.getDefaultNode().getSubConfTreeNode(keyPathCopy);
            return subTree;
        }
        return subTree;
    }

    public String toString() {
        if (this.root != null) {
            this.root.prettySpace = "";
            return this.root.toString();
        }
        return "EMPTY TREE";
    }
}

