/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.dddiff;

import com.zoho.dddiff.AddedElement;
import com.zoho.dddiff.DataDictionaryDiff;
import com.zoho.dddiff.DeletedElement;
import com.zoho.dddiff.ModifiedElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DataDictionaryDiffGenerator {
    private static final Logger LOGGER = Logger.getLogger(DataDictionaryDiffGenerator.class.getName());
    private List<Element> oldDocuments = new ArrayList<Element>();
    private List<Element> newDocuments = new ArrayList<Element>();
    private List changes = new ArrayList();

    DataDictionaryDiffGenerator() {
    }

    private Element getElement(NodeList nodes, String elementName) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals(elementName)) continue;
            return element;
        }
        return null;
    }

    private Element getElementByName(NodeList nodes, String elementName, String name) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            NamedNodeMap attris;
            Attr nameattr;
            String Name;
            Element element;
            String tagName;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals(elementName) || !(Name = (nameattr = (Attr)(attris = element.getAttributes()).getNamedItem("name")).getValue()).equals(name)) continue;
            return element;
        }
        return null;
    }

    private String getTagValue(NodeList nodes, String tagName) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals(tagName)) continue;
            NodeList innerNodes = element.getChildNodes();
            for (int j = 0; j < innerNodes.getLength(); ++j) {
                Node innerNode = innerNodes.item(j);
                if (innerNode.getNodeType() != 3) continue;
                return ((Text)innerNode).getData();
            }
        }
        return null;
    }

    private List<String> getValues(NodeList nodes, String tagName) {
        ArrayList<String> Columns = new ArrayList<String>();
        block4: for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            switch (node.getNodeType()) {
                case 4: 
                case 7: {
                    continue block4;
                }
                case 1: {
                    Element element = (Element)node;
                    if (!element.getTagName().equals(tagName)) continue block4;
                    NodeList innernodes = element.getChildNodes();
                    for (int j = 0; j < innernodes.getLength(); ++j) {
                        Node innernode = innernodes.item(j);
                        if (innernode.getNodeType() != 3) continue;
                        Columns.add(((Text)innernode).getData());
                    }
                    continue block4;
                }
            }
        }
        return Columns;
    }

    private List<String> getNames(NodeList nodes, String tagName) {
        ArrayList<String> Names = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(tagName)) continue;
            NamedNodeMap attris = nodeElement.getAttributes();
            Attr nameattr = (Attr)attris.getNamedItem("name");
            String columnname = nameattr.getValue();
            Names.add(columnname);
        }
        return Names;
    }

    private Map getFKColumns(NodeList nodes) {
        HashMap<String, String> fkColumns = new HashMap<String, String>();
        block4: for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            switch (node.getNodeType()) {
                case 4: 
                case 7: {
                    continue block4;
                }
                case 1: {
                    Element nodeElement = (Element)node;
                    String tagName = nodeElement.getTagName();
                    if (!tagName.equals("fk-column")) continue block4;
                    NodeList nodelist = nodeElement.getChildNodes();
                    String localcol = null;
                    String refcol = null;
                    for (int i = 0; i < nodelist.getLength(); ++i) {
                        Node innernode;
                        int k;
                        NodeList innernodes;
                        Node nod = nodelist.item(i);
                        if (nod.getNodeType() != 1) continue;
                        Element element = (Element)nod;
                        if (element.getTagName().equals("fk-local-column")) {
                            innernodes = element.getChildNodes();
                            for (k = 0; k < innernodes.getLength(); ++k) {
                                innernode = innernodes.item(k);
                                if (innernode.getNodeType() != 3) continue;
                                localcol = ((Text)innernode).getData();
                            }
                            continue;
                        }
                        if (!element.getTagName().equals("fk-reference-column")) continue;
                        innernodes = element.getChildNodes();
                        for (k = 0; k < innernodes.getLength(); ++k) {
                            innernode = innernodes.item(k);
                            if (innernode.getNodeType() != 3) continue;
                            refcol = ((Text)innernode).getData();
                        }
                    }
                    fkColumns.put(localcol, refcol);
                }
            }
        }
        return fkColumns;
    }

    private Element getTableElement(List<Element> elements, String tableName) {
        for (Element ele : elements) {
            NodeList nodes = ele.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                NamedNodeMap attris;
                Attr nameattr;
                String Name;
                Element element;
                String tagName;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(tagName = (element = (Element)node).getTagName()).equals("table") || !(Name = (nameattr = (Attr)(attris = element.getAttributes()).getNamedItem("name")).getValue()).equals(tableName)) continue;
                return element;
            }
        }
        return null;
    }

    private Element getDDElement(List<Element> elements, String ddName) {
        for (Element ele : elements) {
            if (!ele.getAttribute("name").equals(ddName)) continue;
            return ele;
        }
        return null;
    }

    private void diffDDs() {
        String ddName;
        Element tableElement;
        List<String> names;
        ArrayList<String> oldDDNames = new ArrayList<String>();
        ArrayList<String> newDDNames = new ArrayList<String>();
        ArrayList<String> oldTableNames = new ArrayList<String>();
        ArrayList<String> newTableNames = new ArrayList<String>();
        for (Element ele : this.oldDocuments) {
            oldDDNames.add(ele.getAttribute("name"));
            names = this.getNames(ele.getChildNodes(), "table");
            oldTableNames.addAll(names);
        }
        for (Element ele : this.newDocuments) {
            newDDNames.add(ele.getAttribute("name"));
            names = this.getNames(ele.getChildNodes(), "table");
            newTableNames.addAll(names);
        }
        for (String name : newDDNames) {
            if (oldDDNames.contains(name)) {
                Element oldDD = this.getDDElement(this.oldDocuments, name);
                Element newDD = this.getDDElement(this.newDocuments, name);
                ArrayList<String> ddChanges = new ArrayList<String>();
                String oldDDDesc = this.getTagValue(oldDD.getChildNodes(), "description");
                String newDDDesc = this.getTagValue(newDD.getChildNodes(), "description");
                if (oldDDDesc == null ? newDDDesc != null : !oldDDDesc.equals(newDDDesc)) {
                    ddChanges.add("description");
                }
                String oldHandler = oldDD.getAttribute("template-meta-handler");
                String newHandler = newDD.getAttribute("template-meta-handler");
                if (oldHandler == null ? newHandler != null : !oldHandler.equals(newHandler)) {
                    ddChanges.add("template-meta-handler");
                }
                if (ddChanges.isEmpty()) continue;
                ModifiedElement modify = new ModifiedElement(oldDD, newDD, null, name, DataDictionaryDiff.ElementType.DD, ddChanges);
                this.changes.add(modify);
                continue;
            }
            AddedElement add = new AddedElement(this.getDDElement(this.newDocuments, name), null, name, DataDictionaryDiff.ElementType.DD);
            this.changes.add(add);
        }
        for (String name : oldDDNames) {
            if (newDDNames.contains(name)) continue;
            DeletedElement drop = new DeletedElement(this.getDDElement(this.oldDocuments, name), null, name, DataDictionaryDiff.ElementType.DD);
            this.changes.add(drop);
        }
        for (String tableName : newTableNames) {
            if (!oldTableNames.contains(tableName)) {
                tableElement = this.getTableElement(this.newDocuments, tableName);
                ddName = ((Element)tableElement.getParentNode()).getAttribute("name");
                AddedElement add = new AddedElement(tableElement, tableName, ddName, DataDictionaryDiff.ElementType.TABLE);
                this.changes.add(add);
                continue;
            }
            Element oldTable = this.getTableElement(this.oldDocuments, tableName);
            Element newTable = this.getTableElement(this.newDocuments, tableName);
            this.diffTable(oldTable, newTable, tableName);
        }
        for (String tableName : oldTableNames) {
            if (newTableNames.contains(tableName)) continue;
            tableElement = this.getTableElement(this.oldDocuments, tableName);
            ddName = ((Element)tableElement.getParentNode()).getAttribute("name");
            DeletedElement drop = new DeletedElement(tableElement, tableName, ddName, DataDictionaryDiff.ElementType.TABLE);
            this.changes.add(drop);
        }
    }

    private void diffTable(Element oldtableElement, Element newtableElement, String tableName) {
        List<String> changedAttributes;
        String ddName = ((Element)newtableElement.getParentNode()).getAttribute("name");
        ArrayList<String> tableChanges = new ArrayList<String>();
        String oldTableDisplayName = oldtableElement.getAttribute("display-name");
        String newTableDisplayName = newtableElement.getAttribute("display-name");
        if (oldTableDisplayName == null ? newTableDisplayName != null : !oldTableDisplayName.equals(newTableDisplayName)) {
            tableChanges.add("display-name");
        }
        String oldTableSystem = oldtableElement.getAttribute("system");
        String newTableSystem = newtableElement.getAttribute("system");
        if (oldTableSystem == null ? newTableSystem != null : !oldTableSystem.equals(newTableSystem)) {
            tableChanges.add("system");
        }
        String oldTableCreatetable = oldtableElement.getAttribute("createtable");
        String newTableCreatetable = newtableElement.getAttribute("createtable");
        if (oldTableCreatetable == null ? newTableCreatetable != null : !oldTableCreatetable.equals(newTableCreatetable)) {
            tableChanges.add("createtable");
        }
        String oldTableTemplate = oldtableElement.getAttribute("template");
        String newTableTemplate = newtableElement.getAttribute("template");
        if (oldTableTemplate == null ? newTableTemplate != null : !oldTableTemplate.equals(newTableTemplate)) {
            tableChanges.add("template");
        }
        NodeList oldTablenodes = oldtableElement.getChildNodes();
        NodeList newTablenodes = newtableElement.getChildNodes();
        String oldTableDesc = this.getTagValue(oldTablenodes, "description");
        String newTableDesc = this.getTagValue(newTablenodes, "description");
        if (oldTableDesc == null ? newTableDesc != null : !oldTableDesc.equals(newTableDesc)) {
            tableChanges.add("description");
        }
        String oldDDName = ((Element)oldtableElement.getParentNode()).getAttribute("name");
        String newDDName = ((Element)newtableElement.getParentNode()).getAttribute("name");
        if (oldDDName == null ? newDDName != null : !oldDDName.equals(newDDName)) {
            tableChanges.add("ddName");
        }
        if (!tableChanges.isEmpty()) {
            ModifiedElement tableModify = new ModifiedElement(oldtableElement, newtableElement, tableName, ddName, DataDictionaryDiff.ElementType.TABLE, tableChanges);
            this.changes.add(tableModify);
        }
        Element oldColumnsElement = this.getElement(oldTablenodes, "columns");
        Element newColumnsElement = this.getElement(newTablenodes, "columns");
        List<String> oldColumnNames = this.getNames(oldColumnsElement.getChildNodes(), "column");
        List<String> newColumnNames = this.getNames(newColumnsElement.getChildNodes(), "column");
        for (String columnName : newColumnNames) {
            if (oldColumnNames.contains(columnName)) {
                Element newColumnElement;
                Element oldColumnElement = this.getElementByName(oldColumnsElement.getChildNodes(), "column", columnName);
                List<String> changedAttributes2 = this.diffColumn(oldColumnElement, newColumnElement = this.getElementByName(newColumnsElement.getChildNodes(), "column", columnName));
                if (changedAttributes2.isEmpty()) continue;
                ModifiedElement modify = new ModifiedElement(oldColumnElement, newColumnElement, tableName, ddName, DataDictionaryDiff.ElementType.COLUMN, changedAttributes2);
                this.changes.add(modify);
                continue;
            }
            AddedElement add = new AddedElement(this.getElementByName(newColumnsElement.getChildNodes(), "column", columnName), tableName, ddName, DataDictionaryDiff.ElementType.COLUMN);
            this.changes.add(add);
        }
        for (String columnName : oldColumnNames) {
            if (newColumnNames.contains(columnName)) continue;
            DeletedElement drop = new DeletedElement(this.getElementByName(oldColumnsElement.getChildNodes(), "column", columnName), tableName, ddName, DataDictionaryDiff.ElementType.COLUMN);
            this.changes.add(drop);
        }
        Element oldPK = this.getElement(oldTablenodes, "primary-key");
        Element newPK = this.getElement(newTablenodes, "primary-key");
        if (oldPK != null && newPK != null && !(changedAttributes = this.diffPK(oldPK, newPK)).isEmpty()) {
            ModifiedElement modify = new ModifiedElement(oldPK, newPK, tableName, ddName, DataDictionaryDiff.ElementType.PK, changedAttributes);
            this.changes.add(modify);
        }
        Element oldFKs = this.getElement(oldTablenodes, "foreign-keys");
        Element newFKs = this.getElement(newTablenodes, "foreign-keys");
        this.diffFKS(oldFKs, newFKs, tableName, ddName);
        Element oldUniquekeys = this.getElement(oldTablenodes, "unique-keys");
        Element newUniquekeys = this.getElement(newTablenodes, "unique-keys");
        this.diffUKS(oldUniquekeys, newUniquekeys, tableName, ddName);
        Element oldIndexes = this.getElement(oldTablenodes, "indexes");
        Element newIndexes = this.getElement(newTablenodes, "indexes");
        this.diffIDXES(oldIndexes, newIndexes, tableName, ddName);
    }

    private List<String> diffColumn(Element oldColumnElement, Element newColumnElement) {
        boolean isChanged;
        boolean isChanged2;
        String newColumnDataType;
        String oldColumnDataType;
        ArrayList<String> attributes = new ArrayList<String>();
        String oldColumnDisplayName = oldColumnElement.getAttribute("display-name");
        String newColumnDisplayName = newColumnElement.getAttribute("display-name");
        if (oldColumnDisplayName == null ? newColumnDisplayName != null : !oldColumnDisplayName.equals(newColumnDisplayName)) {
            attributes.add("display-name");
        }
        String oldColumnDesc = this.getTagValue(oldColumnElement.getChildNodes(), "description");
        String newColumnDesc = this.getTagValue(newColumnElement.getChildNodes(), "description");
        if (oldColumnDesc == null ? newColumnDesc != null : !oldColumnDesc.equals(newColumnDesc)) {
            attributes.add("description");
        }
        if (!(oldColumnDataType = this.getTagValue(oldColumnElement.getChildNodes(), "data-type")).equals(newColumnDataType = this.getTagValue(newColumnElement.getChildNodes(), "data-type"))) {
            attributes.add("data-type");
        }
        String oldColumnMaxSize = this.getTagValue(oldColumnElement.getChildNodes(), "max-size");
        String newColumnMaxSize = this.getTagValue(newColumnElement.getChildNodes(), "max-size");
        if (oldColumnMaxSize == null ? newColumnMaxSize != null : !oldColumnMaxSize.equals(newColumnMaxSize)) {
            attributes.add("max-size");
        }
        String oldColumnPrecision = this.getTagValue(oldColumnElement.getChildNodes(), "precision");
        String newColumnPrecision = this.getTagValue(newColumnElement.getChildNodes(), "precision");
        if (oldColumnPrecision == null ? newColumnPrecision != null : !oldColumnPrecision.equals(newColumnPrecision)) {
            attributes.add("precision");
        }
        String oldColumnDefaultValue = this.getTagValue(oldColumnElement.getChildNodes(), "default-value");
        String newColumnDefaultValue = this.getTagValue(newColumnElement.getChildNodes(), "default-value");
        if (oldColumnDefaultValue == null ? newColumnDefaultValue != null : !oldColumnDefaultValue.equals(newColumnDefaultValue)) {
            attributes.add("default-value");
        }
        String oldColumnNullableValue = this.getTagValue(oldColumnElement.getChildNodes(), "nullable");
        String newColumnNullableValue = this.getTagValue(newColumnElement.getChildNodes(), "nullable");
        if (oldColumnNullableValue == null ? newColumnNullableValue != null : !oldColumnNullableValue.equals(newColumnNullableValue)) {
            attributes.add("nullable");
        }
        String oldColumnUniqueValue = this.getTagValue(oldColumnElement.getChildNodes(), "unique");
        String newColumnUniqueValue = this.getTagValue(newColumnElement.getChildNodes(), "unique");
        if (oldColumnUniqueValue == null ? newColumnUniqueValue != null : !oldColumnUniqueValue.equals(newColumnUniqueValue)) {
            attributes.add("unique");
        }
        Element oldColumnAllowedValues = this.getElement(oldColumnElement.getChildNodes(), "allowed-values");
        Element newColumnAllowedValues = this.getElement(newColumnElement.getChildNodes(), "allowed-values");
        if (oldColumnAllowedValues == null && newColumnAllowedValues != null) {
            attributes.add("allowed-values");
        } else if (oldColumnAllowedValues != null && newColumnAllowedValues == null) {
            attributes.add("allowed-values");
        } else if (oldColumnAllowedValues != null && newColumnAllowedValues != null && (isChanged2 = this.diffAllowedValues(oldColumnAllowedValues, newColumnAllowedValues))) {
            attributes.add("allowed-values");
        }
        Element oldColumnUniquevalueGeneration = this.getElement(oldColumnElement.getChildNodes(), "uniquevalue-generation");
        Element newColumnUniquevalueGeneration = this.getElement(newColumnElement.getChildNodes(), "uniquevalue-generation");
        if (oldColumnUniquevalueGeneration == null && newColumnUniquevalueGeneration != null) {
            attributes.add("uniquevalue-generation");
        } else if (oldColumnUniquevalueGeneration != null && newColumnUniquevalueGeneration == null) {
            attributes.add("uniquevalue-generation");
        } else if (oldColumnUniquevalueGeneration != null && newColumnUniquevalueGeneration != null && (isChanged = this.diffUniqueValueGeneration(oldColumnUniquevalueGeneration, newColumnUniquevalueGeneration))) {
            attributes.add("uniquevalue-generation");
        }
        return attributes;
    }

    private boolean diffAllowedValues(Element oldAllowedValues, Element newAllowedValues) {
        List<String> newValues;
        String oldFromValue = this.getTagValue(oldAllowedValues.getChildNodes(), "from");
        String newFromValue = this.getTagValue(newAllowedValues.getChildNodes(), "from");
        if (oldFromValue == null ? newFromValue != null : !oldFromValue.equals(newFromValue)) {
            return true;
        }
        String oldToValue = this.getTagValue(oldAllowedValues.getChildNodes(), "to");
        String newToValue = this.getTagValue(newAllowedValues.getChildNodes(), "to");
        if (oldToValue == null ? newToValue != null : !oldToValue.equals(newToValue)) {
            return true;
        }
        String oldPattern = this.getTagValue(oldAllowedValues.getChildNodes(), "pattern");
        String newPattern = this.getTagValue(newAllowedValues.getChildNodes(), "pattern");
        if (oldPattern == null ? newPattern != null : !oldPattern.equals(newPattern)) {
            return true;
        }
        List<String> oldValues = this.getValues(oldAllowedValues.getChildNodes(), "value");
        return !oldValues.equals(newValues = this.getValues(newAllowedValues.getChildNodes(), "value"));
    }

    private boolean diffUniqueValueGeneration(Element oldgenerator, Element newgenerator) {
        String newName;
        String oldName = this.getTagValue(oldgenerator.getChildNodes(), "generator-name");
        if (!oldName.equals(newName = this.getTagValue(newgenerator.getChildNodes(), "generator-name"))) {
            return true;
        }
        String oldNameColumn = this.getTagValue(oldgenerator.getChildNodes(), "name-column");
        String newNameColumn = this.getTagValue(newgenerator.getChildNodes(), "name-column");
        if (oldNameColumn == null ? newNameColumn != null : !oldNameColumn.equals(newNameColumn)) {
            return true;
        }
        String oldGenClass = this.getTagValue(oldgenerator.getChildNodes(), "generator-class");
        String newGenClass = this.getTagValue(newgenerator.getChildNodes(), "generator-class");
        if (oldGenClass == null ? newGenClass != null : !oldGenClass.equals(newGenClass)) {
            return true;
        }
        String oldInstanceSpecificSeqGen = this.getTagValue(oldgenerator.getChildNodes(), "instancespecific-seqgen");
        String newInstanceSpecificSeqGen = this.getTagValue(newgenerator.getChildNodes(), "instancespecific-seqgen");
        return oldInstanceSpecificSeqGen == null ? newInstanceSpecificSeqGen != null : !oldInstanceSpecificSeqGen.equals(newInstanceSpecificSeqGen);
    }

    private List<String> diffPK(Element oldPK, Element newPK) {
        List<String> newPKcolumns;
        List<String> oldPKcolumns;
        ArrayList<String> attributes = new ArrayList<String>();
        String oldPKName = ((Attr)oldPK.getAttributes().getNamedItem("name")).getValue();
        String newPKName = ((Attr)newPK.getAttributes().getNamedItem("name")).getValue();
        if (oldPKName == null ? newPKName != null : !oldPKName.equals(newPKName)) {
            attributes.add("name");
        }
        if (!(oldPKcolumns = this.getValues(oldPK.getChildNodes(), "primary-key-column")).equals(newPKcolumns = this.getValues(newPK.getChildNodes(), "primary-key-column"))) {
            attributes.add("primary-key-column");
        }
        return attributes;
    }

    private void diffUKS(Element oldUniquekeys, Element newUniquekeys, String tableName, String ddName) {
        block6: {
            block7: {
                block5: {
                    if (oldUniquekeys != null || newUniquekeys == null) break block5;
                    List<String> UKNames = this.getNames(newUniquekeys.getChildNodes(), "unique-key");
                    for (String ukName : UKNames) {
                        AddedElement add = new AddedElement(this.getElementByName(newUniquekeys.getChildNodes(), "unique-key", ukName), tableName, ddName, DataDictionaryDiff.ElementType.UK);
                        this.changes.add(add);
                    }
                    break block6;
                }
                if (oldUniquekeys == null || newUniquekeys != null) break block7;
                List<String> UKNames = this.getNames(oldUniquekeys.getChildNodes(), "unique-key");
                for (String ukName : UKNames) {
                    DeletedElement drop = new DeletedElement(this.getElementByName(oldUniquekeys.getChildNodes(), "unique-key", ukName), tableName, ddName, DataDictionaryDiff.ElementType.UK);
                    this.changes.add(drop);
                }
                break block6;
            }
            if (oldUniquekeys == null || newUniquekeys == null) break block6;
            List<String> oldUKNames = this.getNames(oldUniquekeys.getChildNodes(), "unique-key");
            List<String> newUKNames = this.getNames(newUniquekeys.getChildNodes(), "unique-key");
            for (String name : newUKNames) {
                List<String> newUKColumns;
                if (!oldUKNames.contains(name)) {
                    AddedElement add = new AddedElement(this.getElementByName(newUniquekeys.getChildNodes(), "unique-key", name), tableName, ddName, DataDictionaryDiff.ElementType.UK);
                    this.changes.add(add);
                    continue;
                }
                Element oldUK = this.getElementByName(oldUniquekeys.getChildNodes(), "unique-key", name);
                Element newUK = this.getElementByName(newUniquekeys.getChildNodes(), "unique-key", name);
                List<String> oldUKColumns = this.getValues(oldUK.getChildNodes(), "unique-key-column");
                if (oldUKColumns.equals(newUKColumns = this.getValues(newUK.getChildNodes(), "unique-key-column"))) continue;
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add("unique-key-column");
                ModifiedElement modify = new ModifiedElement(oldUK, newUK, tableName, ddName, DataDictionaryDiff.ElementType.UK, attributes);
                this.changes.add(modify);
            }
            for (String name : oldUKNames) {
                if (newUKNames.contains(name)) continue;
                DeletedElement drop = new DeletedElement(this.getElementByName(oldUniquekeys.getChildNodes(), "unique-key", name), tableName, ddName, DataDictionaryDiff.ElementType.UK);
                this.changes.add(drop);
            }
        }
    }

    private void diffIDXES(Element oldIndexes, Element newIndexes, String tableName, String ddName) {
        block6: {
            block7: {
                block5: {
                    if (oldIndexes != null || newIndexes == null) break block5;
                    List<String> IDXNames = this.getNames(newIndexes.getChildNodes(), "index");
                    for (String IDXName : IDXNames) {
                        AddedElement add = new AddedElement(this.getElementByName(newIndexes.getChildNodes(), "index", IDXName), tableName, ddName, DataDictionaryDiff.ElementType.IDX);
                        this.changes.add(add);
                    }
                    break block6;
                }
                if (oldIndexes == null || newIndexes != null) break block7;
                List<String> IDXNames = this.getNames(oldIndexes.getChildNodes(), "index");
                for (String IDXName : IDXNames) {
                    DeletedElement drop = new DeletedElement(this.getElementByName(oldIndexes.getChildNodes(), "index", IDXName), tableName, ddName, DataDictionaryDiff.ElementType.IDX);
                    this.changes.add(drop);
                }
                break block6;
            }
            if (oldIndexes == null || newIndexes == null) break block6;
            List<String> oldIDXNames = this.getNames(oldIndexes.getChildNodes(), "index");
            List<String> newIDXNames = this.getNames(newIndexes.getChildNodes(), "index");
            for (String name : newIDXNames) {
                List<String> newIDXColumns;
                if (!oldIDXNames.contains(name)) {
                    AddedElement add = new AddedElement(this.getElementByName(newIndexes.getChildNodes(), "index", name), tableName, ddName, DataDictionaryDiff.ElementType.IDX);
                    this.changes.add(add);
                    continue;
                }
                Element oldIDX = this.getElementByName(oldIndexes.getChildNodes(), "index", name);
                Element newIDX = this.getElementByName(newIndexes.getChildNodes(), "index", name);
                List<String> oldIDXColumns = this.getValues(oldIDX.getChildNodes(), "index-column");
                if (oldIDXColumns.equals(newIDXColumns = this.getValues(newIDX.getChildNodes(), "index-column"))) continue;
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add("index-column");
                ModifiedElement modify = new ModifiedElement(oldIDX, newIDX, tableName, ddName, DataDictionaryDiff.ElementType.IDX, attributes);
                this.changes.add(modify);
            }
            for (String name : oldIDXNames) {
                if (newIDXNames.contains(name)) continue;
                DeletedElement drop = new DeletedElement(this.getElementByName(oldIndexes.getChildNodes(), "index", name), tableName, ddName, DataDictionaryDiff.ElementType.IDX);
                this.changes.add(drop);
            }
        }
    }

    private void diffFKS(Element oldFKS, Element newFKS, String tableName, String ddName) {
        block6: {
            block7: {
                block5: {
                    if (oldFKS != null || newFKS == null) break block5;
                    List<String> fkNames = this.getNames(newFKS.getChildNodes(), "foreign-key");
                    for (String name : fkNames) {
                        AddedElement add = new AddedElement(this.getElementByName(newFKS.getChildNodes(), "foreign-key", name), tableName, ddName, DataDictionaryDiff.ElementType.FK);
                        this.changes.add(add);
                    }
                    break block6;
                }
                if (oldFKS == null || newFKS != null) break block7;
                List<String> fkNames = this.getNames(oldFKS.getChildNodes(), "foreign-key");
                for (String name : fkNames) {
                    DeletedElement drop = new DeletedElement(this.getElementByName(oldFKS.getChildNodes(), "foreign-key", name), tableName, ddName, DataDictionaryDiff.ElementType.FK);
                    this.changes.add(drop);
                }
                break block6;
            }
            if (oldFKS == null || newFKS == null) break block6;
            List<String> oldFKNames = this.getNames(oldFKS.getChildNodes(), "foreign-key");
            List<String> newFKNames = this.getNames(newFKS.getChildNodes(), "foreign-key");
            for (String name : newFKNames) {
                Element newFKElement;
                if (!oldFKNames.contains(name)) {
                    AddedElement add = new AddedElement(this.getElementByName(newFKS.getChildNodes(), "foreign-key", name), tableName, ddName, DataDictionaryDiff.ElementType.FK);
                    this.changes.add(add);
                    continue;
                }
                Element oldFKElement = this.getElementByName(oldFKS.getChildNodes(), "foreign-key", name);
                List<String> attributes = this.diffFK(oldFKElement, newFKElement = this.getElementByName(newFKS.getChildNodes(), "foreign-key", name));
                if (attributes.isEmpty()) continue;
                ModifiedElement modify = new ModifiedElement(oldFKElement, newFKElement, tableName, ddName, DataDictionaryDiff.ElementType.FK, attributes);
                this.changes.add(modify);
            }
            for (String fkName : oldFKNames) {
                if (newFKNames.contains(fkName)) continue;
                DeletedElement drop = new DeletedElement(this.getElementByName(oldFKS.getChildNodes(), "foreign-key", fkName), tableName, ddName, DataDictionaryDiff.ElementType.FK);
                this.changes.add(drop);
            }
        }
    }

    private List<String> diffFK(Element oldFK, Element newFK) {
        Map newFKs;
        String newFKreferenceTabName;
        ArrayList<String> attributes = new ArrayList<String>();
        String oldFKreferenceTabName = oldFK.getAttribute("reference-table-name");
        if (!oldFKreferenceTabName.equals(newFKreferenceTabName = newFK.getAttribute("reference-table-name"))) {
            attributes.add("reference-table-name");
        }
        String oldFKbidirectionalValue = oldFK.getAttribute("isbidirectional");
        String newFKbidirectionalValue = newFK.getAttribute("isbidirectional");
        if (oldFKbidirectionalValue == null ? newFKbidirectionalValue != null : !oldFKbidirectionalValue.equals(newFKbidirectionalValue)) {
            attributes.add("isbidirectional");
        }
        String oldFKDesc = this.getTagValue(oldFK.getChildNodes(), "description");
        String newFKDesc = this.getTagValue(newFK.getChildNodes(), "description");
        if (oldFKDesc == null ? newFKDesc != null : !oldFKDesc.equals(newFKDesc)) {
            attributes.add("description");
        }
        String oldFKConstraint = this.getTagValue(oldFK.getChildNodes(), "fk-constraints");
        String newFKConstraint = this.getTagValue(newFK.getChildNodes(), "fk-constraints");
        if (oldFKConstraint == null ? newFKConstraint != null : !oldFKConstraint.equals(newFKConstraint)) {
            attributes.add("fk-constraints");
        }
        Element oldfkCOlumns = this.getElement(oldFK.getChildNodes(), "fk-columns");
        Element newfkColumns = this.getElement(newFK.getChildNodes(), "fk-columns");
        Map oldFKs = this.getFKColumns(oldfkCOlumns.getChildNodes());
        if (!oldFKs.equals(newFKs = this.getFKColumns(newfkColumns.getChildNodes()))) {
            attributes.add("fk-local-column");
            attributes.add("fk-reference-column");
        }
        return attributes;
    }

    private static Element getDocElement(URL url) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(url.openStream());
        return document.getDocumentElement();
    }

    static List diff(URL[] oldFiles, URL[] newFiles) throws Exception {
        Element element;
        DataDictionaryDiffGenerator ddDiffGen = new DataDictionaryDiffGenerator();
        for (int i = 0; i < oldFiles.length; ++i) {
            LOGGER.log(Level.INFO, "diff :: oldFiles[{0}] is [{1}]", new Object[]{i, oldFiles[i]});
            element = DataDictionaryDiffGenerator.getDocElement(oldFiles[i]);
            ddDiffGen.oldDocuments.add(element);
        }
        for (int j = 0; j < newFiles.length; ++j) {
            LOGGER.log(Level.INFO, "diff :: newFiles[{0}] is [{1}]", new Object[]{j, newFiles[j]});
            element = DataDictionaryDiffGenerator.getDocElement(newFiles[j]);
            ddDiffGen.newDocuments.add(element);
        }
        ddDiffGen.diffDDs();
        return ddDiffGen.changes;
    }
}

