/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataBufferStream {
    private AtomicBoolean readFlag = new AtomicBoolean(false);
    private AtomicBoolean writeFlag = new AtomicBoolean(false);
    private AtomicBoolean isCompleted = new AtomicBoolean(false);
    private OutputStream outputStream;
    private InputStream inputStream;

    public DataBufferStream(int sizeOfBufferInMB) throws IOException {
        try {
            PipedInputStream pin = new PipedInputStream(sizeOfBufferInMB * 0x100000);
            this.setInputStream(new BufferedInputStream(pin, sizeOfBufferInMB * 0x100000));
            this.setOutputStream(new PipedOutputStream(pin));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IOException("Error while creating DataBufferStream");
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    private void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public AtomicBoolean getReadFlag() {
        return this.readFlag;
    }

    public AtomicBoolean getWriteFlag() {
        return this.writeFlag;
    }

    public AtomicBoolean isCompleted() {
        return this.isCompleted;
    }

    public void setIsCompleted(boolean isCompleted) {
        this.isCompleted.set(isCompleted);
    }
}

