/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class FileNameFilter
implements FilenameFilter {
    private int patternListCount = 0;
    private String startsWith = null;
    private String endsWith = null;
    private List<Pattern> inPatterns = null;
    private List<Pattern> exPatterns = null;
    private boolean isDirectory = false;

    public FileNameFilter(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        this.inPatterns = includePatterns != null && includePatterns.size() > 0 ? new ArrayList<Pattern>(includePatterns) : null;
        this.exPatterns = excludePatterns != null && excludePatterns.size() > 0 ? new ArrayList<Pattern>(excludePatterns) : null;
        this.patternListCount += includePatterns == null ? 0 : 1;
        this.patternListCount += excludePatterns == null ? 0 : 2;
        if (this.patternListCount == 0) {
            throw new IllegalArgumentException("Both includePatterns and excludePatterns in the FileNameFilter cannot be null, if so ignore the FileNameFilter object itself");
        }
    }

    public FileNameFilter(String startsWith, String endsWith) {
        this.startsWith = startsWith == null ? startsWith : startsWith.toLowerCase(Locale.ENGLISH);
        String string = this.endsWith = endsWith == null ? endsWith : endsWith.toLowerCase(Locale.ENGLISH);
        if (this.startsWith == null && this.endsWith == null) {
            throw new IllegalArgumentException("Both startsWith and endsWith in the FileNameFilter cannot be null, if so ignore the FileNameFilter object itself");
        }
    }

    public FileNameFilter(boolean isDir) {
        this.isDirectory = isDir;
    }

    public static boolean matches(List<Pattern> patterns, String value) {
        if (patterns == null) {
            throw new IllegalArgumentException("patternList cannot be null");
        }
        for (Pattern p : patterns) {
            if (p == null) {
                throw new IllegalArgumentException("pattern cannot be null");
            }
            if (!p.matcher(value).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File directory, String fileName) {
        String fileStr = directory + (directory.toString().endsWith("/") ? "" : "/") + fileName;
        if (this.patternListCount > 0) {
            switch (this.patternListCount) {
                case 1: {
                    return FileNameFilter.matches(this.inPatterns, fileStr);
                }
                case 2: {
                    return !FileNameFilter.matches(this.exPatterns, fileStr);
                }
                case 3: {
                    return FileNameFilter.matches(this.inPatterns, fileStr) && !FileNameFilter.matches(this.exPatterns, fileStr);
                }
            }
        }
        String fileNameInLC = fileName.toLowerCase(Locale.ENGLISH);
        if (this.isDirectory) {
            return new File(fileStr).isDirectory();
        }
        return !(this.startsWith != null && !fileNameInLC.startsWith(this.startsWith) || this.endsWith != null && !fileNameInLC.endsWith(this.endsWith));
    }
}

