/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.utils;

import com.zoho.framework.utils.FileNameFilter;
import com.zoho.framework.utils.OSCheckUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());

    public static boolean deleteDir(File fileToDelete) {
        LOGGER.log(Level.INFO, "deleteDir :: {0}", fileToDelete);
        if (fileToDelete.isDirectory()) {
            for (File file : fileToDelete.listFiles()) {
                boolean deleteDir = FileUtils.deleteDir(file);
                if (deleteDir) continue;
                LOGGER.log(Level.WARNING, "Unable to delete file [{0}]", file.getAbsolutePath());
                return deleteDir;
            }
        }
        LOGGER.log(Level.INFO, "Deleted the file :: [{0}]", fileToDelete.getAbsoluteFile());
        return fileToDelete.delete();
    }

    public static void copyFile(String sourceFilePath, String destinationFilePath) throws IOException {
        FileUtils.copyFile(new File(sourceFilePath), new File(destinationFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destinationFile) throws IOException {
        LOGGER.log(Level.INFO, "Entered into copyFile :: sourceFile :: [{0}], destinationFile :: [{1}]", new Object[]{sourceFile, destinationFile});
        int BUFFER_LENGTH = 2048;
        destinationFile.getParentFile().mkdirs();
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int count;
            in = new FileInputStream(sourceFile);
            out = new FileOutputStream(destinationFile);
            byte[] data = new byte[BUFFER_LENGTH];
            while ((count = ((InputStream)in).read(data, 0, BUFFER_LENGTH)) != -1) {
                out.write(data, 0, count);
            }
            out.flush();
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private static void validateInput(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("The given dir should not be null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("The given file should be a directory");
        }
        if (dir.listFiles().length == 0) {
            throw new IllegalArgumentException("The given directory is empty");
        }
    }

    public static File[] listFiles(File dir, String startsWith, String endsWith) {
        FileUtils.validateInput(dir);
        FileNameFilter filter = new FileNameFilter(startsWith, endsWith);
        return dir.listFiles(filter);
    }

    public static File[] listFiles(File dir, boolean isDirectory) {
        FileUtils.validateInput(dir);
        FileNameFilter filter = new FileNameFilter(isDirectory);
        return dir.listFiles(filter);
    }

    public static File[] listFiles(File dir, String pattern) {
        return FileUtils.listFiles(dir, pattern, true);
    }

    public static File[] listFiles(File dir, String pattern, boolean isCaseSensitive) {
        FileUtils.validateInput(dir);
        int flag = 0;
        if (!isCaseSensitive) {
            flag = 2;
        }
        return FileUtils.listFiles(dir, FileUtils.getPatternAsList(Pattern.compile(pattern, flag)), null);
    }

    private static List<Pattern> getPatternAsList(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        patternList.add(pattern);
        return patternList;
    }

    public static File[] listFiles(File dir, Pattern pattern) {
        return FileUtils.listFiles(dir, FileUtils.getPatternAsList(pattern), null);
    }

    public static File[] listFiles(File dir, List<Pattern> includePattern, List<Pattern> excludePattern) {
        FileUtils.validateInput(dir);
        FileNameFilter filter = new FileNameFilter(includePattern, excludePattern);
        return dir.listFiles(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(File propertyFile) throws IOException {
        LOGGER.log(Level.INFO, "readPropertyFile :: {0}", propertyFile);
        Properties indexProps = new Properties();
        try (InputStream is = null;){
            is = new FileInputStream(propertyFile);
            indexProps.load(is);
            LOGGER.log(Level.FINE, "readPropertyFile :: returning props :: {0}", indexProps);
        }
        return indexProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File outFile, Properties props, String header) throws IOException {
        LOGGER.log(Level.INFO, "writeToFile :: props :: {0} outFile :: [{1}] header :: [{2}]", new Object[]{props, outFile, header});
        try (OutputStream os = null;){
            os = new FileOutputStream(outFile);
            props.store(os, header == null ? "" : header);
        }
    }

    public static void changePermissionForFile(String filePath) throws IOException, InterruptedException {
        if (OSCheckUtil.getOS() != 2) {
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add("chmod");
            commandList.add("-R");
            commandList.add("755");
            commandList.add(filePath);
            boolean writeToFile = true;
            Process p = FileUtils.executeCommand(commandList, writeToFile, true);
            p.waitFor();
            LOGGER.log(Level.INFO, "File Permissions successfully changed for the file :: [{0}]", filePath);
        } else {
            LOGGER.log(Level.SEVERE, "changePermissionForFile not implemented for Windows");
        }
    }

    private static Process executeCommand(List<String> commandList, boolean writeToFile, boolean executeCmd) throws IOException {
        if (!writeToFile || OSCheckUtil.getOS() == 2) {
            LOGGER.log(Level.INFO, "Command to be executed ::: {0}", commandList);
            ProcessBuilder processBuilder = new ProcessBuilder(commandList);
            return processBuilder.start();
        }
        File serverHome = new File(System.getProperty("server.home", ".."));
        File extFile = new File(serverHome.getAbsolutePath() + File.separator + "ext.sh");
        LOGGER.log(Level.INFO, "Writing comman to ext.sh file ::: {0}", commandList);
        RandomAccessFile f = new RandomAccessFile(extFile.getAbsolutePath(), "rw");
        if (extFile.length() != 0L) {
            f.seek(extFile.length());
            f.write(System.getProperty("line.separator").getBytes());
        }
        for (String cmd : commandList) {
            f.write(cmd.toString().getBytes());
            f.write(" ".getBytes());
        }
        f.close();
        if (executeCmd) {
            LOGGER.info("Executing all commands in ext.sh ");
            ArrayList<String> extCmdList = new ArrayList<String>();
            extCmdList.add("sh");
            extCmdList.add(extFile.getAbsolutePath());
            LOGGER.log(Level.INFO, "Command to be executed ::: {0}", extCmdList);
            ProcessBuilder processBuilder = new ProcessBuilder(extCmdList);
            return processBuilder.start();
        }
        return null;
    }

    public static boolean moveDirectory(String srcDirPath, String destDirPath) {
        File fromDir = new File(srcDirPath);
        if (fromDir.exists() && fromDir.isDirectory()) {
            File toDir = new File(destDirPath);
            LOGGER.log(Level.INFO, "Renaming directory {0} to {1}.", new String[]{fromDir.getAbsolutePath(), toDir.getAbsolutePath()});
            return fromDir.renameTo(toDir);
        }
        LOGGER.log(Level.WARNING, "Unable to peform the rename of directory {0} to {1}", new String[]{srcDirPath, destDirPath});
        return false;
    }
}

