/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.utils.archive;

import com.zoho.framework.utils.FileUtils;
import com.zoho.framework.utils.OSCheckUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class SevenZipUtils {
    private static final Logger LOGGER = Logger.getLogger(SevenZipUtils.class.getName());

    public static int zip(File zipFolder, String zipFileName, File contentDirectory, boolean includeContentDirectoryToo, boolean includeFilesInContentDirectory, List<String> includeFileList, List<String> excludeFileList) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "Entered createZip(), backupDir :: [{0}], zipFileName :: [{1}], contentDirectory :: [{2}], includeContentDirectoryToo :: [{3}], includeFileList :: [{4}], excludeFileList :: [{5}]", new Object[]{zipFolder, zipFileName, contentDirectory, includeContentDirectoryToo, includeFileList, excludeFileList});
        if (!zipFolder.exists()) {
            zipFolder.mkdirs();
        }
        LOGGER.log(Level.INFO, "Going to create the Incremental/Full BackUpFile :: [{0}]", zipFileName);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(SevenZipUtils.get7zPath());
        commandList.add("u");
        commandList.add(zipFolder.getAbsolutePath() + File.separator + zipFileName);
        if (includeContentDirectoryToo) {
            commandList.add(contentDirectory.getAbsolutePath());
        }
        if (includeFilesInContentDirectory) {
            commandList.add(contentDirectory.getAbsolutePath() + File.separator + "*");
        }
        if (includeFileList != null) {
            for (String file : includeFileList) {
                commandList.add("-ir!" + file);
            }
        }
        if (excludeFileList != null) {
            for (String file : excludeFileList) {
                commandList.add("-xr!" + file);
            }
        }
        Process start = SevenZipUtils.executeCommand(commandList);
        BufferedReader ipBuf = new BufferedReader(new InputStreamReader(start.getInputStream()));
        String line = null;
        while ((line = ipBuf.readLine()) != null) {
            LOGGER.info(line);
        }
        start.waitFor();
        int exitValue = start.exitValue();
        LOGGER.log(Level.INFO, "Exiting createZip() with value :: [{0}]", exitValue);
        return exitValue;
    }

    public static int appendInZip(String zipFilePath, List<String> includeFileList) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "Entered appendInZip(), zipFileName :: [{0}], includeFileList :: [{1}],", new Object[]{zipFilePath, includeFileList});
        if (!new File(zipFilePath).exists()) {
            throw new IOException("Zip File does not exists :: " + zipFilePath);
        }
        LOGGER.log(Level.INFO, "Going to append files to zip :: [{0}]", zipFilePath);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(SevenZipUtils.get7zPath());
        commandList.add("u");
        commandList.add(new File(zipFilePath).getAbsolutePath());
        if (includeFileList != null) {
            for (String file : includeFileList) {
                commandList.add("-ir!" + file);
            }
        }
        Process start = SevenZipUtils.executeCommand(commandList);
        BufferedReader ipBuf = new BufferedReader(new InputStreamReader(start.getInputStream()));
        String line = null;
        while ((line = ipBuf.readLine()) != null) {
            LOGGER.info(line);
        }
        start.waitFor();
        int exitValue = start.exitValue();
        LOGGER.log(Level.INFO, "Exiting appendInZip() with value :: [{0}]", exitValue);
        return exitValue;
    }

    public static int unZip(File zipFile, File destinationFolder, List<String> includeFileList, List<String> excludeFileList) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "Entered extract7zipFile() :: zipFileName :: [{0}]", zipFile);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(SevenZipUtils.get7zPath());
        commandList.add("x");
        commandList.add(zipFile.getCanonicalPath());
        commandList.add("-y");
        commandList.add("-o" + (destinationFolder == null ? "tmp" : destinationFolder.getCanonicalPath()));
        if (includeFileList != null) {
            for (String file : includeFileList) {
                commandList.add("-ir!" + file);
            }
        }
        if (excludeFileList != null) {
            for (String file : excludeFileList) {
                commandList.add("-xr!" + file);
            }
        }
        Process start = SevenZipUtils.executeCommand(commandList);
        BufferedReader ipBuf = new BufferedReader(new InputStreamReader(start.getInputStream()));
        String line = null;
        while ((line = ipBuf.readLine()) != null) {
            LOGGER.info(line);
        }
        start.waitFor();
        int exitValue = start.exitValue();
        LOGGER.log(Level.INFO, "Exiting extract7zipFile() with value :: [{0}]", exitValue);
        return exitValue;
    }

    private static String get7zPath() throws IOException, InterruptedException {
        File sevenZip64 = new File(System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za_64");
        File sevenZip32 = new File(System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za");
        File sevenZipMac = new File(System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za_mac");
        File sevenZipWindows = new File(System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za.exe");
        if (OSCheckUtil.isWindows(OSCheckUtil.getOS())) {
            if (sevenZip64.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZip64.getCanonicalPath());
                sevenZip64.delete();
            }
            if (sevenZip32.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZip32.getCanonicalPath());
                sevenZip32.delete();
            }
            if (sevenZipMac.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZipMac.getCanonicalPath());
                sevenZipMac.delete();
            }
            return System.getProperty("tools.7zip.win.path", System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za.exe");
        }
        if (OSCheckUtil.getOSName().contains("linux")) {
            if (sevenZipWindows.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZipWindows.getCanonicalPath());
                sevenZipWindows.delete();
            }
            if (sevenZipMac.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZipMac.getCanonicalPath());
                sevenZipMac.delete();
            }
            if (Integer.parseInt(System.getProperty("sun.arch.data.model")) == 64) {
                if (sevenZip64.exists()) {
                    if (sevenZip32.exists()) {
                        LOGGER.log(Level.INFO, "Deleting file :: " + sevenZip32.getCanonicalPath());
                        sevenZip32.delete();
                    }
                    if (!sevenZip64.renameTo(sevenZip32)) {
                        throw new IOException("Rename operation failed for file :: " + sevenZip64.getCanonicalPath());
                    }
                    LOGGER.log(Level.INFO, "Renamed file :: " + sevenZip64.getCanonicalPath() + " to " + sevenZip32.getCanonicalPath());
                }
            } else if (sevenZip64.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZip64.getCanonicalPath());
                sevenZip64.delete();
            }
            FileUtils.changePermissionForFile(System.getProperty("tools.7zip.lin.path", System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za"));
            return System.getProperty("tools.7zip.lin.path", System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za");
        }
        if (sevenZipWindows.exists()) {
            LOGGER.log(Level.INFO, "Deleting file :: " + sevenZipWindows.getCanonicalPath());
            sevenZipWindows.delete();
        }
        if (sevenZip64.exists()) {
            LOGGER.log(Level.INFO, "Deleting file :: " + sevenZip64.getCanonicalPath());
            sevenZip64.delete();
        }
        if (sevenZipMac.exists()) {
            if (sevenZip32.exists()) {
                LOGGER.log(Level.INFO, "Deleting file :: " + sevenZip32.getCanonicalPath());
                sevenZip32.delete();
            }
            if (!sevenZipMac.renameTo(sevenZip32)) {
                throw new IOException("Rename operation failed for file :: " + sevenZip64.getCanonicalPath());
            }
            LOGGER.log(Level.INFO, "Renamed file :: " + sevenZip64.getCanonicalPath() + " to " + sevenZip32.getCanonicalPath());
        }
        FileUtils.changePermissionForFile(System.getProperty("tools.7zip.mac.path", System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za"));
        return System.getProperty("tools.7zip.mac.path", System.getProperty("server.home") + File.separator + "tools" + File.separator + "archiver" + File.separator + "7za");
    }

    private static Process executeCommand(List<String> commandList) throws IOException {
        ProcessBuilder processBuilder = null;
        LOGGER.log(Level.INFO, "Command to be executed ::: {0}", commandList);
        processBuilder = new ProcessBuilder(commandList);
        return processBuilder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileExistsInZip(String zipNameWithFullPath, String entryNameWithPackage) throws IOException {
        try (ZipFile zip = null;){
            zip = new ZipFile(zipNameWithFullPath);
            boolean bl = zip.getEntry(entryNameWithPackage) != null;
            return bl;
        }
    }
}

