/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.utils.archive;

import com.zoho.framework.utils.FileNameFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final Logger LOGGER = Logger.getLogger(ZipUtils.class.getName());
    private static final int BUFFER = 2048;

    public static void unZip(String zipFile, String destinationDirectory) throws IOException {
        ZipUtils.unZip(zipFile, destinationDirectory, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(String zipFile, String destinationDirectory, String fileToBeExtracted, List<Pattern> excludePatterns) throws IOException {
        LOGGER.log(Level.INFO, "Entered unZip :: zipFile :: [{0}], destinationDirectory :: [{1}], fileToBeExtracted :: [{2}]", new Object[]{zipFile, destinationDirectory, fileToBeExtracted});
        String folderToBeExtracted = fileToBeExtracted == null ? null : (fileToBeExtracted.endsWith("/") ? fileToBeExtracted : fileToBeExtracted + "/");
        FilterOutputStream dest = null;
        FileInputStream fis = null;
        ZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            ZipEntry entry;
            fis = new FileInputStream(zipFile);
            zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                byte[] data = new byte[2048];
                String entryName = entry.getName();
                if (excludePatterns != null && FileNameFilter.matches(excludePatterns, entryName)) continue;
                String destname = destinationDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    if (fileToBeExtracted != null && !entry.getName().startsWith(folderToBeExtracted) && !entry.getName().equals(fileToBeExtracted)) continue;
                    File parentFolder = new File(destname).getParentFile();
                    if (!parentFolder.exists()) {
                        parentFolder.mkdirs();
                    }
                    try {
                        int count;
                        fos = new FileOutputStream(destname);
                        dest = new BufferedOutputStream(fos, 2048);
                        while ((count = zis.read(data, 0, 2048)) != -1) {
                            ((BufferedOutputStream)dest).write(data, 0, count);
                        }
                        ((BufferedOutputStream)dest).flush();
                        continue;
                    }
                    finally {
                        dest.close();
                        continue;
                    }
                }
                if (fileToBeExtracted != null && !entry.getName().startsWith(fileToBeExtracted)) continue;
                new File(destname).mkdirs();
            }
            zis.close();
            LOGGER.log(Level.INFO, "Unzipping successfully completed ...");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (dest != null) {
                    dest.close();
                }
                if (zis != null) {
                    zis.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.log(Level.INFO, "{0}", e);
            }
        }
    }

    public static boolean isFileExistsInZip(String zipNameWithFullPath, String entryNameWithPackage) throws IOException {
        ZipFile zip = new ZipFile(zipNameWithFullPath);
        return zip.getEntry(entryNameWithPackage) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractFile(String zipFileName, String fileNameWithPath, String destinationFolderWithAbsolutePath) throws IOException {
        LOGGER.log(Level.INFO, "extractFile :: zipFileName :: [{0}], fileNameWithPath :: [{1}]", new Object[]{zipFileName, fileNameWithPath});
        ZipFile zip = new ZipFile(zipFileName);
        ZipEntry ze = zip.getEntry(fileNameWithPath);
        FileOutputStream fos = null;
        BufferedInputStream bis = null;
        File destinationFile = null;
        try {
            destinationFile = new File(destinationFolderWithAbsolutePath, fileNameWithPath);
            File parentFolder = destinationFile.getParentFile();
            parentFolder.mkdirs();
            fos = new FileOutputStream(new File(destinationFolderWithAbsolutePath, fileNameWithPath));
            bis = new BufferedInputStream(zip.getInputStream(ze));
            byte[] data = new byte[2048];
            int count = 0;
            while ((count = bis.read(data, 0, 2048)) > 0) {
                fos.write(data, 0, count);
            }
            fos.flush();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        LOGGER.log(Level.INFO, "Returning from extractFile method for the zip :: [{0}]", zipFileName);
        return destinationFile;
    }

    public static void zip(File zipFolder, String zipFileName, Map<String, List<File>> dirVsFiles) throws IOException {
        LOGGER.log(Level.INFO, "Entered createBackUpZip(), zipFolder :: [{0}], zipFileName :: [{1}], dirVsFiles :: [{2}]", new Object[]{zipFolder, zipFileName, dirVsFiles});
        if (!zipFolder.exists()) {
            zipFolder.mkdirs();
        }
        BufferedInputStream buffInputStream = null;
        FileOutputStream dest = null;
        ZipOutputStream zOut = null;
        FileInputStream fi = null;
        try {
            dest = new FileOutputStream(zipFolder + File.separator + zipFileName, true);
            zOut = new ZipOutputStream(new BufferedOutputStream(dest));
            ZipUtils.addFilesToZip(zOut, dirVsFiles);
            LOGGER.log(Level.INFO, "Finished writing the zip file :: [{0}]", zipFileName);
            zOut.finish();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (buffInputStream != null) {
                try {
                    buffInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (zOut != null) {
                try {
                    zOut.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendInZip(String zipFileName, Map<String, List<File>> dirVsFiles) throws IOException {
        LOGGER.log(Level.INFO, "Entered appendInBackupZip :: zipFileName :: [{0}], dirVsFiles :: {1}", new Object[]{zipFileName, dirVsFiles});
        File sourceZipFile = new File(zipFileName);
        if (!sourceZipFile.exists()) {
            throw new FileNotFoundException("ZIP File not found at :: [" + sourceZipFile.getAbsolutePath() + "]");
        }
        File tempZip = File.createTempFile("temp.zip", null, sourceZipFile.getParentFile());
        if (tempZip.exists()) {
            LOGGER.log(Level.INFO, "[{0}] already exists hence deleting it ...", tempZip);
            tempZip.delete();
        }
        if (!sourceZipFile.renameTo(tempZip)) {
            throw new IOException("Unable to make the temporary zip file for :: [" + sourceZipFile + "]");
        }
        byte[] b = new byte[4096];
        ZipInputStream zi = null;
        ZipOutputStream zo = null;
        ZipEntry ze = null;
        try {
            zi = new ZipInputStream(new FileInputStream(tempZip));
            zo = new ZipOutputStream(new FileOutputStream(sourceZipFile));
            while ((ze = zi.getNextEntry()) != null) {
                int len;
                zo.putNextEntry(new ZipEntry(ze.getName()));
                while ((len = zi.read(b)) != -1) {
                    zo.write(b, 0, len);
                }
            }
            zi.close();
            ZipUtils.addFilesToZip(zo, dirVsFiles);
            zo.finish();
            LOGGER.log(Level.INFO, "Finished appending the zip file :: [{0}]", zipFileName);
            tempZip.delete();
        }
        finally {
            if (zi != null) {
                try {
                    zi.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (zo != null) {
                try {
                    zo.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void addFilesToZip(ZipOutputStream zOut, Map<String, List<File>> dirVsFiles) throws IOException {
        for (Map.Entry<String, List<File>> me : dirVsFiles.entrySet()) {
            String archiveFileDir = me.getKey();
            List<File> archivedFilesForBackup = me.getValue();
            if (archivedFilesForBackup.isEmpty()) {
                zOut.putNextEntry(new ZipEntry(archiveFileDir != null ? archiveFileDir + "/" : ""));
                continue;
            }
            ZipUtils.writeInZip(zOut, archiveFileDir, archivedFilesForBackup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInZip(ZipOutputStream zOut, String parentDir, List<File> fileNames) {
        ArrayList<String> excludeFiles = new ArrayList<String>();
        excludeFiles.add("postmaster.pid");
        excludeFiles.add("backup_label");
        int buffer = 4096;
        for (File file : fileNames) {
            if (file.isFile() && excludeFiles.contains(file.getName())) {
                LOGGER.log(Level.INFO, "Ignoring the file :: [{0}]", file);
                continue;
            }
            byte[] data = new byte[buffer];
            BufferedInputStream buffInputStream = null;
            FileInputStream fi = null;
            try {
                int count;
                if (file.isDirectory()) {
                    zOut.putNextEntry(new ZipEntry((parentDir != null ? parentDir + "/" : "") + file.getName() + "/"));
                    ZipUtils.writeInZip(zOut, (parentDir != null ? parentDir + "/" : "") + file.getName(), Arrays.asList(file.listFiles()));
                    continue;
                }
                fi = new FileInputStream(file);
                buffInputStream = new BufferedInputStream(fi, buffer);
                ZipEntry entry = new ZipEntry((parentDir != null ? parentDir + "/" : "") + file.getName());
                entry.setMethod(8);
                zOut.putNextEntry(entry);
                while ((count = buffInputStream.read(data, 0, buffer)) != -1) {
                    zOut.write(data, 0, count);
                }
                zOut.closeEntry();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (buffInputStream == null) continue;
                try {
                    fi.close();
                    buffInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void zip(String zipFileName, List<String> directoriesToBeArchived, boolean zipSubDirs, Properties prefProps) throws Exception {
        String serverHome = new File(System.getProperty("server.home")).getCanonicalPath();
        FileOutputStream dest = null;
        ZipOutputStream output = null;
        try {
            LOGGER.log(Level.INFO, "Creating zip file started ::: {0}", zipFileName);
            dest = new FileOutputStream(zipFileName, true);
            output = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            for (String path : directoriesToBeArchived) {
                File f = new File(path);
                boolean ignoreException = ZipUtils.getPreferenceToAddFileInZip(path, prefProps);
                LOGGER.log(Level.INFO, "Adding file [{0}] to zip ::: backup preference ::: {1}", new Object[]{path, ignoreException});
                try {
                    int serverIndex = f.getCanonicalPath().indexOf(serverHome);
                    int bacubDirIndex = f.getCanonicalPath().indexOf(new File(zipFileName).getParentFile().getCanonicalPath());
                    if (f.exists() && (serverIndex != -1 || bacubDirIndex != -1)) {
                        String zipEntryPath;
                        String string = zipEntryPath = zipSubDirs ? f.getCanonicalPath().substring(serverHome.length(), f.getCanonicalPath().length()) : "";
                        if (!zipEntryPath.equals("") && zipEntryPath.startsWith(File.separator)) {
                            zipEntryPath = zipEntryPath.substring(1, zipEntryPath.length());
                        }
                        if (f.isDirectory()) {
                            LOGGER.log(Level.INFO, "Compressing files in directory ::: {0}", f.getCanonicalPath());
                            String[] files = f.list();
                            LOGGER.log(Level.INFO, "Number of file in the directory ::: {0}", files.length);
                            File[] f1 = f.listFiles();
                            for (int i = 0; i < files.length; ++i) {
                                ZipUtils.addEntryToZip(f1[i], zipEntryPath, data, output, zipSubDirs);
                            }
                            continue;
                        }
                        LOGGER.log(Level.INFO, "Compressing file ::: {0}", f.getCanonicalPath());
                        String fName = f.getName();
                        zipEntryPath = zipEntryPath.substring(0, zipEntryPath.length() - fName.length() - 1);
                        ZipUtils.addEntryToZip(f, zipEntryPath, data, output, zipSubDirs);
                        continue;
                    }
                    if (!ignoreException) {
                        throw new Exception("Unknown File/Directory path [" + path + "] specified. Directory/File should be reside in " + serverHome);
                    }
                    LOGGER.log(Level.WARNING, "Unknown File/Directory path [{0}] specified. Directory/File should be reside in {1}", new Object[]{path, serverHome});
                    LOGGER.warning("Error ignored as per backup preference");
                }
                catch (Exception e) {
                    if (!ignoreException) {
                        throw e;
                    }
                    LOGGER.log(Level.WARNING, "The below Exception is ignored for {0}", path);
                    e.printStackTrace();
                }
            }
            output.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error occurred while zipping:{0}", e);
            throw e;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                if (dest != null) {
                    dest.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "{0}", e);
            }
        }
    }

    private static boolean getPreferenceToAddFileInZip(String fileName, Properties props) throws Exception {
        if (props == null) {
            LOGGER.info("No preference given, hence returning false.");
            return false;
        }
        String pref = props.getProperty(fileName);
        LOGGER.log(Level.INFO, "Preference specified in conf file for {0} = {1}", new Object[]{fileName, pref});
        if (pref == null || pref.equals("") || pref.equals("ON_EXCEPTION_FAIL")) {
            return false;
        }
        if (pref.equals("ON_EXCEPTION_IGNORE")) {
            return true;
        }
        throw new Exception("Unknown preference [" + pref + "] specified for file name [" + fileName + "] in backup_files.conf");
    }

    private static void addEntryToZip(File fileToBeArchived, String zipEntryPath, byte[] data, ZipOutputStream output, boolean zipSubDir) throws Exception {
        FileInputStream fi = null;
        BufferedInputStream origin = null;
        try {
            String zipEntry;
            LOGGER.log(Level.FINE, "Adding to Zip: {0}", fileToBeArchived.getName());
            String string = zipEntry = zipEntryPath == null || zipEntryPath.equals("") ? fileToBeArchived.getName() : zipEntryPath + "/" + fileToBeArchived.getName();
            if (fileToBeArchived.isDirectory()) {
                zipEntry = zipEntry + "/";
            }
            ZipEntry entry = new ZipEntry(zipEntry);
            entry.setMethod(8);
            output.putNextEntry(entry);
            if (!fileToBeArchived.isDirectory()) {
                int count;
                fi = new FileInputStream(fileToBeArchived);
                origin = new BufferedInputStream(fi, 2048);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    output.write(data, 0, count);
                }
                fi.close();
                origin.close();
            }
            if (fileToBeArchived.isDirectory() && zipSubDir) {
                for (File file : fileToBeArchived.listFiles()) {
                    ZipUtils.addEntryToZip(file, zipEntryPath + "/" + fileToBeArchived.getName(), data, output, zipSubDir);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (origin != null) {
                    origin.close();
                }
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "{0}", e);
            }
        }
    }

    public static Set<String> getAllZipEntries(String zipNameWithFullPath) throws IOException {
        TreeSet<String> entries = new TreeSet<String>();
        ZipFile zip = new ZipFile(zipNameWithFullPath);
        ZipEntry ze = null;
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            ze = zipEntries.nextElement();
            entries.add(ze.getName());
        }
        zip.close();
        return entries;
    }
}

