/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.utils.crypto;

import com.zoho.framework.utils.crypto.EnDecrypt;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CryptoUtil {
    private static final Logger LOGGER = Logger.getLogger(CryptoUtil.class.getName());
    private static EnDecrypt cryptInstance = null;

    public static void setEnDecryptInstance(EnDecrypt instance) throws Exception {
        if (null != cryptInstance) {
            LOGGER.log(Level.INFO, "Already crypt instance has been set and hence this [{0}] is ignored", instance);
            return;
        }
        cryptInstance = instance;
    }

    public static String encrypt(String plaintext) {
        if (null == plaintext || 0 == plaintext.trim().length()) {
            return plaintext;
        }
        if (cryptInstance == null) {
            LOGGER.log(Level.WARNING, "EnDecrypt instance has not been initialized. EnDeccryptInstance is [{0}]  ", cryptInstance);
            return plaintext;
        }
        try {
            return cryptInstance.encrypt(plaintext);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Encryption failed for " + plaintext);
            return plaintext;
        }
    }

    public static String decrypt(String cipherText) {
        if (null == cipherText || 0 == cipherText.trim().length()) {
            return cipherText;
        }
        if (cryptInstance == null) {
            LOGGER.log(Level.WARNING, "EnDecrypt instance has not been initialized. EnDecryptInstance is [{0}]  ", cryptInstance);
            return cipherText;
        }
        try {
            return cryptInstance.decrypt(cipherText);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Decryption failed for " + cipherText);
            return cipherText;
        }
    }
}

