/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.framework.utils.crypto;

import com.zoho.framework.utils.crypto.EnDecrypt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class EnDecryptImpl
implements EnDecrypt {
    private static final Logger LOGGER = Logger.getLogger(EnDecrypt.class.getName());
    private static final String DES_KEY = "MLITE_ENCRYPT_DECRYPT";
    private static final String ENCODING = "UTF-8";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static SecretKeyFactory desKeyFactory = null;
    private static SecretKey desSecretKey = null;

    public EnDecryptImpl() {
        this.initializeKey();
    }

    private void initializeKey() {
        try {
            DESKeySpec desKeySpec = new DESKeySpec(DES_KEY.getBytes(ENCODING));
            desKeyFactory = SecretKeyFactory.getInstance("DES");
            desSecretKey = desKeyFactory.generateSecret(desKeySpec);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Keygeneration failed");
        }
    }

    @Override
    public String encrypt(String plainText) {
        try {
            Cipher desCipher = Cipher.getInstance("DES");
            desCipher.init(1, desSecretKey);
            byte[] cleartext = plainText.getBytes(ENCODING);
            byte[] ciphertext = desCipher.doFinal(cleartext);
            String encryptedString = EnDecryptImpl.BASE16_ENCODE(ciphertext);
            return encryptedString;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Encryption failed");
            return plainText;
        }
    }

    @Override
    public String decrypt(String cipherText) {
        try {
            Cipher desCipher = Cipher.getInstance("DES");
            desCipher.init(2, desSecretKey);
            byte[] ciphertext = cipherText.getBytes(ENCODING);
            byte[] dc = desCipher.doFinal(EnDecryptImpl.BASE16_DECODE(cipherText));
            String decryptedString = EnDecryptImpl.B2S(dc);
            return decryptedString;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Encryption failed");
            return cipherText;
        }
    }

    private static String BASE16_ENCODE(byte[] input) {
        char[] b16 = new char[input.length * 2];
        int i = 0;
        for (byte c : input) {
            int low = c & 0xF;
            int high = (c & 0xF0) >> 4;
            b16[i++] = HEX[high];
            b16[i++] = HEX[low];
        }
        return new String(b16);
    }

    private static byte[] BASE16_DECODE(String b16str) {
        int len = b16str.length();
        byte[] out = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            int c1 = EnDecryptImpl.INT(b16str.charAt(i));
            int c2 = EnDecryptImpl.INT(b16str.charAt(i + 1));
            int bt = c1 << 4 | c2;
            out[j++] = (byte)bt;
        }
        return out;
    }

    private static int INT(char c) {
        return Integer.decode("0x" + c);
    }

    private static String B2S(byte[] bytes) {
        return new String(bytes);
    }

    public static void main(String[] args) {
        EnDecryptImpl encryptor = new EnDecryptImpl();
        for (String plainText : args) {
            System.out.println(plainText + "=" + encryptor.encrypt(plainText));
        }
    }
}

