/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.net.handshake;

import com.zoho.net.handshake.HandShakePacket;
import com.zoho.net.handshake.RecvFromServer;
import com.zoho.net.handshake.SendToServer;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Logger;

public class HandShakeClient {
    private Socket socket;
    private SendToServer sendToServer = null;
    private RecvFromServer recvFromServer = null;
    private static final Logger LOGGER = Logger.getLogger(HandShakeClient.class.getName());

    HandShakeClient(String serverHostName, int serverHandShakePort) throws IOException {
        try {
            this.socket = new Socket(serverHostName, serverHandShakePort);
            this.socket.setSoTimeout(Integer.parseInt(System.getProperty("handshakeclient.sotimeout", "10000")));
            LOGGER.info("Connection established!!!");
            this.sendToServer = new SendToServer(this.socket);
            this.recvFromServer = new RecvFromServer(this.socket);
        }
        catch (IOException e) {
            IOException ioException = new IOException("Exception while connecting HandShakeServer!!!");
            ioException.initCause(e);
            throw ioException;
        }
    }

    public HandShakePacket getPingMessage(String message) throws IOException, ClassNotFoundException {
        LOGGER.info("Sending message :: " + message);
        this.sendToServer.sendMessage(message);
        return this.recvFromServer.getMessage();
    }

    public HandShakePacket getPingMessageAndExit(String message) throws IOException, ClassNotFoundException {
        HandShakePacket responsePacket = this.getPingMessage(message);
        this.close();
        return responsePacket;
    }

    public void close() {
        try {
            this.recvFromServer.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.sendToServer.close();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

