/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.net.handshake;

import com.zoho.net.handshake.HandShakeServer;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HandShakePacket
implements Serializable {
    private static final long serialVersionUID = 4777879186453183038L;
    private String serverHostName = null;
    private String serverHome;
    private long handShakeServerID = 0L;
    private int handShakeServerPort;
    private String message = null;
    public static final String UNKNOWN_PING_MESSAGE = "UNKNOWN_PING_MESSAGE";
    public static final String ALIVE = "ALIVE";
    public static final String PING = "PING";
    private static final String FORMAT = "%-28s:%s\n";

    public HandShakePacket() {
        try {
            this.setServerHostName(InetAddress.getLocalHost().getHostName());
            this.setServerHome(new File(".").getAbsolutePath());
            this.setHandShakeServerPort(HandShakeServer.getServerListeningPort());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public String getServerHostName() {
        return this.serverHostName;
    }

    public void setServerHome(String serverHome) {
        this.serverHome = serverHome;
    }

    void setServerHostName(String serverHostName) {
        this.serverHostName = serverHostName;
    }

    public String getServerHome() {
        return this.serverHome;
    }

    public int getHandShakeServerPort() {
        return this.handShakeServerPort;
    }

    void setHandShakeServerPort(int serverPort) {
        this.handShakeServerPort = serverPort;
    }

    public String getMessage() {
        return this.message;
    }

    void setResposeMessage(String message) {
        this.message = message;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("HandShake response details");
        buff.append("\n--------------------------\n");
        buff.append(String.format(FORMAT, "SERVER_HOME", this.getServerHome()));
        buff.append(String.format(FORMAT, "SERVER_HOST_NAME", this.getServerHostName()));
        buff.append(String.format(FORMAT, "SERVER_ID", this.getHandShakeServerID()));
        buff.append(String.format(FORMAT, "HANDSHAKE_SERVER_PORT", this.getHandShakeServerPort()));
        buff.append(String.format(FORMAT, "HANDSHAKE_RESPONSE_MESSAGE", this.getMessage()));
        return buff.toString();
    }

    public long getHandShakeServerID() {
        return this.handShakeServerID;
    }

    public void setHandShakeServerID(long handShakeServerID) {
        this.handShakeServerID = handShakeServerID;
    }
}

