/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.net.handshake;

import com.zoho.net.handshake.HandShakePacket;
import com.zoho.net.handshake.HandShakeServerMessageHandler;
import com.zoho.net.handshake.HandShakeUtil;
import com.zoho.net.handshake.RecvFromClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class HandShakeServer
implements Callable<Boolean> {
    private static final Properties CONF_PROP = new Properties();
    private static final Logger LOGGER = Logger.getLogger(HandShakeServer.class.getName());
    private static boolean isConfLoaded = Boolean.FALSE;
    private static int serverListeningPort = -1;
    private static long serverStartedTime = -1L;
    private static final List<HandShakeServerMessageHandler> MESSAGE_HANDLERS = new ArrayList<HandShakeServerMessageHandler>();

    @Override
    public Boolean call() throws Exception {
        HandShakeServer.loadConfiguredMessages();
        ExecutorService messengerServicePool = Executors.newFixedThreadPool(Integer.parseInt(CONF_PROP.getProperty("message.listen.queue.size", "3")));
        ServerSocket servSock = null;
        try {
            LOGGER.info("Starting HandShakeServer...");
            servSock = new ServerSocket();
            servSock.bind(HandShakeServer.getInetSockAddr());
            HandShakeServer.writeToLockFile(servSock.getLocalPort());
            HandShakeServer.setServerListeningPort(servSock.getLocalPort());
            HandShakeServer.setServerStartedTime(System.currentTimeMillis());
            while (true) {
                LOGGER.info("Waiting for client connection...");
                messengerServicePool.submit(new RecvFromClient(servSock.accept()));
            }
        }
        catch (Throwable throwable) {
            if (servSock != null) {
                try {
                    servSock.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            HandShakeUtil.deleteLockFile();
            throw throwable;
        }
    }

    private static InetSocketAddress getInetSockAddr() {
        int port = 0;
        InetSocketAddress inetsktaddr = null;
        String bindaddress = System.getProperty("bindaddress");
        if (bindaddress != null) {
            try {
                inetsktaddr = new InetSocketAddress(InetAddress.getByName(bindaddress), port);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        } else {
            inetsktaddr = new InetSocketAddress(port);
        }
        return inetsktaddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfiguredMessages() throws IOException {
        File handshakeConf = new File(System.getProperty("server.dir") + "/conf/handshake_messages.conf");
        if (handshakeConf.exists() && !isConfLoaded) {
            try (FileInputStream fileInputStream = null;){
                fileInputStream = new FileInputStream(handshakeConf);
                CONF_PROP.load(fileInputStream);
            }
            isConfLoaded = Boolean.TRUE;
        }
    }

    private static void getConfiguredHandlers() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (!CONF_PROP.isEmpty()) {
            for (String handler : CONF_PROP.getProperty("message.handlers", "").split(",")) {
                handler = handler.trim();
                HandShakeServer.addMessageHandler((HandShakeServerMessageHandler)Class.forName(handler).newInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToLockFile(int port) throws IOException {
        LOGGER.info("Writing HandShakeServer port [" + port + "] in .lock file");
        File lockFile = new File(".lock");
        if (lockFile.exists()) {
            lockFile.delete();
        }
        String value = String.valueOf(port);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(lockFile);
            byte[] b = value.getBytes();
            fos.write(b);
        }
    }

    static void addMessageHandler(HandShakeServerMessageHandler handler) {
        HandShakeServer.getMessagehandlers().add(handler);
    }

    static String getConfiguredResponseMessage(HandShakePacket packetFromClient) {
        String messageFromClient = packetFromClient.getMessage();
        if (messageFromClient != null) {
            return messageFromClient.equals("PING") ? "ALIVE" : CONF_PROP.getProperty(messageFromClient, "UNKNOWN_PING_MESSAGE");
        }
        return "UNKNOWN_PING_MESSAGE";
    }

    static int getServerListeningPort() {
        return serverListeningPort;
    }

    private static void setServerListeningPort(int serverListeningPort) {
        LOGGER.info("HandShakeServer listening port :: " + serverListeningPort);
        HandShakeServer.serverListeningPort = serverListeningPort;
    }

    static long getServerStartedTime() {
        return serverStartedTime;
    }

    static void setServerStartedTime(long serverStartedTime) {
        HandShakeServer.serverStartedTime = serverStartedTime;
    }

    static List<HandShakeServerMessageHandler> getMessagehandlers() {
        return MESSAGE_HANDLERS;
    }
}

