/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.net.handshake;

import com.zoho.net.handshake.HandShakeClient;
import com.zoho.net.handshake.HandShakePacket;
import com.zoho.net.handshake.HandShakeServer;
import com.zoho.net.handshake.HandShakeServerMessageHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class HandShakeUtil {
    private static final String LOCALHOST = "localhost";
    private static int lockPort = -1;
    private static final ExecutorService SERVERPOOL = Executors.newFixedThreadPool(1);
    private static final Logger LOGGER = Logger.getLogger(HandShakeUtil.class.getName());
    private static final File LOCK_FILE = new File(".lock");

    public static void startHandShakeServer() throws IOException {
        if (!HandShakeUtil.isServerListening()) {
            SERVERPOOL.submit(new HandShakeServer());
            while (HandShakeServer.getServerStartedTime() == -1L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            SERVERPOOL.shutdownNow();
            throw new IOException("Already another HandShakeServer seems to be running");
        }
        LOGGER.info("Started HandShakeServer successfully.");
    }

    public static boolean isServerListening() {
        try {
            if (HandShakeUtil.isLockFileExist()) {
                int port = HandShakeUtil.getServerListeningPort();
                LOGGER.info("server listening port:: " + port);
                if (port != -1) {
                    return HandShakeUtil.isServerListening(LOCALHOST, port);
                }
                HandShakeUtil.deleteLockFile();
            }
            return Boolean.FALSE;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    protected static void deleteLockFile() {
        LOCK_FILE.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerListening(String hostName, int port) {
        try (HandShakeClient hsc = null;){
            boolean isRunning = HandShakeUtil.getStatus(new HandShakeClient(hostName, port));
            LOGGER.info("is HandShakeServer running :: " + isRunning);
            boolean bl = isRunning;
            return bl;
        }
    }

    public static HandShakeClient getHandShakeClient() {
        try {
            return HandShakeUtil.isLockFileExist() ? HandShakeUtil.getHandShakeClient(LOCALHOST, HandShakeUtil.getServerListeningPort()) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static HandShakeClient getHandShakeClient(String host) {
        try {
            return HandShakeUtil.getHandShakeClient(host, HandShakeUtil.getServerListeningPort());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static HandShakeClient getHandShakeClient(String hostName, int port) {
        try {
            return new HandShakeClient(hostName, port);
        }
        catch (IOException e) {
            LOGGER.warning("Unable to connect HandShakeServer :: " + e.getCause().getMessage() + " :: " + hostName + ":" + port);
            return null;
        }
    }

    public static boolean isLockFileExist() {
        return LOCK_FILE.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getServerListeningPort() throws IOException {
        lockPort = HandShakeServer.getServerListeningPort();
        if (lockPort == -1 && HandShakeUtil.isLockFileExist()) {
            try (BufferedReader br = null;){
                br = new BufferedReader(new FileReader(".lock"));
                String port = br.readLine();
                if (port == null) return lockPort;
                try {
                    lockPort = Integer.parseInt(port);
                    return lockPort;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Problem while reading port from .lock file :: fetched value [" + port + "]");
                }
            }
        } else {
            if (lockPort != -1) return lockPort;
            throw new IOException(".lock file does not exist");
        }
    }

    private static boolean getStatus(HandShakeClient hsc) {
        HandShakePacket pingMessage;
        try {
            pingMessage = hsc.getPingMessage("PING");
            LOGGER.info("HandShake response packet received from HandShakeServer.");
            LOGGER.info(pingMessage.toString());
        }
        catch (IOException e) {
            LOGGER.warning("Exception while get PING status, hence returning false. " + e.getMessage());
            return false;
        }
        catch (ClassNotFoundException e) {
            LOGGER.warning("Exception while get PING status, hence returning false. " + e.getMessage());
            return false;
        }
        LOGGER.info("Received response message :: " + pingMessage);
        return pingMessage != null ? pingMessage.getMessage().equals("ALIVE") : false;
    }

    public static long getServerStartedTime() {
        return HandShakeServer.getServerStartedTime();
    }

    public static void addMessageHandler(HandShakeServerMessageHandler handler) {
        HandShakeServer.addMessageHandler(handler);
    }

    public static long getHandShakeServerID() {
        return HandShakeUtil.getServerStartedTime();
    }
}

