/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.net.handshake;

import com.zoho.net.handshake.HandShakePacket;
import com.zoho.net.handshake.HandShakeServer;
import com.zoho.net.handshake.HandShakeServerMessageHandler;
import com.zoho.net.handshake.SendToClient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

class RecvFromClient
implements Callable<Boolean> {
    Socket sock;
    ObjectInputStream fromClient;
    SendToClient send;
    private static final Logger LOGGER = Logger.getLogger(HandShakeServer.class.getName());
    private static HandShakeServerMessageHandler responsedHandler = null;

    public RecvFromClient(Socket cs) {
        LOGGER.info("New HandShakeClient connection established");
        this.send = new SendToClient(cs);
        this.sock = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() {
        try {
            HandShakePacket packet = null;
            if (this.fromClient == null) {
                this.fromClient = new ObjectInputStream(this.sock.getInputStream());
            }
            while ((packet = (HandShakePacket)this.fromClient.readObject()) != null && !packet.getMessage().equalsIgnoreCase("bye")) {
                LOGGER.info("HandShake message received :: " + packet.getMessage());
                String responseMessage = HandShakeServer.getConfiguredResponseMessage(packet);
                if (responseMessage.equals("UNKNOWN_PING_MESSAGE")) {
                    responseMessage = RecvFromClient.getMessageFromHandler(packet);
                }
                this.send.reply(responseMessage, responsedHandler);
                responsedHandler = null;
            }
        }
        catch (Throwable e) {
            try {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    LOGGER.info("Closing HandShakeClient connection.");
                    this.fromClient.close();
                    this.sock.close();
                }
                catch (IOException iOException) {}
            }
        }
        try {
            LOGGER.info("Closing HandShakeClient connection.");
            this.fromClient.close();
            this.sock.close();
            return Boolean.TRUE;
        }
        catch (IOException e) {
            return Boolean.TRUE;
        }
    }

    static String getMessageFromHandler(HandShakePacket packetFromClient) {
        for (HandShakeServerMessageHandler handler : HandShakeServer.getMessagehandlers()) {
            String responseMessage = handler.getResponseMessage(packetFromClient);
            if (responseMessage == null || responseMessage.equals("UNKNOWN_PING_MESSAGE")) continue;
            responsedHandler = handler;
            return responseMessage;
        }
        return "UNKNOWN_PING_MESSAGE";
    }
}

