/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.net.handshake;

import com.zoho.net.handshake.HandShakeClient;
import com.zoho.net.handshake.HandShakePacket;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.logging.Logger;

class SendToServer {
    Socket sock;
    ObjectOutputStream toServ;
    private static final Logger LOGGER = Logger.getLogger(HandShakeClient.class.getName());

    protected SendToServer(Socket cs) throws IOException {
        this.sock = cs;
    }

    protected void sendMessage(String message) throws IOException {
        try {
            if (message != null) {
                if (this.toServ == null) {
                    this.toServ = new ObjectOutputStream(this.sock.getOutputStream());
                }
                LOGGER.info("Sending message to HandShakeServer");
                HandShakePacket packet = new HandShakePacket();
                packet.setResposeMessage(message);
                this.toServ.writeObject(packet);
                this.toServ.flush();
            }
        }
        catch (IOException e) {
            IOException ioException = new IOException("Exception while sending message to HandShakeServer!!!");
            ioException.initCause(e);
            throw ioException;
        }
    }

    protected void close() {
        try {
            this.toServ.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

