<#/*****************************PARAMETER SECTION STARTS*****************************/
param(
    [String] $serverName,
    [String] $databaseName,
    [String] $port,
    [String] $authentication,
    [String] $tableName,
    [String] $whereQuery,
	[String] $username,
    [String] $password    
)
/*****************************PARAMETER SECTION ENDS*****************************/#>

<#/*****************************FUNCTION SECTION STARTS*****************************/#>
# Function to construct Delete query
Function getDeleteQuery([String] $tableName, [String] $whereQuery) {
    try {
        $query = "DELETE FROM $tableName WHERE $whereQuery;"
        return $query
    } catch {
        Write-Host "Error in Creating the Deletion Query"
        Write-Host $_.Exception.Message 
        return ""
    }
}

<#/*****************************FUNCTION SECTION ENDS*****************************/#>

<#/*****************************MAIN SCRIPT SECTION STARTS*****************************/#>
try {

    #Getting the args
    $serverName = $args[0]
	$databaseName = $args[1]
	$port = $args[2]
	$authentication = $args[3]
	$tableName = $args[4]
    $whereQuery = $args[5]

    $username = $args[6];
	$password = $args[7];

    # Creating connection to DB server
    $conn = New-Object System.Data.SQLClient.SQLConnection
    if($authentication -eq "Windows") {
        # Windows authentication
        $conn.ConnectionString = "server='$serverName';database='$databaseName';trusted_connection=true;"
    } else {
        # SQL Server authentication
        $conn.ConnectionString = "server='tcp:$serverName,$port';authentication='Sql Password';database='$databaseName';trusted_connection=false;TrustServerCertificate=True"  
        $securePwd = ConvertTo-SecureString -String $password -AsPlainText -Force
        $securePwd.MakeReadOnly() 
        $cred = New-Object System.Data.SqlClient.SqlCredential -ArgumentList @($username, $securePwd)    
        $conn.Credential = $cred 
    }

    # Opening Connection to DB Server
    $conn.Open()

    # Creating command to execute query
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $conn

    # Constructing Query
    $query = getDeleteQuery $tableName $whereQuery
    
    if($query -ne "") {
      # Executing Query
      $Command.CommandText = $query
      $Command.ExecuteNonQuery()
    }
}catch {
    Write-Host $_.Exception.Message 
    $false
} finally {
    $conn.Close();
}
<#/*****************************MAIN SCRIPT SECTION ENDS*****************************/#>