<#/*****************************PARAMETER SECTION STARTS*****************************/
param(
    [String] $serverName,
    [String] $databaseName,
    [String] $port,
    [String] $authentication,
    [String] $tableName,
    [String] $columnNames,
    [String] $columnValues,
    [String] $whereQuery,
	[String] $username,
    [String] $password    
)
/*****************************PARAMETER SECTION ENDS*****************************/#>

<#/*****************************FUNCTION SECTION STARTS*****************************/#>
# Function to construct Update query
Function getUpdateQuery([String] $tableName, [String[]] $columnNames, [String[]] $columnValues, [String] $whereQuery) {
    try {
        $query = "UPDATE $tableName SET"
        For ($i=0; $i -lt $columnNames.Length; $i++) {
            $query += " " + $columnNames[$i] + " = " 
            if($columnValues[$i] -eq '') {
                $query += "null"
            } elseif($columnValues[$i] -like '^s.*') {
                $query += "'"+$columnValues[$i].substring(3)+"'";
            } else {
                $query += $columnValues[$i]
            }
            if($i -lt ($columnNames.Length - 1)){
			    $query += ", ";
            }
        }
        $query += " WHERE $whereQuery;"
        return $query
    } catch {
        Write-Host "Error in Creating the Updation Query"
        Write-Host $_.Exception.Message 
        return ""
    }
}

# Function to get Seperated values based on a seperator
Function getSeperatedValues([String] $string, [String] $separator) {
  return $string.Split($separator);
}

<#/*****************************FUNCTION SECTION ENDS*****************************/#>

<#/*****************************MAIN SCRIPT SECTION STARTS*****************************/#>
try {

    #Getting the args
    $serverName = $args[0]
	$databaseName = $args[1]
	$port = $args[2]
	$authentication = $args[3]
	$tableName = $args[4]
	$columnNames = $args[5]
	$columnValues = $args[6]
    $whereQuery = $args[7]

    $username = $args[8];
	$password = $args[9];

    # Creating connection to DB server
    $conn = New-Object System.Data.SQLClient.SQLConnection
    if($authentication -eq "Windows") {
        # Windows authentication
        $conn.ConnectionString = "server='$serverName';database='$databaseName';trusted_connection=true;"
    } else {
        # SQL Server authentication
        $conn.ConnectionString = "server='tcp:$serverName,$port';authentication='Sql Password';database='$databaseName';trusted_connection=false;TrustServerCertificate=True"  
        $securePwd = ConvertTo-SecureString -String $password -AsPlainText -Force
        $securePwd.MakeReadOnly() 
        $cred = New-Object System.Data.SqlClient.SqlCredential -ArgumentList @($username, $securePwd)    
        $conn.Credential = $cred 
    }

    # Opening Connection to DB Server
    $conn.Open()

    # Creating command to execute query
    $Command = New-Object System.Data.SQLClient.SQLCommand
    $Command.Connection = $conn

    # Processing Column Names and Column Values
    $columnNamesArr = getSeperatedValues $columnNames "|"
    $columnValuesArr = getSeperatedValues $columnValues '|'

    # Constructing Query
    $query = getUpdateQuery $tableName $columnNamesArr $columnValuesArr $whereQuery
    
    if($query -ne "") {
      # Executing Query
      $Command.CommandText = $query
      $Command.ExecuteNonQuery()
    }
}catch {
    Write-Host $_.Exception.Message 
    $false
} finally {
    $conn.Close();
}
<#/*****************************MAIN SCRIPT SECTION ENDS*****************************/#>