<#/*****************************PARAMETER SECTION STARTS*****************************/
param(
    [String] $hostId,
    [String] $port,
    [String] $username,
    [String] $password,
    [String] $serviceName,
    [String] $dbaPrivilege,
    [String] $tableName,
    [String] $columnNames,
    [String] $columnValues,
    [String] $whereQuery
)
/*****************************PARAMETER SECTION ENDS*****************************/#>

<#/*****************************FUNCTION SECTION STARTS*****************************/#>
# Function to construct Update query
Function getUpdateQuery([String] $tableName, [String[]] $columnNames, [String[]] $columnValues, [String] $whereQuery) {
    try {
        $query = "UPDATE $tableName SET"
        For ($i=0; $i -lt $columnNames.Length; $i++) {
            $query += " " + $columnNames[$i] + " = " 
            if($columnValues[$i] -eq '') {
                $query += "null"
            } elseif($columnValues[$i] -like '^s.*') {
                $query += "'"+$columnValues[$i].substring(3)+"'";
            } else {
                $query += $columnValues[$i]
            }
            if($i -lt ($columnNames.Length - 1)){
			    $query += ", ";
            }
        }
        $query += " WHERE $whereQuery;"
        return $query
    } catch {
        Write-Host "Error in Creating the Updation Query"
        Write-Host $_.Exception.Message 
        return ""
    }
}
  
# Function to get Seperated values based on a seperator
Function getSeperatedValues([String] $string, [String] $separator) {
    return $string.Split($separator);
}

<#/*****************************FUNCTION SECTION ENDS*****************************/#>

<#/*****************************MAIN SCRIPT SECTION STARTS*****************************/#>
try {

    #Getting the args
    $hostId = $args[0]
    $port = $args[1]
    $username = $args[2]
    $password = $args[3]
    $serviceName = $args[4]
    $dbaPrivilege = $args[5]
    $tableName = $args[6]
    $columnNames = $args[7]
    $columnValues = $args[8]
    $whereQuery = $args[9]

    #Load Required Types and modules
    Add-Type -Path "..\bin\Oracle.DataAccess.dll"

    #The oracle DataSource as you would compile it in TNSNAMES.ORA
    $datasource = " (DESCRIPTION = 
                    (ADDRESS = 
                    (PROTOCOL = TCP)
                    (HOST  = $hostId)(PORT = $port))
                    (CONNECT_DATA = (SERVER =  DEDICATED)
                    (SERVICE_NAME = $serviceName)
                    (FAILOVER_MODE = (TYPE = SELECT)
                    (METHOD =  BASIC)
                    (RETRIES = 180)
                    (DELAY = 5))))"
    
    #Create the connection string
    $connectionString = 'User Id=' + $username + ';Password=' + $password + ';Data Source=' + $datasource + ';DBA PRIVILEGE=' + $dbaPrivilege

    #Create the connection object
    $Conn = New-Object Oracle.DataAccess.Client.OracleConnection($connectionString)

    $Conn.Open()

    $Command = $Conn.CreateCommand();

    # Processing Column Names and Column Values
    $columnNamesArr = getSeperatedValues $columnNames "|"
    $columnValuesArr = getSeperatedValues $columnValues "|"

    # Constructing Query
    $query = getUpdateQuery $tableName $columnNamesArr $columnValuesArr $whereQuery
    
    if($query -ne "") {
      # Executing Query
      $Command.CommandText = $query
      $Command.ExecuteNonQuery()
    }
}catch {
    Write-Host $_.Exception.Message 
    $false
} finally {
    $Conn.Close();
}

<#/*****************************MAIN SCRIPT SECTION ENDS*****************************/#>