//$Id$

/**
 * 
 */
package com.manageengine.eum.mail.datacollection;

/**
 * @author sabarinathan
 *
 */


import java.io.File;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.apache.commons.io.FileUtils;
import org.apache.commons.net.smtp.SMTPClient;
import org.apache.commons.net.smtp.SMTPReply;

import com.manageengine.eum.agent.dcframework.dcinterfaces.DataCollectorInterface;
import com.manageengine.eum.agent.dcframework.dcinterfaces.DiscoveryInterface;
import com.manageengine.eum.agent.util.ObjectHolder;
import com.manageengine.eum.util.Constants;
import com.manageengine.eum.util.EUMLog;
import com.manageengine.eum.util.NetworkSanityChecker;
import com.manageengine.eum.util.Util;

public class SMTPDataCollector implements DataCollectorInterface,DiscoveryInterface
{
	private String module= "COMMONDC";//NO I18N

	private String smtpId = "0";
	private Long collectionTime=0L;
	private Long locationId=0L;
	private String monitorType = Constants.SMTP;

	private String smtpHost="";
	private int smtpPort=25;
	private int smtpSslPort=465;
	private boolean sslEnabled=false;
	TrustManager[] trustAllCerts = null ;
	private boolean authenticationRequired=false;
	private boolean tlsEnabled = false;
	private boolean fetchEnabled=false;
	//private String serverHome = "/home/local/ZOHOCORP/laxmikanth-0584/Site24x7/Today/AdventNet/Sas/tomcat/webapps/ROOT/WEB-INF/";//NO I18N
	private String serverHome = "";//NO I18N
	private String userName="";
	private String password="";
	private String fromEmailId="noreply@manageengine.com"; //No I18N
	private String toEmailId="user@manageengine.com"; //No I18N
	private String mailSubject="Site24x7 - Testing Mail Server"; //No I18N
	private String testMesg="Test Message"; //No I18N
	private int timeOut=30;
	private int fetchType = Constants.TYPE_POP;

	private String xmlResponse = null;

	private Long startTime=null;
	private Long smtpRespTime=null;
	private int availability = Constants.UNAVAILABLE;
	private int errorCode = Constants.DC_GENERIC_EXCEPTION;
	private String reason = "";
	private String sentFrom = "";

	private String mailHost = "zohomonitor.com"; //No I18N
	private String resolvedip ="";

	private Boolean troubleStatus = false;
	private StringBuffer problemIPs=new StringBuffer();

	private boolean isDiscovery =false;

	private String attachmentsFolder = ""; //NO I18N
	private boolean sendFileAttachment = false;
	private String attachmentFileName = "Site24x7_Testing_Mail_Server.txt"; //No I18N
	private long attachmentFileSize = 0;

	public SMTPDataCollector()
	{
		EUMLog.log(module, smtpId+" MailServer Instance Called");
	}

	public HashMap discover(Hashtable config) {
		isDiscovery  =true;
		return startDatacollection(config) ;
	}
	public HashMap startDatacollection(Hashtable config) 
	{
		try
		{
			EUMLog.log(module, "[ Mail Server ] [ DC Called ] ");
			setProperties(config);
			collectionTime = System.currentTimeMillis();
			doDataCollection();
			/* ObjectHolder.isSite24x7() check has done to ensure AppManager compatible EUMAgent doesn't perform NetworkSanityCheck. */
			if(ObjectHolder.isSite24x7())
			{
				if(availability==Constants.UNAVAILABLE && String.valueOf(errorCode).matches(Constants.DC_S247_CONNECTION_ERRORS) && !NetworkSanityChecker.getInstance().isNetworkAvailable())
				{
					errorCode=Constants.DC_S247_NETWORK_ERROR;
				}else if(!String.valueOf(errorCode).matches(Constants.DC_S247_CONNECTION_ERRORS) && !NetworkSanityChecker.getInstance().checkLocalService(smtpHost)){
					NetworkSanityChecker.getInstance().notifyNetworkUp();
				}
			}
			return getReponseHashMap();
		}
		catch(Exception e)
		{
			EUMLog.log(module, smtpId+" : Exception occured in MailserverDataCollector/startDatacollection"+e); //No I18N
			EUMLog.log(module, Util.getStackTrace(e));
		}
		return null;
	}

	public void setProperties(Hashtable config) 
	{
		try
		{
			if(config.get("testing")!=null && config.get("serverHome")!=null)
			{
				if(Util.trim(Util.getProperty(config, "testing","")).equals("true") && Util.trim(Util.getProperty(config, "serverHome","")).length()>0)
				{
					serverHome = Util.trim(Util.getProperty(config, "serverHome",serverHome));//No I18N
				}
			}
			else
			{
				try
				{
					serverHome = new File(System.getProperty("eum.home")).getCanonicalPath();
				}
				catch(Exception e)
				{
					EUMLog.log(module, "Exception while get the ServerHome");
				}
			}
			attachmentsFolder = serverHome+File.separator+"ftp-downloads"+File.separator;//No I18N
			smtpId = Util.getProperty(config,"mid",""+smtpId); //No I18N
			//collectionTime = Long.parseLong(Util.getProperty(config,"ut",""+collectionTime)); //No I18N
			locationId = Long.parseLong(Util.getProperty(config,"locid",""+locationId)); //No I18N

			EUMLog.log(module, smtpId+" : ifig Received in Location("+locationId+") : "+config.keySet());//No I18N

			monitorType = Util.getProperty(config,"mt",""+monitorType); //No I18N

			smtpHost=(Util.getProperty(config,"a",""+smtpHost)); //No I18N
			smtpPort=Integer.parseInt(Util.getProperty(config,"port",""+smtpPort)); //No I18N
			smtpSslPort=Integer.parseInt(Util.getProperty(config,"sslPort",""+smtpSslPort)); //No I18N

			String tempVal=(Util.getProperty(config,"sslEnabled","false")); //No I18N
			if(tempVal.equalsIgnoreCase("true"))
			{
				sslEnabled = true;
			}
			tempVal=(Util.getProperty(config,"authRequired",""+authenticationRequired)); //No I18N
			if(tempVal.equalsIgnoreCase("true"))
			{
				authenticationRequired = true;
			}
			tempVal=(Util.getProperty(config,"tlsEnabled",""+tlsEnabled)); //No I18N
			if(tempVal.equalsIgnoreCase("true"))
			{
				tlsEnabled = true;
			} 
			tempVal=(Util.getProperty(config,"fetchEnabled",""+fetchEnabled)); //No I18N
			if(tempVal.equalsIgnoreCase("true"))
			{
				fetchEnabled = true;
			}

			tempVal=(Util.getProperty(config,"sendFileAttachment",""+sendFileAttachment)); //No I18N
			if(tempVal.equalsIgnoreCase("true"))
			{
				sendFileAttachment = true;
				attachmentFileName = (Util.getProperty(config,"attachmentFileName",""+attachmentFileName)); //No I18N
			}

			fetchType = Integer.parseInt(Util.getProperty(config,"fetchType",""+fetchType)); //No I18N
			userName=(Util.getProperty(config,"userName",""+userName)); //No I18N
			password=(Util.getProperty(config,"password",""+password)); //No I18N
			toEmailId=(Util.getProperty(config,"toEmailId",""+toEmailId)); //No I18N
			fromEmailId=(Util.getProperty(config,"fromEmailId",""+toEmailId)); //No I18N
			mailSubject=(Util.getProperty(config,"mailSubject",""+mailSubject)); //No I18N				
			testMesg=(Util.getProperty(config,"testMesg",""+testMesg)); //No I18N
			String includeAgentInfo = System.getProperty("testmail.agentinfo");
			if(includeAgentInfo!=null && includeAgentInfo.equals("true"))
			{
				mailSubject = mailSubject + " - "+ObjectHolder.getAgentName();//No I18N		
				testMesg = testMesg + " - Sent from "+ObjectHolder.getAgentName()+" / "+ObjectHolder.getAgentIP();//No I18N		
			}
			timeOut=Integer.parseInt(Util.getProperty(config,"t",""+timeOut)); //No I18N
			mailHost=(Util.getProperty(config,"mailHost",""+mailHost)); //No I18N
		}
		catch(Exception e)
		{
			EUMLog.log(module, smtpId+" : Exception occured in MailserverDataCollector/setProperties(String configxml) :"+e); //No I18N
			EUMLog.log(module, Util.getStackTrace(e));
		}
	}

	public void doDataCollection() 
	{
		Constants.smtpDataCollectorCount++;
		try
		{						
			ArrayList<String> inetAddresses = getMailHostsArray();
			if(inetAddresses.size()<=0)
			{
				this.errorCode = Constants.DC_UNKOWNHOST_ERR;
				return;
			}
			if(mailHost==null || (mailHost!=null && mailHost.equals("")))
			{
				mailHost = "zohomonitor.com"; //No I18N
			}
			System.setProperty("mail.smtp.localhost", mailHost);

			if(fetchEnabled)
			{
				EUMLog.log("inside fetchEnabled true");
				for(int i=0;i<inetAddresses.size();i++)
				{
					if(availability==Constants.UNAVAILABLE)
					{
						if(smtpRespTime!=null)
						{
							startTime=System.currentTimeMillis();
						}
						try
						{
							HashMap<Object, Object> smtpProps = new HashMap<Object, Object>();
							smtpProps.put("hostName", inetAddresses.get(i));
							smtpProps.put("sslEnabled", sslEnabled);
							smtpProps.put("smtpSslPort", smtpSslPort);
							smtpProps.put("smtpPort", smtpPort);
							smtpProps.put("authenticationRequired", authenticationRequired);
							smtpProps.put("userName", userName);
							smtpProps.put("password", password);
							smtpProps.put("timeOut", timeOut);
							smtpProps.put("tlsEnabled", tlsEnabled);
							smtpProps.put("fromEmailId", fromEmailId);
							smtpProps.put("toEmailId", toEmailId);
							smtpProps.put("mailSubject", mailSubject);
							smtpProps.put("testMesg", testMesg);
							smtpProps.put("startTime", startTime);
							smtpProps.put("smtpRespTime", smtpRespTime);
							smtpProps.put("smtpId", smtpId);
							smtpProps.put("errorCode", errorCode);
							smtpProps.put("availability", availability);
							smtpProps.put("sentFrom", sentFrom);
							smtpProps.put("reason", reason);
							smtpProps.put("troubleStatus", troubleStatus);

							smtpProps.put("sendFileAttachment", sendFileAttachment);//NO I18N
							smtpProps.put("attachmentFileName", attachmentFileName);//NO I18N
							smtpProps.put("attachmentsFolder", attachmentsFolder);//NO I18N

							SMTPWorkerThread thread = new SMTPWorkerThread(smtpProps);
							EUMLog.log(module, smtpId+"-@@@@@@@@@@@@@- SMTP Thread Start Time - "+new java.util.Date(System.currentTimeMillis()));
							thread.start();
							thread.join(3*60*1000);
							thread.interrupt();
							EUMLog.log(module, smtpId+"-@@@@@@@@@@@@@- SMTP Thread End Time - "+new java.util.Date(System.currentTimeMillis()));

							smtpProps = thread.getDcValues();

							sslEnabled =  (Boolean)smtpProps.get("sslEnabled");
							smtpSslPort = (Integer)smtpProps.get("smtpSslPort");
							smtpPort = (Integer)smtpProps.get("smtpPort");
							authenticationRequired =  (Boolean)smtpProps.get("authenticationRequired");
							userName = (String)smtpProps.get("userName");
							password = (String)smtpProps.get("password");
							timeOut = (Integer)smtpProps.get("timeOut");
							tlsEnabled =  (Boolean)smtpProps.get("tlsEnabled");
							fromEmailId = (String)smtpProps.get("fromEmailId");
							toEmailId = (String)smtpProps.get("toEmailId");
							mailSubject = (String)smtpProps.get("mailSubject");
							testMesg = (String)smtpProps.get("testMesg");
							startTime = (Long)smtpProps.get("startTime");
							smtpRespTime = (Long)smtpProps.get("smtpRespTime");
							smtpId = (String)smtpProps.get("smtpId");
							errorCode = (Integer)smtpProps.get("errorCode");
							availability = (Integer)smtpProps.get("availability");
							sentFrom = (String)smtpProps.get("sentFrom");
							reason = (String)smtpProps.get("reason");
							troubleStatus =  (Boolean)smtpProps.get("troubleStatus");

							attachmentFileSize = (Long) smtpProps.get("attachmentFileSize"); //NO I18N
						}
						catch(Exception e)
						{
							this.errorCode = Constants.DC_EXCEPTION_ERR;
							EUMLog.log(module, smtpId+" : Exception occured in MailserverDataCollector/doDataCollection()/CatchBlock"+e); //No I18N
							EUMLog.log(module, Util.getStackTrace(e));
						}
					}
					else
					{
						doSMTPCheck(inetAddresses.get(i));
					}
				}
			}
			else
			{
				EUMLog.log("inside fetchEnabled false");
				if(sslEnabled)
				{
					trustAllCerts = new TrustManager[]
							{
							new X509TrustManager() 
							{
								public java.security.cert.X509Certificate[] getAcceptedIssuers() 
								{
									return new X509Certificate[0];
								}
								public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException 
								{
								}

								public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException 
								{
								}
							}
							};
				}

				for(int i=0;i<inetAddresses.size();i++)
				{
					doSMTPCheck(inetAddresses.get(i));
				}
			}
		}
		catch (Exception e) 
		{
			EUMLog.log(module,Util.getStackTrace(e));
		}
		finally
		{
			Constants.smtpDataCollectorCount--;
		}
	}

	public String getResponseInXml() 
	{
		try
		{
			xmlResponse="<?xml version=\"1.0\" standalone=\"no\"?>" //No I18N
					+"\n<DC mid=\"URLID_VALUE\" " //No I18N
					+"availability=\"AVAILABILITY\" " //No I18N
					+"script_availability=\""+((availability==1) ? 0 : 1)+"\" " //No I18N
					+"smtpRespTime=\""+smtpRespTime+"\" " //No I18N

					+"script_message=\""+Util.getApmErrKey(this.errorCode)+"\" " //No I18N
					+"script_responsetime=\""+Util.parseLong(""+smtpRespTime,-1l)+"\" " //No I18N
					+"error_code=\"ERROR_CODE\" " //No I18N
					+"reason=\"REASON\" " //No I18N
					+"locid=\"LOCATION_ID\" " //No I18N
					+"trouble_status=\"TROUBLE_STATUS\" " //No I18N
					+"resolvedip=\"RESOLVED_IP\" " //No I18N
					+"ct=\""+collectionTime+"\" " //No I18N
					+"errIPs=\"PROBLEM_IP\" " ;//No I18N
			if(isDiscovery)
			{
				xmlResponse = xmlResponse  + " discovery=\"true\" ";//No I18N
			}

			xmlResponse += "sendFileAttachment=\""+sendFileAttachment+"\" " ;//No I18N
			if(sendFileAttachment)
			{
				xmlResponse += "attachmentFileName=\""+attachmentFileName+"\" " ;//No I18N
				xmlResponse += "attachmentFileSize=\""+attachmentFileSize+"\" " ;//No I18N
			}

			xmlResponse = xmlResponse  + "dcstatus=\"1\" "//No I18N
					+">" //No I18N
					+"\n</DC>";  //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "URLID_VALUE", Util.escapeXML(String.valueOf(smtpId))); //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "AVAILABILITY", Util.escapeXML(String.valueOf(availability))); //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "ERROR_CODE", Util.escapeXML(String.valueOf(errorCode))); //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "RESOLVED_IP", Util.escapeXML(String.valueOf(resolvedip))); //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "PROBLEM_IP", Util.escapeXML(problemIPs.toString())); //No I18N
			if(reason.startsWith("<BR>"))
			{
				reason = reason.replaceFirst("<BR>", ""); //No I18N
			}
			if(Constants.AVAILABLE==availability && troubleStatus)
			{
				reason = reason+"<BR>"+sentFrom; //No I18N
			}
			xmlResponse = Util.findReplace(xmlResponse, "REASON", Util.escapeXML(String.valueOf(reason))); //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "LOCATION_ID", Util.escapeXML(String.valueOf(locationId))); //No I18N
			xmlResponse = Util.findReplace(xmlResponse, "TROUBLE_STATUS", Util.escapeXML(String.valueOf(troubleStatus.toString()))); //No I18N

			EUMLog.log(module, smtpId+" : SMTP Response in XML : "+xmlResponse);//No I18N

			return xmlResponse;
		}
		catch(Exception e)
		{
			EUMLog.log(module, smtpId+" : Exception occured in MailserverDataCollector/getReponseInXml() - "+e); //No I18N
			EUMLog.log(module, Util.getStackTrace(e));
		}
		return null;
	}

	public HashMap getReponseHashMap() 
	{
		HashMap rep = new HashMap();
		rep.put("xmlResponse", getResponseInXml());
		rep.put("smtpRespTime", ""+smtpRespTime);
		rep.put("availability", availability);
		EUMLog.log(module, smtpId+" Mail Server Output : "+rep);
		return rep;
	}

	public ArrayList<String> getMailHostsArray()
	{
		ArrayList<String> addressList = new ArrayList<String>();
		try
		{
			InetAddress[] inetAddresses = InetAddress.getAllByName(smtpHost);
			for(int i=0; i<inetAddresses.length; i++)
			{
				String ip = inetAddresses[i].getHostAddress();
				if(!addressList.contains(ip))
				{
					addressList.add(ip);
					if(resolvedip.length()<=0)
					{
						resolvedip = ip;
					}
					else
					{
						resolvedip = resolvedip+", "+ip;//No I18N
					}
				}
			}
		}
		catch(Exception e)
		{
			EUMLog.log(module, smtpId+" : Exception occured while getting InetAddressList");
			EUMLog.log(module, Util.getStackTrace(e));
		}
		return addressList;
	}

	public void doSMTPCheck(String host)
	{
		try
		{
			if(smtpRespTime==null)
			{
				startTime=System.currentTimeMillis();
			}
			SMTPClient client=new SMTPClient();

			client.setConnectTimeout(timeOut*1000);

			client.setDefaultTimeout(timeOut*1000);

			if(sslEnabled && trustAllCerts!=null)
			{
				// Install the all-trusting trust manager
				try 
				{
					SSLContext sc = SSLContext.getInstance("SSL");
					sc.init(null, trustAllCerts, new java.security.SecureRandom());
					client.setSocketFactory(sc.getSocketFactory());
				} 
				catch (Exception e) 
				{
					EUMLog.log(module, smtpId+" - " +e.getMessage());
					EUMLog.log(module, smtpId+" : "+Util.getStackTrace(e));
				}
			}
			client.connect(host,(new Long(smtpPort)).intValue());

			EUMLog.log(module, smtpId+" getting reply "+client.getReplyString());
			int reply = client.getReplyCode();
			if(!SMTPReply.isPositiveCompletion(reply)) 
			{
				client.disconnect();
				availability = Constants.UNAVAILABLE;
				errorCode=reply;
				reason=reason+"<BR>"+smtpHost+"("+host+")"+ " : SMTP server refused connection."; //No I18N
				EUMLog.log(module, smtpId+" : SMTP server refused connection.");
			}
			else
			{
				if(smtpRespTime==null)
				{
					smtpRespTime=System.currentTimeMillis()-startTime;
				}
				EUMLog.log(module, smtpId+" : Mail Sever successfully Tested with "+fromEmailId); //No I18N
				this.errorCode=0;
				availability = Constants.AVAILABLE;
				sentFrom = "Mail Tested from - "+host; //No I18N
			}
		}
		catch(Exception e)   
		{
			String e1 =  Util.getStackTrace(e);
			EUMLog.log(module, "-----------------------------"+smtpId+"---------------------------------"); //No I18N
			EUMLog.log(module, e1);
			EUMLog.log(module, "------------------------------------------------------------------------"); //No I18N

			if(e1.contains("UnknownHostException")) //No I18N
			{
				this.errorCode = Constants.DC_UNKOWNHOST_ERR;
				reason = reason+"<BR>Unknown Host - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
			else if(e1.contains("Connection refused")) //No I18N
			{
				this.errorCode = Constants.DC_CONNECTION_REFUSED;
				reason = reason+"<BR>Connection Refused - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
			else if(e1.contains("Could not connect to SMTP host") && !e1.contains("Connection timed out")) //No I18N
			{
				this.errorCode = Constants.DC_CONNECT_ERR;
				reason = reason+"<BR>Unable to connect - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
			else if(e1.contains("Connection timed out") || e1.contains("SocketTimeoutException"))//No I18N
			{
				this.errorCode = Constants.DC_TIMEOUT;
				reason = reason+"<BR>Connection TimeOut - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
			else if(e1.contains("Network is unreachable")) //No I18N
			{
				this.errorCode = Constants.DC_NETWORK_UNREACHABLE;
				reason = reason+"<BR>Network is Unreachable - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
			else if(e1.contains("Connection closed"))
			{
				this.errorCode = Constants.SMTP_CONNECTION_CLOSED;
				reason = reason+"<BR>Connection closed by SMTP server - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
			else
			{
				this.errorCode = Constants.DC_EXCEPTION_ERR;
				reason = reason+"<BR>Unable to connect to the SMTP server - "+host; //No I18N
				troubleStatus = true;
				problemIPs.append(host);
				problemIPs.append("#"+errorCode);
				problemIPs.append(",");
			}
		}
	}
}

class SMTPWorkerThread extends Thread
{
	private String module="MAIL"; //No I18N

	private String hostName = null;
	private boolean sslEnabled = false;
	private int smtpSslPort = 465;
	private int smtpPort = 25;
	private boolean authenticationRequired = false;
	private String userName = null;
	private String password = null;
	private int timeOut = 30;
	private boolean tlsEnabled = false;
	private String fromEmailId = null;
	private String toEmailId = null;
	private String mailSubject = null;
	private String testMesg = null;
	private Long startTime=null;
	private Long smtpRespTime=null;
	private String smtpId=null;
	private int threadErrorCode = Constants.DC_EXCEPTION_ERR;
	private int availability = Constants.UNAVAILABLE;
	private String sentFrom = null;
	private String reason = "";
	private boolean troubleStatus = false;
	private StringBuffer problemIPs=new StringBuffer();

	private boolean sendFileAttachment=false;
	private String attachmentFileName = "Site24x7_Testing_Mail_Server.txt"; //No I18N
	private String attachmentsFolder = ""; //No I18N
	private long attachmentFileSize = 0;

	public SMTPWorkerThread(HashMap<Object, Object> smtpProps)
	{
		hostName = (String)smtpProps.get("hostName");
		sslEnabled =  (Boolean)smtpProps.get("sslEnabled");
		smtpSslPort = (Integer)smtpProps.get("smtpSslPort");
		smtpPort = (Integer)smtpProps.get("smtpPort");
		authenticationRequired =  (Boolean)smtpProps.get("authenticationRequired");
		userName = (String)smtpProps.get("userName");
		password = (String)smtpProps.get("password");
		timeOut = (Integer)smtpProps.get("timeOut");
		tlsEnabled =  (Boolean)smtpProps.get("tlsEnabled");
		fromEmailId = (String)smtpProps.get("fromEmailId");
		toEmailId = (String)smtpProps.get("toEmailId");
		mailSubject = (String)smtpProps.get("mailSubject");
		testMesg = (String)smtpProps.get("testMesg");
		startTime = (Long)smtpProps.get("startTime");
		smtpRespTime = (Long)smtpProps.get("smtpRespTime");
		smtpId = (String)smtpProps.get("smtpId");
		threadErrorCode = (Integer)smtpProps.get("errorCode");
		availability = (Integer)smtpProps.get("availability");
		sentFrom = (String)smtpProps.get("sentFrom");
		reason = (String)smtpProps.get("reason");
		troubleStatus =  (Boolean)smtpProps.get("troubleStatus");

		sendFileAttachment =  (Boolean)smtpProps.get("sendFileAttachment"); //NO I18N
		attachmentFileName = (String)smtpProps.get("attachmentFileName"); //NO I18N
		attachmentsFolder = (String)smtpProps.get("attachmentsFolder"); //NO I18N
	}

	public HashMap<Object, Object> getDcValues()
	{
		HashMap<Object, Object> smtpProps = new HashMap<Object, Object>();
		smtpProps.put("hostName", hostName);
		smtpProps.put("sslEnabled", sslEnabled);
		smtpProps.put("smtpSslPort", smtpSslPort);
		smtpProps.put("smtpPort", smtpPort);
		smtpProps.put("authenticationRequired", authenticationRequired);
		smtpProps.put("userName", userName);
		smtpProps.put("password", password);
		smtpProps.put("timeOut", timeOut);
		smtpProps.put("tlsEnabled", tlsEnabled);
		smtpProps.put("sendFileAttachment", sendFileAttachment);
		smtpProps.put("fromEmailId", fromEmailId);
		smtpProps.put("toEmailId", toEmailId);
		smtpProps.put("mailSubject", mailSubject);
		smtpProps.put("testMesg", testMesg);
		smtpProps.put("startTime", startTime);
		smtpProps.put("smtpRespTime", smtpRespTime);
		smtpProps.put("smtpId", smtpId);
		smtpProps.put("errorCode", threadErrorCode);
		smtpProps.put("availability", availability);
		smtpProps.put("sentFrom", sentFrom);
		smtpProps.put("reason", reason);
		smtpProps.put("troubleStatus", troubleStatus);

		smtpProps.put("attachmentFileSize", attachmentFileSize); //NO I18N
		return smtpProps;
	}

	public void run()
	{
		Constants.smtpWorkerThreadCount++;
		try
		{
			String mailProtocol = sslEnabled ? "smtps" : "smtp"; //NO I18N
			int mailPort = sslEnabled ? smtpSslPort : smtpPort;
			EUMLog.log("sslEnabled in run : "+sslEnabled);
			Properties mailProps = new Properties();
			mailProps.put("mail."+mailProtocol+".host", hostName);
			mailProps.put("mail."+mailProtocol+".port", mailPort);
			mailProps.put("mail.debug", "true");
			mailProps.put("mail."+mailProtocol+".timeout", timeOut*1000);
			mailProps.put("mail."+mailProtocol+".connectiontimeout", timeOut*1000);

			if (authenticationRequired) 
			{
				mailProps.put("mail."+mailProtocol+".auth", "true");
			}

			if(tlsEnabled)
			{
				mailProps.put("mail."+mailProtocol+".user", hostName);
				mailProps.put("mail."+mailProtocol+".starttls.enable", "true");
				mailProps.put("mail."+mailProtocol+".socketFactory.port", String.valueOf(smtpSslPort));
				if(sslEnabled)
				{
					mailProps.put("mail."+mailProtocol+".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
				}
				mailProps.put("mail."+mailProtocol+".socketFactory.fallback", "false");
			}

			if(sslEnabled)
			{
				mailProps.setProperty( "mail.smtps.socketFactory.class", "com.manageengine.eum.util.DummySSLSocketFactory");
			}

			//EUMLog.log(module, smtpId+" : MailProps before getting session : "+mailProps);

			Session mailSession = Session.getInstance(mailProps);
			mailSession.setDebug(true);

			//EUMLog.log(module, smtpId+" : MailProps after getting session : "+mailSession.getProperties());

			Transport transport =  mailSession.getTransport(mailProtocol);
			MimeMessage message = new MimeMessage(mailSession);
			message.setSubject(mailSubject);

			message.setContent(testMesg, "text/plain"); //NO I18N

			String fileName = attachmentsFolder+File.separator+attachmentFileName;
			if(sendFileAttachment)
			{
				try
				{
					EUMLog.log(module, smtpId+" : fileName=" + fileName +" ,orig=" + (attachmentsFolder+File.separator+"mailserver-test.txt"));
					File file = new File(fileName);
					attachmentFileSize = file.length();
					FileUtils.copyFile(new File(attachmentsFolder+File.separator+"mailserver-test.txt"), file); //NO I18N
				}
				catch(Exception e)
				{
					EUMLog.log(module, smtpId+" : Excep=" + Util.getStackTrace(e));
				}

				Multipart multipart = new MimeMultipart();

				//message content
				BodyPart messageBodyPart = new MimeBodyPart();
				messageBodyPart.setText(testMesg);
				multipart.addBodyPart(messageBodyPart);

				//Attach file
				BodyPart fileAttachmentPart = new MimeBodyPart();
				DataSource source = new FileDataSource(fileName);
				fileAttachmentPart.setDataHandler(new DataHandler(source));
				fileAttachmentPart.setFileName(attachmentFileName);
				multipart.addBodyPart(fileAttachmentPart);

				message.setContent(multipart);
			}

			message.setFrom(new InternetAddress(fromEmailId));
			message.addRecipient(Message.RecipientType.TO,new InternetAddress(toEmailId));
			
			 /**
			  * Ticket id : #4615921
			  * Issue fixed for establishing connection when SMTP server doesn't have authentication.
			  * 
			  * Issue: It assumes to have authentication when the Username and Password is an empty string (note that it is not null)
			  * Fix: So calling the connect() method, which takes the Username and password as empty string and fixes the issue
			  */
			EUMLog.log(module, smtpId+" :Entering the patch block"); //NO I18N

			if(!"".equals(userName) && !"".equals(password)){ //NO I18N
				EUMLog.log(module, smtpId+" :Entering non empty auth block"); //NO I18N
				transport.connect(hostName, smtpPort, userName, password);
			} else {
				EUMLog.log(module, smtpId+" :Running through the empty function call"); //NO I18N
				transport.connect();
			}
			/**
			 * End of fix for #4615921
			 */
			
			startTime=System.currentTimeMillis();
			transport.sendMessage(message,message.getRecipients(Message.RecipientType.TO));
			transport.close();
			if(smtpRespTime==null)
			{
				smtpRespTime=System.currentTimeMillis()-startTime;
			}
			if(sendFileAttachment)
			{
				try
				{
					new File(fileName).delete();
				}
				catch(Exception e)
				{
					EUMLog.log(module, smtpId+" :attachment file delete exception=" + e); //NO I18N
				}
			}
			EUMLog.log(module, smtpId+" : Mail Sent successfully sucessfully from "+fromEmailId+" to "+toEmailId+" with the following subject - "+mailSubject); //No I18N
			this.threadErrorCode=0;
			availability = Constants.AVAILABLE;
			sentFrom = "Mail sent from - "+hostName; //No I18N
		}
		catch(Exception e)
		{
			availability = Constants.UNAVAILABLE;
			EUMLog.log(module, smtpId+" : Exception occured in MailserverDataCollector/doDataCollection() :"+e); //No I18N
			try
			{
				String e1 =  Util.getStackTrace(e);
				EUMLog.log(module, "-----------------------------"+smtpId+"---------------------------------"); //No I18N
				EUMLog.log(module, e1);
				EUMLog.log(module, "------------------------------------------------------------------------"); //No I18N

				EUMLog.log("Exception type is : "+e.getCause());
				/**
				 *  Throwable is null if the exception is javax.mail.AuthenticationFailedException.
				 *  String match is used by removing "e.getCause() instanceof AuthenticationFailedException" code snippet.
				 *   
				 */

				if(e1.contains("AuthenticationFailedException"))
				{
					this.threadErrorCode = Constants.DC_AUTHENTICATION_FAILED;
				}
				else if(e1.contains("UnknownHostException")) //No I18N
				{
					//If unable to reach the provided server
					this.threadErrorCode = Constants.DC_UNKOWNHOST_ERR;
					reason = reason+"<BR>UnknownHost - "+hostName; //No I18N
					troubleStatus = true;
					problemIPs.append(hostName);
					problemIPs.append("#"+threadErrorCode);
					problemIPs.append(",");
				}
				else if(e1.contains("Connection refused")) //No I18N
				{
					//If unable to connect to the  provided port
					this.threadErrorCode = Constants.DC_CONNECTION_REFUSED;
					reason = reason+"<BR>Connection Refused - "+hostName; //No I18N
					troubleStatus = true;
					problemIPs.append(hostName);
					problemIPs.append("#"+threadErrorCode);
					problemIPs.append(",");
				}
				else if(e1.contains("Could not connect to SMTP host") && !e1.contains("Connection timed out")) //No I18N
				{
					//If provided server is not a SMTP server
					this.threadErrorCode = Constants.DC_CONNECT_ERR;
					reason = reason+"<BR>Unable to connect to - "+hostName; //No I18N
					troubleStatus = true;
					problemIPs.append(hostName);
					problemIPs.append("#"+threadErrorCode);
					problemIPs.append(",");
				}
				else if(e1.contains("Connection timed out") || e1.contains("connect timed out") || e1.contains("SocketTimeoutException"))//No I18N
				{
					//If connection restricted
					this.threadErrorCode = Constants.DC_TIMEOUT;
					reason = reason+"<BR>Connection TimeOut - "+hostName; //No I18N
					troubleStatus = true;
					problemIPs.append(hostName);
					problemIPs.append("#"+threadErrorCode);
					problemIPs.append(",");
				}
				else if(e1.contains("authentication required")|| e1.contains("USER NOT AUTHENTICATED") || e1.contains("Client was not authenticated")) //No I18N
				{
					//If Authentication Required for sending mails
					this.threadErrorCode = Constants.DC_AUTHENTICATION_REQUIRED;
				}
				else if(e1.contains("Relaying disallowed")) //No I18N
				{
					//Relaying disallowed..........
					this.threadErrorCode = Constants.DC_RELAYING_DISALLOWED;
				}
				else if(e1.contains("Connection closed")) //No I18N
				{
					//Connection closed without indication.
					this.threadErrorCode = Constants.SMTP_CONNECTION_CLOSED;
				}
				else if(e1.contains("Address rejected")) //No I18N
				{
					this.threadErrorCode = Constants.DC_ADDRESS_REJECTED;
				}
				else if(e1.contains("plaintext connection?")) //No I18N
				{
					this.threadErrorCode = Constants.SSL_NOT_SPPORTED;
				}
				else if(e1.contains("Must issue a STARTTLS command first")) //No I18N
				{
					this.threadErrorCode = Constants.DC_TLS_NOT_ENABLED;
				}
				else if(e1.contains("Access denied")) //No I18N
				{
					this.threadErrorCode = Constants.SMTP_ACCESS_DENIED;
				}
				else if(e1.contains("Daily sending quota exceeded")) //No I18N
				{
					this.threadErrorCode = Constants.SMTP_DAILY_QUOTA_EXCEEDED;
				}
				else
				{
					this.threadErrorCode = Constants.DC_EXCEPTION_ERR;
					if(ObjectHolder.isSite24x7())
					{
						Util.sendMail("Mail Server Exception - SMTP-"+smtpId, e1, Constants.SMTP_DEBUG_EMAILID,Constants.SMTP_DEBUG_EMAILID+",laxmikanth.sadula@zohocorp.com");//No I18N
					}
				}
			}
			catch(Exception ex)
			{
				EUMLog.log(module, smtpId+" : Exception occured in EmailException/CatchBlock"+ex); //No I18N
				EUMLog.log(module, Util.getStackTrace(ex));
			}
		}
		finally
		{
			Constants.smtpWorkerThreadCount--;
		}
	}
}
